/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomizeTagUtils {
    private static final String DATA_TYPE_DATE = "date";
    private static final String DATA_TYPE_STRING = "string";
    private static final String DATA_TYPE_NUMBER = "number";
    private static final String DATA_TYPE_NUMERIC = "numeric";
    private static final String DATA_TYPE_BOOLEAN = "boolean";

    public static TagDefinition createTagDefinition() {
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode(UUID.randomUUID().toString());
        tagDefinition.setName("\u968f\u673a\u6807\u7b7e");
        tagDefinition.setCustomize(Boolean.valueOf(true));
        return tagDefinition;
    }

    public static List<TagDefinition> createTagDefinitions() {
        ArrayList<TagDefinition> tagDefinitions = new ArrayList<TagDefinition>();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode(UUID.randomUUID().toString());
        tagDefinition.setName("\u968f\u673a\u6807\u7b7e");
        tagDefinition.setCustomize(Boolean.valueOf(true));
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    public static List<TagDefinition> createOrderTagDefinitions(String value) {
        ArrayList<TagDefinition> tagDefinitions = new ArrayList<TagDefinition>();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setTmTagCode("ORDER_" + value);
        tagDefinition.setTmTagValue(value);
        tagDefinition.setCode("ORDER");
        tagDefinition.setName("\u987a\u5e8f\u6807\u7b7e");
        tagDefinition.setDescription("\u6392\u5e8f\u4f7f\u7528");
        tagDefinition.setCategory("ORDER");
        tagDefinition.setInterpreterServiceName("");
        tagDefinition.setCustomize(Boolean.valueOf(false));
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    public static List<TagDefinition> createTemplateMiddleTagDefinitions() {
        ArrayList<TagDefinition> tagDefinitions = new ArrayList<TagDefinition>();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setTmTagCode("TEMPLATE_CHARGE_APPROVAL_TEMPLATE_MIDDLE");
        tagDefinition.setCode("TEMPLATE_CHARGE_APPROVAL_TEMPLATE_MIDDLE");
        tagDefinition.setName("\u662f\u5426\u91cd\u8981\u5c5e\u6027");
        tagDefinition.setDescription("\u662f\u5426\u91cd\u8981\u5c5e\u6027");
        tagDefinition.setCategory("BUSINESS");
        tagDefinition.setCustomize(Boolean.valueOf(false));
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    public List<TagDefinition> createDataTypeTagDefinitions(MetadataField metadataField) {
        ArrayList<TagDefinition> tagDefinitions = new ArrayList<TagDefinition>();
        tagDefinitions.add(CustomizeTagUtils.createDataTypeDefinition(metadataField));
        return tagDefinitions;
    }

    public static void createDataTypeTagDefinition(MetadataField metadataField) {
        ArrayList<TagDefinition> tagDefinitions = metadataField.getTagDefinitions();
        if (CollectionUtils.isEmpty((Collection)tagDefinitions)) {
            tagDefinitions = new ArrayList<TagDefinition>();
            tagDefinitions.add(CustomizeTagUtils.createDataTypeDefinition(metadataField));
        } else {
            boolean addFlag = true;
            for (TagDefinition tagDefinition : tagDefinitions) {
                if (!StringUtils.isNotBlank((CharSequence)tagDefinition.getInterpreterServiceName())) continue;
                addFlag = false;
            }
            if (addFlag) {
                tagDefinitions.add(CustomizeTagUtils.createDataTypeDefinition(metadataField));
            }
        }
        metadataField.setTagDefinitions(tagDefinitions);
    }

    public static TagDefinition createDataTypeDefinition(MetadataField metadataField) {
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setName("\u6570\u636e\u7ec4\u4ef6");
        tagDefinition.setDescription("\u6570\u636e\u7ec4\u4ef6");
        tagDefinition.setCategory("DATATYPE");
        tagDefinition.setCustomize(Boolean.valueOf(false));
        if (DATA_TYPE_DATE.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode("TYPE_DATE");
            tagDefinition.setCode("TYPE_DATE");
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        } else if (DATA_TYPE_STRING.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode("TYPE_STRING");
            tagDefinition.setCode("TYPE_STRING");
            if ("uibot__operationReason".equals(metadataField.getName())) {
                tagDefinition.setInterpreterServiceName("textAreaTagInterpreter");
            } else {
                tagDefinition.setInterpreterServiceName("typeStringTagInterpreter");
            }
        } else if (DATA_TYPE_NUMBER.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode("TYPE_NUMBER");
            tagDefinition.setCode("TYPE_NUMBER");
            tagDefinition.setInterpreterServiceName("typeNumberTagInterpreter");
        } else if (DATA_TYPE_BOOLEAN.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode("TYPE_BOOLEAN");
            tagDefinition.setCode("TYPE_BOOLEAN");
            tagDefinition.setInterpreterServiceName("typeBooleanTagInterpreter");
        } else if (DATA_TYPE_NUMERIC.equals(metadataField.getDataType())) {
            tagDefinition.setTmTagCode("TYPE_NUMERIC");
            tagDefinition.setCode("TYPE_NUMERIC");
            tagDefinition.setInterpreterServiceName("typeNumericTagInterpreter");
        }
        return tagDefinition;
    }

    public static List<TagDefinition> buildAttachmentFileTagDefs(String tagName, String tagDescription) {
        ArrayList tagDefinitions = Lists.newArrayList();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode("BUSINESS_ATTACHMENT_FILE");
        tagDefinition.setName(tagName);
        tagDefinition.setDescription(tagDescription);
        tagDefinition.setCategory("BUSINESS");
        tagDefinition.setInterpreterServiceName("attachmentFileInterpreter");
        tagDefinition.setCustomize(Boolean.valueOf(false));
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }
}

