/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

@Service(value="flatService")
public class FlatDataSourceService
implements DataSourceProcessService {
    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (dataSourceProcessor.getParas() == null || queryResult == null || queryResult.getApiMetadataCollection() == null || queryResult.getApiMetadataCollection().getMasterApiMetadata() == null || queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().size() == 0) {
            return;
        }
        Map paras = (Map)dataSourceProcessor.getParas();
        if (!paras.containsKey("flatData")) {
            return;
        }
        String detailName = (String)paras.get("flatData");
        MetadataField root = (MetadataField)queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0);
        Optional<MetadataField> optionalMetadataField = root.getSubFields().stream().filter(metadataField -> detailName.equals(metadataField.getName()) && metadataField.getSubFields() != null && metadataField.getSubFields().size() > 0).findFirst();
        if (optionalMetadataField.isPresent()) {
            ArrayList detailSubFields = new ArrayList();
            MetadataField detailField = optionalMetadataField.get();
            detailSubFields.addAll(detailField.getSubFields());
            root.getSubFields().forEach(parentMetadataField -> {
                if (!detailName.equals(parentMetadataField.getName()) && detailSubFields.stream().filter(metadataField1 -> metadataField1.getName().equals(parentMetadataField.getName())).count() == 0L) {
                    detailSubFields.add(parentMetadataField);
                }
            });
            root.setSubFields(detailSubFields);
            List<String> dataKeys = detailSubFields.stream().filter(metadataFieldDTO -> BooleanUtils.isTrue((Boolean)metadataFieldDTO.getBusinessKey())).map(MetadataField::getName).collect(Collectors.toList());
            if (dataKeys != null && dataKeys.size() > 0) {
                dataSourceBase.setDataKeys(dataKeys);
                queryResult.setDataKeys(dataKeys);
            }
        }
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (dataSourceProcessor.getParas() == null || queryResult.getData() == null || queryResult.getData().size() == 0) {
            return;
        }
        Map paras = (Map)dataSourceProcessor.getParas();
        if (!paras.containsKey("flatData")) {
            return;
        }
        String detailName = (String)paras.get("flatData");
        ArrayList newData = new ArrayList();
        queryResult.getData().forEach(item -> item.entrySet().forEach(rootRowItem -> {
            if (detailName.equals(rootRowItem.getKey()) && rootRowItem.getValue() instanceof List) {
                List detailItemList = (List)rootRowItem.getValue();
                newData.addAll(detailItemList);
                detailItemList.forEach(detailItem -> item.entrySet().forEach(parentRow -> {
                    if (!detailName.equals(parentRow.getKey()) && !detailItem.containsKey(parentRow.getKey())) {
                        detailItem.put(parentRow.getKey(), parentRow.getValue());
                    }
                }));
                return;
            }
        }));
        if (newData.size() > 0) {
            queryResult.resetData(newData);
        }
    }
}

