/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanItemsDTO;
import com.digiwin.athena.atdm.thememap.dto.TargetDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planSelectSuggestService")
public class PlanSelectSuggestService
implements DataSourceProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanSelectSuggestService.class);
    private static final String PLAN_SELECT_OPTIONS = "KM_PLAN_SELECT_SUGGEST_OPTIONS";
    @Autowired
    private CommonThemeMapService commonThemeMapService;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = queryResult.getApiMetadataCollection();
        if (apiMetadataCollection == null) {
            return;
        }
        if (queryResult == null || CollectionUtils.isEmpty((Collection)queryResult.getData())) {
            return;
        }
        if (apiMetadataCollection != null && apiMetadataCollection.getMasterApiMetadata() != null && CollectionUtils.isNotEmpty((Collection)apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
            List metadataFields = ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields();
            MetadataField planTypeReasonField = new MetadataField();
            planTypeReasonField.setUiBot("Y");
            planTypeReasonField.setName(PLAN_SELECT_OPTIONS);
            planTypeReasonField.setDataType("object");
            HashMap<String, Integer> planPrecision = new HashMap<String, Integer>();
            planPrecision.put("length", 120);
            planTypeReasonField.setPrecision(planPrecision);
            planTypeReasonField.setDescription(MessageUtils.getMessageByCurrentLanguage((Object)"{\"zh_TW\":\"\u65b9\u6848\u9078\u64c7\u7406\u7531\",\"en_US\":\"Reasons for plan selection\",\"zh_CN\":\"\u65b9\u6848\u9009\u62e9\u7406\u7531\"}"));
            metadataFields.add(planTypeReasonField);
        }
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (queryResult == null || CollectionUtils.isEmpty((Collection)queryResult.getData())) {
            return;
        }
        try {
            List suggestPlanItemsDTOS;
            if (dataSourceProcessor.getParas() == null || !(dataSourceProcessor.getParas() instanceof Map)) {
                return;
            }
            Map map = (Map)dataSourceProcessor.getParas();
            if (!map.containsKey("decisionCode") || map.get("decisionCode") == null) {
                log.warn(String.format("\u914d\u7f6e\u4efb\u52a1%s\u7684\u6570\u636e\u5904\u7406\u5668[planSelectSuggestService]\u7f3a\u5c11decisionCode\u5b57\u6bb5\u6216\u8005\u503c", executeContext.getTmActivityId()));
                return;
            }
            if (!map.containsKey("planField")) {
                log.warn(String.format("\u914d\u7f6e\u4efb\u52a1%s\u7684\u6570\u636e\u5904\u7406\u5668[planSelectSuggestService]\u7f3a\u5c11planField\u5b57\u6bb5\u6216\u8005\u503c", executeContext.getTmActivityId()));
                return;
            }
            String decisionCode = map.get("decisionCode").toString();
            String planField = map.get("planField").toString();
            ArrayList datas = queryResult.getData();
            if (map.containsKey("keyFields") && map.get("keyFields") != null && map.get("keyFields") instanceof List) {
                List fields = (List)map.get("keyFields");
                ArrayList newDatas = new ArrayList();
                for (Map map2 : datas) {
                    HashMap newData = new HashMap();
                    newData.put("__DATA_KEY", map2.get("__DATA_KEY"));
                    for (Object field : fields) {
                        if (!map2.containsKey(field)) continue;
                        newData.put(field.toString(), map2.get(field));
                    }
                    newDatas.add(newData);
                }
                datas = newDatas;
            }
            if ((suggestPlanItemsDTOS = this.commonThemeMapService.getSuggestPlan(executeContext.getLocale(), decisionCode, (List)datas)) == null) {
                return;
            }
            for (SuggestPlanItemsDTO suggestPlanItemsDTO : suggestPlanItemsDTOS) {
                Map map3;
                if (StringUtils.isEmpty((CharSequence)suggestPlanItemsDTO.getKey()) || !CollectionUtils.isNotEmpty((Collection)suggestPlanItemsDTO.getTargets()) || (map3 = queryResult.findByKey(suggestPlanItemsDTO.getKey())) == null) continue;
                ArrayList options = new ArrayList();
                for (TargetDTO target : suggestPlanItemsDTO.getTargets()) {
                    HashMap<String, String> option = new HashMap<String, String>();
                    option.put("title", target.getPlanName());
                    option.put("value", target.getPlanId());
                    options.add(option);
                }
                map3.put(PLAN_SELECT_OPTIONS, options);
                if (!map3.containsKey(planField) || options.size() <= 0) continue;
                map3.put(planField, ((Map)options.get(0)).get("value"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
    }
}

