package com.digiwin.athena.atdm.datasource.datasource.converter;

import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.datasource.AFCOperationDataSource;
import com.digiwin.athena.atdm.datasource.datasource.AtmcChangeDataSource;
import com.digiwin.athena.atdm.datasource.datasource.AtmcOverdueTaskDataSource;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceConstants;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceSet;
import com.digiwin.athena.atdm.datasource.datasource.DataUniformotySource;
import com.digiwin.athena.atdm.datasource.datasource.EspDataSource;
import com.digiwin.athena.atdm.datasource.datasource.LcdpDataSource;
import com.digiwin.athena.atdm.datasource.datasource.LeftJoinDataSource;
import com.digiwin.athena.atdm.datasource.datasource.MergeDataSource;
import com.digiwin.athena.atdm.datasource.datasource.PtmDataSource;
import com.digiwin.athena.atdm.datasource.datasource.RawDataSource;
import com.digiwin.athena.atdm.datasource.datasource.RecycleDataSource;
import com.digiwin.athena.atdm.datasource.datasource.SdDataSource;
import com.digiwin.athena.atdm.datasource.datasource.ShelvedDataSource;
import com.digiwin.athena.atdm.datasource.datasource.TmDataSource;
import com.digiwin.athena.atdm.datasource.datasource.TmFormulaDataSource;
import com.digiwin.athena.atdm.datasource.datasource.UnionDataSource;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.datasource.dto.DataSourceSetDTO;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;

public class DataSourceConverter {
    public static DataSourceSet convert(DataSourceSetDTO dataSourceSetDTO) {
        if (dataSourceSetDTO== null) {
            return null;
        }
        if (CollectionUtils.isEmpty(dataSourceSetDTO.getDataSourceList())){
            return null;
        }
        DataSourceSet dataSourceSet = new DataSourceSet();
        dataSourceSet.setDataProcess(dataSourceSetDTO.getDataProcess());
        dataSourceSet.setMainDatasource(dataSourceSetDTO.getMainDatasource());


        ArrayList<DataSourceBase> dataSourceBases = new ArrayList<>(dataSourceSetDTO.getDataSourceList().size());
        for (DataSourceDTO sourceDTO : dataSourceSetDTO.getDataSourceList()) {
            dataSourceBases.add(convert(sourceDTO,true));
        }
        dataSourceSet.setDataSourceList(dataSourceBases);
        return dataSourceSet;
    }

    public static DataSourceBase convert(DataSourceDTO dataSourceDTO, boolean isRoot) {
        DataSourceBase dataSource = null;
        switch (dataSourceDTO.getType()) {
            case UiBotConstants.ACTION_CATEGORY_ESP: {
                EspDataSource espDataSource = new EspDataSource();
                dataSource = espDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_TM: {
                if (dataSourceDTO.getActionId().equals("sm_iqc.get.old") || dataSourceDTO.getActionId().equals("sm_iqc.get.new")) {
                    TmFormulaDataSource tmFormulaDataSource = new TmFormulaDataSource();
                    dataSource = tmFormulaDataSource;
                    dataSource.setAction(dataSourceDTO.getAction());
                    dataSource.setActionId(dataSourceDTO.getActionId());
                } else if (dataSourceDTO.getActionId().equals("athena_MechanismRecordGet")) {
                    TmDataSource tmDataSource = new TmDataSource();
                    dataSource = tmDataSource;
                    dataSource.setAction(dataSourceDTO.getAction());
                    dataSource.setActionId(dataSourceDTO.getActionId());
                } else if (dataSourceDTO.getActionId().equals("athena_TimeIntervalCodeGet")) {
                    TmDataSource tmDataSource = new TmDataSource();
                    dataSource = tmDataSource;
                    dataSource.setAction(dataSourceDTO.getAction());
                    dataSource.setActionId(dataSourceDTO.getActionId());
                }
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_RAW_DATA: {
                RawDataSource rawDataSource = new RawDataSource();
                rawDataSource.setRawData(dataSourceDTO.getRawData());
                dataSource = rawDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());

                break;
            }
            case UiBotConstants.ACTION_CATEGORY_SD: {
                dataSource = new SdDataSource();
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case DataSourceConstants.ACTION_CATEGORY_MIX_MERGE: {
                MergeDataSource mergeDataSource = new MergeDataSource();
                mergeDataSource.setLeft(convert(dataSourceDTO.getLeft(), false));
                if (CollectionUtils.isNotEmpty(dataSourceDTO.getRightList())) {
                    ArrayList<DataSourceBase> right = new ArrayList<>(dataSourceDTO.getRightList().size());
                    for (DataSourceDTO sourceDTO : dataSourceDTO.getRightList()) {
                        right.add(convert(sourceDTO, false));
                    }
                    mergeDataSource.setRightList(right);
                }
                dataSource = mergeDataSource;
                break;
            }
            case DataSourceConstants.ACTION_CATEGORY_MIX_UNION: {
                UnionDataSource unionDataSource = new UnionDataSource();
                if (CollectionUtils.isNotEmpty(dataSourceDTO.getUnionItems())) {
                    ArrayList<DataSourceBase> items = new ArrayList<>(dataSourceDTO.getUnionItems().size());
                    for (DataSourceDTO sourceDTO : dataSourceDTO.getUnionItems()) {
                        items.add(convert(sourceDTO, false));
                    }
                    unionDataSource.setUnionItems(items);
                    if (dataSourceDTO.getUnionItems().get(0).getAction() != null) {
                        unionDataSource.setAction(dataSourceDTO.getUnionItems().get(0).getAction());
                        unionDataSource.setActionId(dataSourceDTO.getUnionItems().get(0).getAction().getActionId());
                    }
                }
                unionDataSource.setMergeQuery(dataSourceDTO.getMergeQuery());
                dataSource = unionDataSource;
                break;
            }
            case DataSourceConstants.ACTION_CATEGORY_MIX_LEFT_JOIN: {
                LeftJoinDataSource leftJoinDataSource = new LeftJoinDataSource();
                leftJoinDataSource.setLeft(convert(dataSourceDTO.getLeft(), false));
                if (CollectionUtils.isNotEmpty(dataSourceDTO.getRightList())) {
                    ArrayList<DataSourceBase> right = new ArrayList<>(dataSourceDTO.getRightList().size());
                    for (DataSourceDTO sourceDTO : dataSourceDTO.getRightList()) {
                        right.add(convert(sourceDTO, false));
                    }
                    leftJoinDataSource.setRightList(right);
                }
                dataSource = leftJoinDataSource;
                leftJoinDataSource.setOverride(dataSourceDTO.getOverride());
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_ATMC_CHANGE: {
                AtmcChangeDataSource atmcChangeDataSource = new AtmcChangeDataSource();
                dataSource = atmcChangeDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_ATMC: {
                AtmcOverdueTaskDataSource atmcOverdueTaskDataSource = new AtmcOverdueTaskDataSource();
                dataSource = atmcOverdueTaskDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_RECYCLE: {
                RecycleDataSource recycleDataSource = new RecycleDataSource();
                dataSource = recycleDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_SHELVED_DATA: {
                ShelvedDataSource shelvedDataSource = new ShelvedDataSource();
                dataSource = shelvedDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.DATA_UNIFORMITY_SUBMIT: {
                DataUniformotySource dataUniformotySource = new DataUniformotySource();
                dataSource = dataUniformotySource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.DATA_AFC: {
                AFCOperationDataSource afcOperationDataSource = new AFCOperationDataSource();
                dataSource = afcOperationDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            case UiBotConstants.DATA_LCDP: {
                LcdpDataSource lcdpDataSource = new LcdpDataSource();
                dataSource = lcdpDataSource;
                dataSource.setAction(dataSourceDTO.getAction());
                break;
            }
            case UiBotConstants.ACTION_PTM_DATA: {
                dataSource = new PtmDataSource();
                dataSource.setAction(dataSourceDTO.getAction());
                dataSource.setActionId(dataSourceDTO.getActionId());
                break;
            }
            default: {
                break;
            }
        }
        if (dataSource != null) {
            dataSource.setDataKeys(dataSourceDTO.getDataKeys());
            dataSource.setDataSourceProcessors(dataSourceDTO.getDataSourceProcessors());
            dataSource.setLimit(dataSourceDTO.getLimit());
            dataSource.setMetadataFields(dataSourceDTO.getMetadataFields());
            dataSource.setName(dataSourceDTO.getName());
            dataSource.setSingle(dataSourceDTO.getNotArray());
            dataSource.setExtendedData(dataSourceDTO.getExtendedData());
        }

        //只有根节点才需要添加元数据
        if (isRoot && null != dataSource) {
            dataSource.setMetadataFields(dataSourceDTO.getMetadataFields());
        }
        return dataSource;
    }
}
