package com.digiwin.athena.atdm.datasource.datasource.process;


import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service("mergeData")
public class MergeProcessService  implements BuildPageDataProcessService {
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelPageData(ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResultSet queryResultSet) {
        if (queryResultSet == null){
            return;
        }
        if( CollectionUtils.isEmpty(queryResultSet.getQueryResults())){
            return;
        }

        setMainQueryResult(queryResultSet);

        QueryResult itemsQueryResult = null;
        List<Map<String,Object>> itemsData = null;
        List<Map<String,Object>> themeMapdata = null;
        for(QueryResult result : queryResultSet.getQueryResults()){
            if("data".equals(result.getDataSourceName())){
                themeMapdata = result.getData();
                break;
            }
        }

        List<Map<String,Object>> tmData = null;
        if(themeMapdata!=null && themeMapdata.size()>0){
            Map<String,Object> tmSignleMap = themeMapdata.get(0);
            if(tmSignleMap.containsKey("data") && tmSignleMap.get("data")!=null){
                tmSignleMap = (Map<String,Object>)tmSignleMap.get("data");
                if(tmSignleMap.containsKey("value")){
                    tmData = (List<Map<String,Object>>)tmSignleMap.get("value");
                }
            }
        }

        for(QueryResult result : queryResultSet.getQueryResults()){
            itemsData = null;
            itemsQueryResult = null;
            if("items_data".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_forecast".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_products".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_products_industry".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_products_unclassified".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_semiproducts".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_semiproducts_industry".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }else if("items_data_semiproducts_unclassified".equals(result.getDataSourceName())){
                itemsData = result.getData();
                itemsQueryResult = result;
            }

            if(itemsData != null) {
                mergeData(itemsData, tmData);
            }

            if(itemsQueryResult != null){
                handelMetadata(itemsQueryResult, executeContext.getIdentity(),executeContext.getTmActivityId());
            }
        }

        if(ActivityConstants.PROJECT_DETAIL.equals(executeContext.getPageCode())){
            //如果是当责者，再进行union
            unionData(queryResultSet);
        }
    }

    /**
     * 数据合并
     * @param itemsData
     * @param tmData
     */
    private void mergeData(List<Map<String,Object>> itemsData, List<Map<String,Object>> tmData){

        // item_no、inv_type、adjust_type 这3个字段为Key
        String dataKey = "item_no";
        String typeKey = "inv_type";
        String adjustKey = "adjust_type";

        if(tmData==null){
            for (Map<String, Object> item : itemsData) {
                if (!item.containsKey("adoption_result")) {
                    item.put("adoption_result", "");
                }
            }
        }else {
            for (Map<String, Object> item : itemsData) {
                if (item.containsKey(dataKey) && item.containsKey(typeKey)) {
                    String dataKeyValue = (String)item.get(dataKey);
                    String typeKeyValue = (String)item.get(typeKey);
                    String adjustKeyValue = (String)item.get(adjustKey);
                    for (Map<String, Object> tm : tmData) {
                        if (tm.containsKey(dataKey) && dataKeyValue.equals(tm.get(dataKey))
                            && tm.containsKey(typeKey) && typeKeyValue.equals(tm.get(typeKey))
                            && tm.containsKey(adjustKey) && adjustKeyValue.equals(tm.get(adjustKey))) {
                            for (String k : tm.keySet()) {
                                item.put(k, tm.get(k));
                            }
                            break;
                        }
                        item.put("adoption_result", "");
                    }
                }
            }
        }
    }

    private void handelMetadata(QueryResult itemsQueryResult,String identity,String activityId){
        ApiMetadataCollection apiMetadataCollection = itemsQueryResult.getApiMetadataCollection();
        if(apiMetadataCollection == null){
            return;
        }
        ApiMetadata apiMetadata = apiMetadataCollection.getMasterApiMetadata();
        List<MetadataField> metadataFieldList = apiMetadata.getResponseFields().get(0).getSubFields();
        MetadataField atop = new MetadataField();
        atop.setName("adoption_result");
        atop.setRequired(true);
        atop.setDescription(messageUtils.getMessage("uibot.activity.metadataField.operation") );
        atop.setDataType("string");
        atop.setDataKey("false");
        metadataFieldList.add(atop);

        //新采购间隔天数 可编辑
        if(ActivityConstants.PERFORMER.equals(identity) && "meteralStockMechanismSuggestion".equals(activityId)) {
            atop.setCanEdit(true);

            for (MetadataField field : metadataFieldList) {
                if ("new_purchase_interval_days".equals(field.getName())) {
                    field.setCanEdit(true);
                    break;
                }
            }
        }

    }

    /**
     * 项目详情union数据
     * @param queryResultSet
     */
    private void unionData(QueryResultSet queryResultSet){

        List<QueryResult> resultList = queryResultSet.getQueryResults();

        //合并数据到items_data
        List<Map<String,Object>> itemsData = null;
        for(QueryResult result : resultList){
            if("items_data".equals(result.getDataSourceName())){
                itemsData = result.getData();
                queryResultSet.setMainQueryResult(result);
                break;
            }
        }

        for(QueryResult result : resultList){
            if("items_data_forecast".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }else if("items_data_products".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }else if("items_data_products_industry".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }else if("items_data_products_unclassified".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }else if("items_data_semiproducts".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }else if("items_data_semiproducts_industry".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }else if("items_data_semiproducts_unclassified".equals(result.getDataSourceName())){
                itemsData.addAll(result.getData());
            }
        }

        //去除多余的数据源
        String[] dataKeyNames = new String[]{
            "items_data_forecast",
                "items_data_products","items_data_products_industry","items_data_products_unclassified",
                "items_data_semiproducts","items_data_semiproducts_industry","items_data_semiproducts_unclassified",
                "inv_data","inv_data_products","inv_data_semiproducts",
                "data"
        };
        for(String dataKey : dataKeyNames){
            Optional<QueryResult> result = resultList.stream().filter(x->x.getDataSourceName().equals(dataKey)).findFirst();
            if(result.isPresent()){
                resultList.remove(result.get());
            }
        }
    }

    /**
     * 设置主数据源
     * @param queryResultSet
     */
    private void setMainQueryResult(QueryResultSet queryResultSet){

        List<QueryResult> resultList = queryResultSet.getQueryResults();

        String[] dataKeyNames = new String[]{
                "items_data","items_data_forecast",
                "items_data_products","items_data_products_industry","items_data_products_unclassified",
                "items_data_semiproducts","items_data_semiproducts_industry","items_data_semiproducts_unclassified"
        };

        for(String dataKey : dataKeyNames){
            Optional<QueryResult> result = resultList.stream().filter(x->x.getDataSourceName().equals(dataKey)).findFirst();
            if(result.isPresent() && CollectionUtils.isNotEmpty(result.get().getData())){
                queryResultSet.setMainQueryResult(result.get());
            }
        }

    }
}
