package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author：SYQ
 * @date：2022/5/13
 */
@Service("retainAbnormalAndAddColumnService")
public class RetainAbnormalAndAddColumnService implements DataSourceProcessService {

    @Autowired
    private DataUnfiormityProcessor dataUnfiormityProcessor;

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        List<MetadataField> allSubFields = queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0).getSubFields();
        if(CollectionUtils.isEmpty(allSubFields)){
            allSubFields = new ArrayList<>();
        }
        MessageUtils messageUtils = SpringUtil.getBean(MessageUtils.class);
        // 将新增的两列放在最后面
        MetadataField optTypeField = new MetadataField();
        optTypeField.setName("data_uniformity_optType");
        optTypeField.setDescription(messageUtils.getMessage("data_uniformity_optType"));
        optTypeField.setDataKey("false");
        optTypeField.setDataType("string");
        optTypeField.setTagDefinitions(createTagDefs(optTypeField));
        allSubFields.add(optTypeField);

        MetadataField lastModifyTimeField = new MetadataField();
        lastModifyTimeField.setName("data_uniformity_lastModifyTime");
        lastModifyTimeField.setDescription(messageUtils.getMessage("data_uniformity_lastModifyTime"));
        lastModifyTimeField.setDataKey("false");
        lastModifyTimeField.setDataType("string");
        lastModifyTimeField.setTagDefinitions(createTagDefs(lastModifyTimeField));
        allSubFields.add(lastModifyTimeField);

        MetadataField dealTypeTimeField = new MetadataField();
        dealTypeTimeField.setName("data_uniformity_dealType");
        dealTypeTimeField.setDescription(messageUtils.getMessage("data_uniformity_dealType"));
        dealTypeTimeField.setDataKey("false");
        dealTypeTimeField.setDataType("string");
        dealTypeTimeField.setCanEdit(true);
        dealTypeTimeField.setTagDefinitions(createSelectTagDefs(dealTypeTimeField));
        allSubFields.add(dealTypeTimeField);

        queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0).setSubFields(allSubFields);
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        /*List<Map<String,Object>> dataList = queryResult.getData();
        if(CollectionUtils.isEmpty(dataList) || null == dataSourceProcessor.getParas()){
            return;
        }
        //获取异动数据
        Set<Map<String,Object>> abnormalDataSet = dataUnfiormityProcessor.comparisonData(dataList,dataSourceProcessor);
        List<Map<String,Object>> abnormalDataList = new ArrayList<>();
        //去除处理方案为结束的
        for(Map<String,Object> dataMap : abnormalDataSet){
            if("end".equals(dataMap.get("dealType"))){
                continue;
            }
            //操作方式
            String optTypeName = "0".equals(dataMap.get("optType")) ?
                    messageUtils.getMessage("data_uniformity_optType_update") :
                    messageUtils.getMessage("data_uniformity_optType_remove");
            dataMap.put("data_uniformity_optType",optTypeName);
            dataMap.put("data_uniformity_lastModifyTime",dataMap.get("lastModifyTime"));
            dataMap.put("data_uniformity_dealType","");
            abnormalDataList.add(dataMap);
        }

        int totalKeySize = queryResult.keySize();
        queryResult.setData(abnormalDataList);
        queryResult.initializeDataKey();
        queryResult.setAbnormalDataSize(abnormalDataList.size());
        queryResult.setAbnormalDataKeyIndexSize(totalKeySize - queryResult.keySize());*/
    }



    public List<TagDefinition> createTagDefs(MetadataField field) {
        List<TagDefinition> tagDefs = new ArrayList<>();
        TagDefinition typeStringTagDef = CustomizeTagUtils.createDataTypeDefinition(field);
        tagDefs.add(typeStringTagDef);
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory(TagConstant.ORDER_TAG);
        themeMapTag.setValue("99999");
        themeMapTag.setCode(TagConstant.ORDER_PREFIX + "99999");
        themeMapTag.setUiBotCode(TagConstant.ORDER_TAG);
        typeStringTagDef.setThemeMapTag(themeMapTag);

        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions("99999").get(0);
        tagDefs.add(orderTagDef);
        orderTagDef.setThemeMapTag(themeMapTag);
        return tagDefs;
    }


    private List<TagDefinition> createSelectTagDefs(MetadataField field){
        MessageUtils messageUtils = SpringUtil.getBean(MessageUtils.class);
        List<TagDefinition> tagDefs = new ArrayList<>();
        //排序tag
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory(TagConstant.ORDER_TAG);
        themeMapTag.setValue("99999");
        themeMapTag.setCode(TagConstant.ORDER_PREFIX + "99999");
        themeMapTag.setUiBotCode(TagConstant.ORDER_TAG);
        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions("99999").get(0);
        orderTagDef.setThemeMapTag(themeMapTag);
        tagDefs.add(orderTagDef);
        //下拉选择tag
        TagDefinition selectTagDef = new TagDefinition();
        selectTagDef.setCode(TagConstant.DATA_UNIFORMITY_ABNORMAL);
        selectTagDef.setName(field.getName());
        selectTagDef.setDescription(field.getDescription());
        selectTagDef.setCategory(TagConstant.CATEGORY_BUSINESS);
        selectTagDef.setInterpreterServiceName("selectInterpreter");
        selectTagDef.setCustomize(false);
        //下拉选项
        Map<String,Object> extendedInfo = new HashMap<>();
        selectTagDef.setExtendedInfo(extendedInfo);
        Map<String,Object> optionsMap = new HashMap<>();
        extendedInfo.put("option",optionsMap);

        optionsMap.put("ignore",messageUtils.getMessage("data_uniformity_dealType_ignore"));
        optionsMap.put("end",messageUtils.getMessage("data_uniformity_dealType_end"));
        tagDefs.add(selectTagDef);
        return tagDefs;
    }
}
