package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Order(40)
@Service("commit-data-to-bpm")
class CommitDataToBpmActionExecutor implements ActionExecutor {

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"commit-data-to-bpm";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action==null || parameter==null){
            return ExecuteResult.ok();
        }
        //获取活动参数中做查询的数据、提交的数据、需要处理的数据
        SubmitAction bpmAction = null;
        if (CollectionUtils.isNotEmpty( action.getAttachActions()) ){
            Optional<SubmitAction> optionalAction = action.getAttachActions().stream()
                    .filter(action1 -> UiBotConstants.ACTION_CATEGORY_BPM.equals( action1.getCategory()))
                    .findFirst();
            if (optionalAction.isPresent()){
                bpmAction = optionalAction.get();
            }
        }

        if (bpmAction == null){
            return ExecuteResult.ok();
        }else{
            bpmAction.setExtendParas(action.getExtendParas());
            if (bpmAction.getExtendParas() == null){
                bpmAction.setExtendParas(new HashMap<>());
            }
            bpmAction.getExtendParas().put("dataSource","parentRequest");
        }
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }
}
