package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Order(0)
@Service("filter-selected-data-action")
class FilterSelectedDataActionExecutor implements ActionExecutor {

    @Autowired
    private MessageUtils messageUtils;
    /**
     * 处理的类型是什么
     *
     * @return
     */
    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT + "filter-selected-data-action";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        Map<String, Object> extendParas = action.getExtendParas();
        if (MapUtils.isEmpty(extendParas)
                || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0027.getErrCode(), messageUtils.getMessage("exception.KG.action.submitVariableName"));
        }

        String submitVariableName = extendParas.get("submitVariableName").toString();
        if (!parameter.containsKey(submitVariableName)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0028.getErrCode(), messageUtils.getMessage("exception.submit.data")
                    + submitVariableName + messageUtils.getMessage("exception.check.KG.config"));
        }

        Object submitDataObj = parameter.get(submitVariableName);
        List<Map<String, Object>> datas = new ArrayList<>();
        if (null != submitDataObj) {
            if (submitDataObj instanceof Map) {
                datas.add((Map<String, Object>) submitDataObj);
            } else if (submitDataObj instanceof Collection) {
                datas.addAll((List<Map<String, Object>>) parameter.get(submitVariableName));
            } else {
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0029.getErrCode(), messageUtils.getMessage("exception.submit.data2")
                        + submitVariableName + messageUtils.getMessage("exception.data.type.error"));
            }
        }

        if (0 == datas.size()) {
            return ExecuteResult.ok();
        }
        String detailField = null;
        if (extendParas.containsKey("detailField")) {
            detailField = extendParas.get("detailField").toString();
        }
        List<Map<String, Object>> selectedRows = new ArrayList<>();
        for (Map<String, Object> data : datas) {
            if (data.containsKey(UiBotConstants.UIBOT_FIELDS_CHECKED)) {
                if (isChecked(data)) {
                    //如果有明细数据
                    if (CollectionUtils.isNotEmpty(MapUtil.get(data, detailField, List.class))) {
                        List<Map<String, Object>> detail = (List<Map<String, Object>>) data.get(detailField);
                        List<Map<String, Object>> selectedDetail = new ArrayList<>();
                        for (Map<String, Object> detailItem : detail) {
                            if (isChecked(detailItem)) {
                                selectedDetail.add(detailItem);
                            }
                        }
                        if (!selectedDetail.isEmpty()) {
                            data.put(detailField, selectedDetail);
                            selectedRows.add(data);
                        }
                    }else{
                        selectedRows.add(data);
                    }
                } else {
                    //如果有明细数据
                    if (CollectionUtils.isNotEmpty(MapUtil.get(data, detailField, List.class))) {
                        List<Map<String, Object>> detail = (List<Map<String, Object>>) data.get(detailField);
                        List<Map<String, Object>> selectedDetail = new ArrayList<>();
                        for (Map<String, Object> detailItem : detail) {
                            if (isChecked(detailItem)) {
                                selectedDetail.add(detailItem);
                            }
                        }
                        if (!selectedDetail.isEmpty()) {
                            data.put(detailField, selectedDetail);
                            selectedRows.add(data);
                        }
                    }
                }
            } else {
                //如果没有多选，默认为选择全部数据
                selectedRows = datas;
                break;
            }
        }

        parameter.put(submitVariableName, selectedRows);
        return ExecuteResult.ok();
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(submitExecuteContext.isMinSplit() && actionExecuteReq.getWorkItemIdToData() != null){
            Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
            // 修改入参 分批提交的也需要修改
            workItemIdToData.forEach((k,v)-> this.execute(submitExecuteContext,actionExecuteReq.getParentExecuteResult(),actionExecuteReq.getAction(),v));
        }
        return ActionExecutor.super.execute(actionExecuteReq);
    }

    boolean isChecked(Map<String, Object> data) {
        if (data.containsKey(UiBotConstants.UIBOT_FIELDS_CHECKED)) {
            Object checkedValue = data.get(UiBotConstants.UIBOT_FIELDS_CHECKED);
            if (checkedValue != null
                    && checkedValue instanceof Boolean) {
                return (boolean) checkedValue;
            }
        }
        return false;
    }
}
