package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.lcdp.CommonLcdpService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Order(0)
@Service("LcdpActionExecutor")
class LcdpActionExecutor implements ActionExecutor {

    @Autowired
    private CommonLcdpService commonLcdpService;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.DATA_LCDP + ActionConstants.SPLIT ;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (action.getParas() == null) {
            action.setParas( new HashMap<>());
        }
        Map<String, Object> paras= action.getParas();
       // Map<String, Object>  comData = combine(data,paras);
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            paras.put(stringObjectEntry.getKey(),stringObjectEntry.getValue());
        }
        HashMap result = commonLcdpService.execute(executeContext, action);
        ExecuteResult executeResult = ExecuteResult.withData(result);
        executeResult.setCompleted(false);
        return  executeResult;
    }


    /**
     * 将两个map中key相同的value合并起来
     * @param map1
     * @param map2
     * @return
     */
   /* public static Map combine(Map map1, Map map2) {
        try {
            Set set = map1.keySet();
            Iterator iterator = set.iterator();
            Object key = null;
            for (int index = 0; index < set.size(); index++) {
                key = iterator.next();
                Object valueTemp1 = map1.get(key);
                Object valueTemp2 = map2.get(key);
                if (null == valueTemp1 || null == valueTemp2) {
                    continue;
                }
                if(valueTemp1 instanceof Map && valueTemp2 instanceof Map) {
                    Map value = new HashMap();
                    if (valueTemp1 instanceof Map) {
                        Map value1 = (Map) valueTemp1;
                        value.putAll(value1);
                    }
                    if (valueTemp2 instanceof Map) {
                        Map value2 = (Map) valueTemp2;
                        value.putAll(value2);
                    }
                    map1.put(key, value);
                }
            }
        }catch (Exception e){

        }

        return map1;
    }*/


}
