package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务引擎-提交数据
 */
@Order(100)
@Slf4j
@Service("ptmSubmitDataActionExecutor")
class PtmSubmitDataActionExecutor extends MergeDataActionExecutor {

    @Autowired
    private CommonPtmService commonPtmService;

    @Autowired
    private CommonAtmcService atmcService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_PTM + ActionConstants.SPLIT+ "submit-data" ;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        setProcessVariables(action,parameter);
        if(parameter.size() >0) {
            //优先取list，没有就取第一个放进list，如果还不符合条件，就没救了
            List dispatchData = new ArrayList();
            boolean isFind= false;
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                if (!stringObjectEntry.getKey().startsWith("uibot")){
                    if(stringObjectEntry.getValue() instanceof Collection){
                        dispatchData = (List)stringObjectEntry.getValue();
                        action.getParas().put("modelSchema",stringObjectEntry.getKey());
                        action.getParas().put("dispatchData",stringObjectEntry.getValue());
                        isFind = true;
                        break;
                    }
                }
            }
            if(!isFind){
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    if (!stringObjectEntry.getKey().startsWith("uibot")){
                        dispatchData.add(stringObjectEntry);
                        break;
                    }
                }
            }
            action.getParas().put("dispatchData",dispatchData);
        }



        //dispatchData如果为空数组，就不执行
        boolean executed = true;
        if(action.getParas().containsKey("dispatchData")){
            Object dd = action.getParas().get("dispatchData");
            if(dd!=null && dd instanceof List){
                List dispatchData = (List)dd;
                executed =  dispatchData.size() > 0;
            }
        }
        if(executed) {
            SubmitAction newAction = translateAction(executeContext, action);
            //log.info("[ptm-submit-data] {}", JsonUtils.objectToString(newAction));
            commonPtmService.execute(newAction);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(false);
        return result;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        setProcessVariables(action,parameter);
        if(parameter.size() >0) {
            //取的就是parameter中的值放在 action.getParas()中
            //优先取list，没有就取第一个放进list，如果还不符合条件，就没救了
            List dispatchData = new ArrayList();
            boolean isFind= false;
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                if (!stringObjectEntry.getKey().startsWith("uibot")){
                    if(stringObjectEntry.getValue() instanceof Collection){
                        dispatchData = (List)stringObjectEntry.getValue();
                        action.getParas().put("modelSchema",stringObjectEntry.getKey());
                        action.getParas().put("dispatchData",stringObjectEntry.getValue());
                        isFind = true;
                        break;
                    }
                }
            }
            if(!isFind){
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    if (!stringObjectEntry.getKey().startsWith("uibot")){
                        dispatchData.add(stringObjectEntry);
                        break;
                    }
                }
            }
            action.getParas().put("dispatchData",dispatchData);
        }

        SubmitAction mergeAction = action;
        if(action!= action.getMergeDataAction()){
            mergeAction = action.getMergeDataAction();
        }
        Map<String,Object> paras = null;
        SubmitAction newAction = translateAction(executeContext, action);
        if (newAction != null){
            if(mergeAction.getExtendParas()!=null && mergeAction.getExtendParas().containsKey(UiBotConstants.MERGED_SUBMIT_DATA)){
                paras = (Map<String, Object>)mergeAction.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
                List<Map> dispatchDataList = (List<Map>)paras.get("dispatchData");
                dispatchDataList.addAll((List<Map>)newAction.getParas().get("dispatchData"));
            }else{
                //第一个 action
                paras = newAction.getParas();
                if(mergeAction.getExtendParas()==null){
                    mergeAction.setExtendParas(new HashMap<>());
                }
                mergeAction.getExtendParas().put(UiBotConstants.MERGED_SUBMIT_DATA, paras);
            }
        }

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        //合并的任务，直接用准备好的参数执行
        Map<String, Object> paras = (Map<String, Object>) action.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);

        SubmitAction newAction = new SubmitAction();
        newAction.setParas(paras);

        ActionServiceId serviceId = new ActionServiceId();
        serviceId.setName(action.getServiceId().getName());
        serviceId.setServiceUri(action.getServiceId().getServiceUri());
        newAction.setServiceId(serviceId);

        //dispatchData如果为空数组，就不执行
        boolean executed = true;
        if(newAction.getParas().containsKey("dispatchData")){
            Object dd = newAction.getParas().get("dispatchData");
            if(dd!=null && dd instanceof List){
                List dispatchData = (List)dd;
                executed = dispatchData != null && dispatchData.size() > 0;
            }
        }
        if(executed) {
//            log.info("[ptm-submit-data] {}", JsonUtils.objectToString(newAction));
            commonPtmService.execute(newAction);
        }

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private SubmitAction translateAction(SubmitExecuteContext executeContext, SubmitAction submitAction){
        SubmitAction action = new SubmitAction();
        Map<String,Object> oldParas = submitAction.getParas();
        Map ptmData = executeContext.getPtmData();
        if(ptmData==null){
            ptmData = atmcService.getPtmData(executeContext.getBacklogId());
        }
        Map<String,Object> paras = new HashMap<>();
        paras.put("backlogId", ptmData.get("ptmBacklogId"));
        paras.put("performerType", oldParas.get("performerType"));
        paras.put("performerId", oldParas.get("performerId"));
        if(oldParas.containsKey("agentPerformerId")){
            paras.put("agentPerformerId", oldParas.get("agentPerformerId"));
        }
        if(oldParas.containsKey("processVariables")){
            paras.put("processVariables", oldParas.get("processVariables"));
        }
        List<Map> dispatchDataList = new ArrayList<>();
        Map dispatchData = new HashMap();
        dispatchData.put("workItemId", ptmData.get("ptmWorkItemId"));
        //存在dispatch中---data为空的情况
        if (ObjectUtils.isEmpty(oldParas.get("dispatchData"))){
            return null;
        }
        dispatchData.put("data", oldParas.get("dispatchData"));
        dispatchDataList.add(dispatchData);
        paras.put("modelSchema",oldParas.get("modelSchema"));
        paras.put("dispatchData", dispatchDataList);
        action.setParas(paras);

        ActionServiceId serviceId = new ActionServiceId();
        serviceId.setName(submitAction.getServiceId().getName());
        serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
        action.setServiceId(serviceId);

        return action;
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(submitExecuteContext.isMinSplit()){
            SubmitAction action = actionExecuteReq.getAction();
            Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
            if(workItemIdToData == null){
                workItemIdToData = Maps.newHashMapWithExpectedSize(1);
                workItemIdToData.put(submitExecuteContext.getBacklogId(),actionExecuteReq.getData());
            }
            setProcessVariables(action,actionExecuteReq.getData());
            // 构造参数
            Map<String, Object> paras = action.getParas();
            List<Map<String,Object>> dispatchData = Lists.newArrayListWithExpectedSize(workItemIdToData.size());
            workItemIdToData.forEach((k,v)->{
                Map<String,Object> row = Maps.newHashMapWithExpectedSize(2);
                row.put("workItemId",k);
                boolean hasData = false;
                for(Map.Entry<String,Object> entry:v.entrySet()){
                    String key = entry.getKey();
                    if(!key.startsWith("uibot")){
                        Object value = entry.getValue();
                        if(value instanceof List){
                            paras.put("modelSchema",key);
                            row.put("data",value);
                            hasData = true;
                            break;
                        }
                    }
                }
                if(!hasData){
                    for(Map.Entry<String,Object> entry:v.entrySet()){
                        String key = entry.getKey();
                        if(!key.startsWith("uibot")){
                            row.put("data",Lists.newArrayList(entry));
                            hasData = true;
                            break;
                        }
                    }
                }
                if(hasData){
                    dispatchData.add(row);
                }
            });
            if(dispatchData.size()>0){
                paras.put("dispatchData",dispatchData);
                Long id = MapUtils.getLong(paras, "backlogId");
                if(id == null && submitExecuteContext.getPtmData() != null){
                    paras.put("backlogId", MapUtils.getLong(submitExecuteContext.getPtmData(), "ptmBacklogId"));
                }
                commonPtmService.execute(action);
            }
            ExecuteResult result = ExecuteResult.ok();
            result.setCompleted(false);
            return result;
        }
        return super.execute(actionExecuteReq);
    }
}
