package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 服务编排的执行器
 */
@Service
@Slf4j
public class SdActionExecutor implements ActionExecutor {
    @Autowired
    private CommonSmartDataService commonSmartDataService;


    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_SD + ActionConstants.SPLIT;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        log.info("服务编排开始执行,执行ActionId:{}", action.getActionId());
        Map paras = action.getParas();
        if (paras == null) {
            paras = new HashMap();
        }
        paras.putAll(data);
        Map<String, Object> businessUnit = executeContext.getBusinessUnit();
        if (businessUnit == null) {
            businessUnit = action.getBusinessUnit();
        }
        /**
         * atdm--->ExecutionEngine--->服务编排。
         * ExecutionEngine透传入参给服务编排，入参是{}，没问题；入参是null，则抛NPE异常。
         * 这里兼容null和空Map情形
         *
         * @since BUG-102200
         * @modify by majfa
         */
        if (null == businessUnit) {
            businessUnit = new HashMap<>();
        }
        Map<String, Object> extendedFields = Maps.newHashMap();
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        HashMap execute = commonSmartDataService.execute(executeContext.getAuthoredUser().getTenantId(), action.getActionId(), paras, businessUnit, extendedFields);
        log.info("服务编执行结束:{}", JsonUtils.objectToString(execute));
        return ExecuteResult.ok();
    }
}
