package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 发起手动项目，数据提交到SmartData
 * 流程引擎
 *
 * @author majianfu
 * @date 2021/5/21
 * @since
 */
@Service
public class StartManualProjectActionExecutor implements ActionExecutor {
    @Autowired
    private CommonSmartDataService commonSmartDataService;


    private static final String SUBMIT_DATA_ACTION_ID_KEY = "startActionId";

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_MANUAL_PROJECT + ActionConstants.SPLIT;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult,SubmitAction action, Map<String, Object> data) {
        if (MapUtils.isEmpty(data)) {
            return ExecuteResult.empty();
        }

        Map<String, Object> paraMap = null;
        // paraMap中的第一条数据，即为提交的数据
        String actionId = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (SUBMIT_DATA_ACTION_ID_KEY.equals(entry.getKey())) {
                actionId = String.valueOf(entry.getValue());
                continue;
            }
            paraMap = (Map<String, Object>) entry.getValue();
        }
        if (paraMap == null || paraMap.isEmpty()) {
            return ExecuteResult.empty();
        }

        // 实际发起的项目code
        String actualProjectCode = (String) paraMap.remove("adapterToStartProject");
        if (StringUtils.isNotBlank(actualProjectCode)) {
            actionId = actualProjectCode;
        }

        ExecuteResult result = ExecuteResult.ok();
        result.setData(new HashMap<>());
        // 拿到应用 code，透传给 sd 的执行引擎，执行引擎再透传给 esp，esp 给到业务中台用作运营统计分析
        Map<String,Object> extendedFields = Maps.newHashMap();
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        List<Object> retList = executeSubmitAction(executeContext.getAuthoredUser().getTenantId(), actionId, paraMap, extendedFields);
        result.getData().put("projectCardInfo",retList);
        return result;
    }

    private List<Object> executeSubmitAction(String tenantId, String actionId, Map<String, Object> paraMap, Map extendedFields) {
        // 页面传过来的eocInfo: ["company", "company;;factory"]
        List<Map<String, Object>> eocMapList = (List<Map<String, Object>>) paraMap.remove("eocInfo");

        List<Object> retList  = new ArrayList<>();
        Object retMap;
        if (CollectionUtils.isEmpty(eocMapList)) {
            // actionId值其实为activityCode
            Map[] paras = new Map[]{paraMap};
            retMap = commonSmartDataService.executeForManualProject(tenantId, actionId, paras, Collections.emptyMap(), extendedFields);
            retList.add(retMap);
            return retList;
        }
        // 录入了n条eoc信息，就构造n个requestBody，发送n次请求
        for (Map<String, Object> eocMap : eocMapList) {
            Object forEachMap;
            Map<String, Object> newParaMap = new HashMap<>();
            newParaMap.putAll(paraMap);
            // 使用eocMap和eocInfo
            newParaMap.put("eocMap", eocMap);
            newParaMap.put("eocInfo", eocMap);

            Map[] paras = new Map[]{newParaMap};
            // actionId值其实为activityCode
            forEachMap = commonSmartDataService.executeForManualProject(tenantId, actionId, paras, eocMap, extendedFields);
            retList.add(forEachMap);
        }
        return retList;
    }

}
