package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Order(40)
@Service("start-new-process")
class StartNewProcessActionExecutor extends MergeDataActionExecutor implements ActionExecutor {

    @Autowired
    @Qualifier("BpmActionExecutor")
    ActionExecutor bpmDispatchAction;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private CommonSmartDataService commonSmartDataService;

    @Autowired
    private TokenVerifyService tokenVerifyService;

    @Autowired
    private MessageUtils messageUtils;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"start-new-process";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();
        String actionId = submitParameter.getActionId();
        HashMap paras = submitParameter.getParas();
        String tenantId = submitParameter.getTenantId();
        Map extendedFields = new HashMap();
        if(!StringUtils.isEmpty(executeContext.getTraceId())){
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        // 拿到应用 code，透传给 sd 的执行引擎，执行引擎再透传给 esp，esp 给到业务中台用作运营统计分析
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, action.getBusinessUnit(), extendedFields);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {

        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();

        //如果是合并，合并任务的临时处理，把数据放到临时变量，后面再统一提交
        mockSubmitData(action,  submitParameter);

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private void mockSubmitData(SubmitAction action,SubmitParameter submitParameter) {
        String actionId = submitParameter.getActionId();
        List<Map<String, Object>> submitParas = submitParameter.getSubmitParas();
        String newProcessVariableName = submitParameter.getNewProcessVariableName();
        String[] newProcessFieldList = submitParameter.getNewProcessFieldList();
        HashMap paras = submitParameter.getParas();
        String tenantId = submitParameter.getTenantId();

        //region模拟执行,将参数放到 extendParas 中。
        Map<String,Object> extendParas = action.getExtendParas();


        //放到每行数据中
        for (String key : newProcessFieldList) {
            if(!Objects.equals(key, newProcessVariableName)){
                for (Map<String, Object> submitPara : submitParas) {
                    if (paras.containsKey(key)) {
                        submitPara.put(key, paras.get(key));
                    }
                }
            }
        }

        //把外面的去掉
        for (String key : newProcessFieldList) {
            if(!Objects.equals(key, newProcessVariableName)) {
                if (paras.containsKey(key)) {
                    paras.remove(key);
                }
            }
        }
//        extendParas.put(UiBotConstants.MERGED_SUBMIT_DATA, startNewProcessMap);

        if (action!= action.getMergeDataAction()) {
            //把所有数据合并到指定的action上
            Map<String, Object> mergedData = (Map<String, Object>) action.getMergeDataAction().getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
            Map mergedParas = (Map) mergedData.get("paras");
            List<Map>  mergedSubmitParas = (List<Map>) mergedParas.get(newProcessVariableName);
            mergedSubmitParas.addAll((List<Map>) paras.get(newProcessVariableName));
        }else {

            Map<String,Object> startNewProcessMap = new HashMap<>();
            startNewProcessMap.put("tenantId", tenantId);
            startNewProcessMap.put("actionId", actionId);
            startNewProcessMap.put("paras", paras);
            startNewProcessMap.put("eoc", action.getBusinessUnit());
            extendParas.put(UiBotConstants.MERGED_SUBMIT_DATA, startNewProcessMap);
        }
        //endregion
    }


    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        //合并的任务，直接用准备好的参数执行
        Map<String, Object> startNewProcessMap = (Map<String, Object>) action.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
        String tenantId = startNewProcessMap.get("tenantId").toString();
        String actionId = startNewProcessMap.get("actionId").toString();
        Map paras = (Map) startNewProcessMap.get("paras");
        Map eoc = (Map) startNewProcessMap.get("eoc");
        Map extendedFields = new HashMap();
        if(!StringUtils.isEmpty(executeContext.getTraceId())){
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        // 拿到应用 code，透传给 sd 的执行引擎，执行引擎再透传给 esp，esp 给到业务中台用作运营统计分析
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, eoc, extendedFields);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;

    }

    private class SubmitParameter {
        private SubmitExecuteContext executeContext;
        private SubmitAction action;
        private Map<String, Object> parameter;
        private String actionId;
        private List<Map<String, Object>> submitParas;
        private String newProcessVariableName;
        private String[] newProcessFieldList;
        private HashMap paras;
        private String tenantId;

        public SubmitParameter(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
            this.executeContext = executeContext;
            this.action = action;
            this.parameter = parameter;
        }

        public String getActionId() {
            return actionId;
        }

        public List<Map<String, Object>> getSubmitParas() {
            return submitParas;
        }

        public String getNewProcessVariableName() {
            return newProcessVariableName;
        }

        public String[] getNewProcessFieldList() {
            return newProcessFieldList;
        }

        public HashMap getParas() {
            return paras;
        }

        public String getTenantId() {
            return tenantId;
        }

        public SubmitParameter invoke() {
            if (action == null || parameter == null
                    || executeContext == null
                    || executeContext.getBacklogId() == null
                    || executeContext.getBpmData() == null
                    || action.getExtendParas() == null
                    || action.getExtendParas().size() == 0) {

                throw BusinessException.create(ErrorCodeEnum.NUM_500_0034.getErrCode(), messageUtils.getMessage("exception.start.new.process.error"));
            }
            //抓到关联的流程变量,需要发起的新的活动id
            Map<String, Object> bpmParas = executeContext.getBpmData();
            actionId = null;
            if (bpmParas.containsKey("actionId")) {
                actionId = bpmParas.get("actionId").toString();
            }


            //获取活动参数中做查询的数据、提交的数据、需要处理的数据
            submitParas = null;
            String compareFields = null;
            //当前任务用来查询数据的变量名
            String processVariableName = "";
            //新的流程中需要传递的参数集合
            String newProcessFields = null;
            //提交数据的变量名，根据这个名称来获取提交的数据集合
            String submitVariableName = "";
            //发起新的流程中携带数据的变量名
            newProcessVariableName = "";
            for (Map.Entry<String, Object> stringObjectEntry : action.getExtendParas().entrySet()) {
                switch (stringObjectEntry.getKey()) {
                    case "actionId":
                        actionId = stringObjectEntry.getValue().toString();
                        break;
                    case "newProcessVariableName":
                        newProcessVariableName = stringObjectEntry.getValue().toString();
                        break;
                    case "processVariableName":
                        processVariableName = stringObjectEntry.getValue().toString();
                        break;
                    case "submitVariableName":
                        submitVariableName = stringObjectEntry.getValue().toString();
                        if (parameter.containsKey(submitVariableName)) {
                            submitParas = (List<Map<String, Object>>) parameter.get(submitVariableName);
                        } else {
                            throw BusinessException.create(ErrorCodeEnum.NUM_500_0035.getErrCode(), String.format(messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                        }
                        break;
                    case "dataKeys":
                        compareFields = stringObjectEntry.getValue().toString();
                        break;
                    case "newProcessFields":
                        newProcessFields = stringObjectEntry.getValue().toString();
                        break;
                }
            }
            if (StringUtils.isEmpty(actionId)) {
                throw new IllegalArgumentException("actionId is empty");
            }
            if (StringUtils.isEmpty(newProcessVariableName)) {
                throw new IllegalArgumentException("newProcessVariableName is empty");
            }
            if (newProcessFields == null || "".equals(newProcessFields)) {
                throw new IllegalArgumentException("newProcessFields is empty");
            }

            //把提交的部分数据发起新的流程
            newProcessFieldList = newProcessFields.split(";");
            paras = new HashMap();
            for (String key : newProcessFieldList) {
                if (parameter.containsKey(key)) {
                    if (key.equals(submitVariableName)){
                        paras.put(newProcessVariableName, submitParas);

                    }else {
                        paras.put(newProcessVariableName, parameter.get(key));
                    }
                } else {
                    paras.put(key, bpmParas.get(key));
                }
            }
            //发起新流程时，总是加一个当前userId的值
            if(!paras.containsKey("SYSTEM_USER_ID")) {
                paras.put("SYSTEM_USER_ID", AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            }

            String backlogId = action.getExecuteContext().getBacklogId().toString();
            paras.put("originalBacklogId", backlogId);
            paras.put("originalQueryVariableName", processVariableName);
            paras.put("originalProcessSerialNumber", action.getExecuteContext().getProcessSerialNumber());
            paras.put("dataKeys", compareFields);
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            tenantId = authoredUser.getTenantId();
            if(StringUtils.isEmpty(tenantId) && !StringUtils.isEmpty(AppAuthContextHolder.getContext().getProxyToken())){
                authoredUser = tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
                tenantId = authoredUser.getTenantId();
            }
            return this;
        }
    }
}
