package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;
abstract class TaskEngineActionExecutorBase implements ActionExecutor {

    protected void setProcessVariables(SubmitAction action, Map<String, Object> parameter) {
        if (action.getParas() == null) {
            action.setParas(new HashMap<>());
        }
        if (!CollectionUtils.isEmpty(parameter)
                && !CollectionUtils.isEmpty(action.getExtendParas())
                && action.getExtendParas().containsKey("submitVariableName")) {
            String processVariableName = action.getExtendParas().get("submitVariableName").toString();
            Map para = action.getParas();
            Map<String, Object> processVariable = new HashMap<>();
            para.put("processVariables", processVariable);
            if ("SUBMIT_DATA".equals(processVariableName)) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    processVariable.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else if (parameter.containsKey(processVariableName)) {
                processVariable.put(processVariableName, parameter.get(processVariableName));
            }
        }
    }
}
