package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.datasource.process.ActivityUtils;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 签核-退回重签
 */
@Order(100)
@Service("taskEngineReapprovalActionExecutor")
class TaskEngineReapprovalActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonPtmService commonPtmService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT+ "reapprove" ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }
    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        setProcessVariables(action,parameter);
        ActivityUtils.addDispatchData(action.getParas(), parameter);
        commonPtmService.execute(action);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }
}
