package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.util.EspParameterConverterUtils;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 任务引擎-项目卡退回
 */
@Order(100)
@Slf4j
@Service
class TaskEngineReturnActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonPtmService commonPtmService;

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT + "task-return";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,
                                 ExecuteResult parentExecuteResult,
                                 SubmitAction action,
                                 Map<String, Object> parameter) {
        Map<String, Object> paras = Maps.newHashMapWithExpectedSize(1);
        List<Map<String,Object>> paramList = Lists.newArrayList();
        if(parameter.containsKey(UiBotConstants.ACTION_RETURN_PARAMS_KEY)){
            Object params = parameter.get(UiBotConstants.ACTION_RETURN_PARAMS_KEY);
            if(params instanceof List){
                List<SubmitActionDTO> submitActionDTOList = (List<SubmitActionDTO>) params;
                for (SubmitActionDTO actionDTO : submitActionDTOList) {
                    SubmitAction returnAction = actionDTO.getAction();
                    Map<String, Object> convertedData = actionDTO.getData();
                    if (returnAction.getActionParams() != null) {
                        convertedData = EspParameterConverterUtils.convert(convertedData, returnAction.getActionParams(), returnAction);
                    }
                    // 合并数据与常量
                    if (MapUtils.isNotEmpty(returnAction.getParas())) {
                        Map<String, Object> comData = EspParameterConverterUtils.combine(convertedData, returnAction.getParas());
                        if (MapUtils.isNotEmpty(comData)) {
                            convertedData = comData;
                        }
                    }
                    paramList.add(createReturnParam(executeContext,returnAction,convertedData));
                }
            }

        }else {
            paramList.add(createReturnParam(executeContext,action,parameter));
        }

        paras.put("params",paramList);
        action.setParas(paras);
        log.info("[task-return] {}", action);
        commonPtmService.execute(action);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private Map<String, Object> createReturnParam(
            SubmitExecuteContext executeContext,
            SubmitAction action,Map<String, Object> parameter){
        setProcessVariables(action,parameter);
        Map<String, Object> dispatchData = Maps.newHashMapWithExpectedSize(2);
        if (parameter.size() > 0) {
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("uibot")) {
                    dispatchData.put(key, entry.getValue());
                    break;
                }
            }
        }
        parsePerformerType(action.getParas(),executeContext.getPageCode());
        Map<String, Object> rowParas = action.getParas();
        Object activityId = rowParas.remove("activity_id");
        Object targetActivityId = rowParas.remove("target_activity_id");
        Object targetSchema = rowParas.remove("targetSchema");
        rowParas.put("activityId",activityId);
        rowParas.put("targetActivityId",targetActivityId);
        if(targetSchema != null){
            Object remove = rowParas.remove(String.valueOf(targetSchema));
            dispatchData.put(UiBotConstants.ACTION_TARGET_RETURN_DATA,remove);
        }
        rowParas.put("dispatchData",dispatchData);
        return rowParas;
    }

    /**
     * 解析出执行者类型：非代理人、代理人、辅助这行者、超级管理员
     */
    private Integer parsePerformerType(Map<String, Object> actionParas,String pageCode) {
        if(ActivityConstants.PROJECT_DETAIL.equals(pageCode)){
            return 999;
        }
        if (MapUtils.isEmpty(actionParas)) {
            // 非代理人
            return 0;
        }

        Object performerType = actionParas.get("performerType");
        if (null == performerType) {
            // 非代理人
            return 0;
        } else {
            // 0：非代理人，1：代理人，2：辅助执行者，999：超级管理员
            return Integer.valueOf(performerType.toString());
        }
    }
}
