package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import com.digiwin.athena.atdm.activity.domain.TmAction;
import com.digiwin.athena.atdm.activity.service.BaseActionCreateService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Order(20)
@Service("update-table-field")
class UpdateTableFieldActionExecutor implements ActionExecutor {


    @Autowired
    private CommonESPService commonEspService;

    @Autowired
    BaseActionCreateService submitBaseActionCreateService;

    @Autowired
    private CommonThemeMapQueryService commonThemeMapQueryService;

    @Autowired
    private MessageUtils messageUtils;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"update-table-field";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        Map<String, Object> extendParas = action.getExtendParas();
        if (MapUtils.isEmpty(extendParas)
                || !extendParas.containsKey("updateValue")
                || !extendParas.containsKey("table")
                || !extendParas.containsKey("dataKeys")
                || !extendParas.containsKey("submitVariableName")
                || !extendParas.containsKey("isBatchSubmit")) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0010.getErrCode(), messageUtils.getMessage("exception.update.field.action.lack.config"));
        }
        String table =  extendParas.get("table").toString();
        Object updateValue = extendParas.get("updateValue");
        String dataKeys = extendParas.get("dataKeys").toString();
        String submitVariableName = extendParas.get("submitVariableName").toString();
        if (!parameter.containsKey(submitVariableName)){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0010.getErrCode(), messageUtils.getMessage("exception.submit.data")+submitVariableName+messageUtils.getMessage("exception.check.KG.config"));
        }
        List<Map<String, Object>> datas = (List<Map<String, Object>>) parameter.get(submitVariableName);
        String detailField =null;
        if (extendParas.containsKey("detailField")){
            detailField = extendParas.get("detailField").toString();
        }
        
        List<Map<String, String>> conditions = null;
        if (extendParas.containsKey("condition")){
            conditions = ( List<Map<String, String>>)extendParas.get("condition") ;
        }
        //是否支持分批
        boolean isBatchSubmit =  BooleanUtils.toBoolean(extendParas.get("isBatchSubmit").toString());

        Map<String, Object> paras =  createSubmitParas(table,dataKeys,conditions,updateValue,datas,isBatchSubmit,detailField);
        if (paras == null){
            return ExecuteResult.ok();
        }
        String tenantId = "";
        if(StringUtils.hasText(action.getExecuteContext().getProxyToken())){
            tenantId = action.getExecuteContext().getTenantId();
        }else{
            tenantId =  action.getExecuteContext().getAuthoredUser().getTenantId();
        }
        TmAction tmAction = createTmAction(tenantId);
        SubmitAction submitAction = submitBaseActionCreateService.createSubmitAction(tmAction,tenantId, action.getExecuteContext().getBusinessUnit());
        submitAction.setParas(paras);
        commonEspService.execute(executeContext,submitAction);
        return ExecuteResult.ok();
    }

    /**
     * 定义执行ESP
     *
     * @param tenantId
     * @return
     */
    private TmAction createTmAction(String tenantId) {
        TmAction tmAction = new TmAction();
        tmAction.setServiceName("fields.value.update");
        tmAction.setType("ESP");
        tmAction.setActionId("esp_fields.value.update");
        ActionInfo actionInfo = commonThemeMapQueryService.getActionInfo(tenantId, tmAction.getActionId());
        if (actionInfo != null) {
            tmAction.setProductName(actionInfo.getProductName());
            tmAction.setUrl(actionInfo.getUrl());
            tmAction.setServiceName(actionInfo.getServiceName());
        }
        return tmAction;
    }


    private  Map<String, Object> createSubmitParas(String table , String dataKeys,List<Map<String, String>> conditions, Object updateValue,List<Map<String, Object>> datas, boolean isBatch, String detailField) {

        List<Map<String, Object>> dataList = new ArrayList<>();

        String[] dataKeyArray = dataKeys.split(";");
        List<Map<String, Object>> needUpdateDatas = new ArrayList<>();
        //如果是分批，则判断uibot_checked是否选择，否则全部处理
        if (isBatch){
            for (Map<String, Object> data : datas) {
                boolean uibotChecked = data.get("uibot_checked") == null ? false : BooleanUtils.toBoolean(data.get("uibot_checked").toString());
                if (uibotChecked) {
                    needUpdateDatas.add(data);
                }
                //如果有明细数据也要处理
                if (detailField !=null && data.get(detailField) != null) {
                    List<Map<String, Object>> detail = (List<Map<String, Object>>) data.get(detailField);
                    for (Map<String, Object> detailItem : detail) {
                        boolean targetDetailFieldValueUibotChecked = detailItem.get("uibot_checked") == null ? false : BooleanUtils.toBoolean(detailItem.get("uibot_checked").toString());
                        if (targetDetailFieldValueUibotChecked) {
                            needUpdateDatas.add(detailItem);
                        }
                    }
                }
            }
        } else {
            for (Map<String, Object> data : datas) {
                needUpdateDatas.add(data);
                //如果有明细数据也要处理
                if (detailField !=null && data.get(detailField) != null) {
                    List<Map<String, Object>> detail = (List<Map<String, Object>>) data.get(detailField);
                    for (Map<String, Object> detailItem : detail) {
                        needUpdateDatas.add(detailItem);
                    }
                }
            }
        }

        for (Map<String, Object> data : needUpdateDatas) {
            Map<String,Object> update = new HashMap<>();
            update.put("doc_table",table);

            if (conditions!=null && conditions.size() >0) {

                //设置条件，使用设置的条件
                int i = 1;
                for (Map<String, String> condition : conditions) {
                    if (!condition.containsKey("field") || !condition.containsKey("value")) {
                        throw BusinessException.create(ErrorCodeEnum.NUM_500_0009.getErrCode(), messageUtils.getMessage("exception.condition.need.field.value"));
                    }
                    String field = condition.get("field");
                    String value = condition.get("value");
                    String type = condition.getOrDefault("type","DATA_ROW");
                    if ("DATA_ROW".equals(type)) {
                        if (data.containsKey(value)) {
                            String keyValue = data.get(value) == null ? "" : data.get(value).toString();
                            update.put("condition" + i + "_field", field);
                            update.put("condition" + i + "_field_value", keyValue);
                        }
                    }
                    else  if ("CONSTANT".equals(type)){
                        update.put("condition" + i + "_field", field);
                        update.put("condition" + i + "_field_value", value);
                    }

                    i++;
                }
            }
            else {
                //如果没有设置条件，使用datakey来自动生成条件
                for (int i = 0; i < dataKeyArray.length; i++) {
                    String key = dataKeyArray[i];
                    if (data.containsKey(key)) {
                        String keyValue = data.get(key) == null ? "" : data.get(key).toString();
                        update.put("condition" + (i+1) + "_field", key);
                        update.put("condition" + (i+1) + "_field_value", keyValue);
                    }
                }
            }
            update.put("update_detail",updateValue);
            dataList.add(update);
        }
        if (dataList.size() ==0){
            return null;
        }
        Map<String, Object> paras = new HashMap<>();
        paras.put("doc_data", dataList);
        return paras;
    }

}
