package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.datasource.process.ActivityUtils;
import com.digiwin.athena.atdm.workflow.CommonWorkflowService;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
@Service
@Slf4j
public class WorkflowActionExecutor implements ActionExecutor {

    @Autowired
    private CommonWorkflowService commonWorkflowService;

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_WORKFLOW + ActionConstants.SPLIT ;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        log.info("发起工作流流程:{}", JsonUtils.objectToString(action));
        ExecuteResult ok = ExecuteResult.ok();
        ok.setCompleted(true);
        ActionServiceId serviceId = action.getServiceId();
        String name = serviceId.getName();
        Map<String, Object> paras = action.getParas();
        // 根据不同的按钮类型构造不同的参数
        switch (name){
            case "workflow-act-submit":
            case "workflow-act-agree":
            case "workflow-act-disagree":
            case "workflow-act-add":
            case "workflow-act-return":
            case "workflow-act-dispatch":
                ActivityUtils.addDispatchData(paras,data);
                break;
            case "workflow-abort": // 转排
                serviceId.setServiceUri("api/process/abort");
                break;
            case "workflow-invoke":
                List<Map<String, Object>> mapList = ActivityUtils.addDispatchData(paras, data);
                Map<String,Object> processEOC = Maps.newHashMapWithExpectedSize(2);
                processEOC.put("eoc_company_id","");
                Map<String,Object> variables = Maps.newHashMapWithExpectedSize(2);
                Map<String, Object> map = null;
                if(mapList != null){
                    map = mapList.get(0);
                    processEOC.put("eoc_company_id", MapUtils.getObject(map,"eoc_company_id",""));
                    processEOC.put("eoc_site_id", map.get("eoc_site_id"));
                    if(map.containsKey("operation_unit_v2")){
                        processEOC.put("operation_unit_v2",map.get("operation_unit_v2"));
                    }
                    variables.put("sourceIds",map.get(UiBotConstants.DATA_SOURCE_DATA_KEY));
                }
                serviceId.setServiceUri("api/process/invoke");
                paras.put("processEoc",processEOC);
                AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
                paras.put("initiatorId", authoredUser.getUserId());
                paras.put("initiatorName", authoredUser.getUserName());
                if(!paras.containsKey("emergency")){
                    paras.put("emergency", 50);
                }
                paras.put("variables", variables);
                Map<String, Object> execute = commonWorkflowService.execute(action);
                Map dataMap = MapUtils.getMap(execute, "data");
                if(dataMap != null){
                    // 送审的需要把流程序号存入然后通过attachAction进行修改数据
                    Object serialNumber = dataMap.get("serialNumber");
                    log.info("发起送审获取流程序号:{}",serialNumber);
                    if(map != null){
                        map.put("serial_number",serialNumber);
                    }
                }
                ok.setData(map);
                return ok;
        }
        // 调用工作流接口
        commonWorkflowService.execute(action);
        return ok;
    }
}
