package com.digiwin.athena.atdm.log;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * author:wzq
 * date:2023/12/17
 * description:
 **/
@Component
@Slf4j
public class LogRecordSubscriber {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    public static final String MQ_ROUTING_NAME = "athena.troubleshoot.log";
    public static final String MQ_EXCHANGE_NAME = "athena.troubleshoot";
    public static final String APP_ID = "atdm";
    public static final String URL = "/api/atdm/v1/action/submit/task";
    public static final String MERGE_TASK_URL = "/api/atdm/v1/action/submit/mergeTask";
    public static final String PTX_ID = "troubleshoot:PtxId";
    public static final String NOT_SUPPORT_RETRY = "notSupportRetry";

    /**
     * 订阅任务的具体处理
     */
    @Subscribe
    public void logRecord(LogRecordEvent logRecordEvent) {
        log.info(PTX_ID);
        AuthoredUser authoredUser = logRecordEvent.getAuthoredUser();
        LogRecordDTO content = logRecordEvent.getContent();
        HttpServletRequest request = logRecordEvent.getRequest();

        try {
            LogRecordDTO logRecordDTO = logRecordEvent.getContent();
            SubmitAction submitAction;
            if (URL.equals(logRecordDTO.getUrl())) {
                SubmitActionDTO submitActionDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(content.getInputValue()), SubmitActionDTO.class);
                submitAction = LogRecordUtils.getSupportRetry(submitActionDTO);
            } else {
                MergeSubmitActionDTO submitActionDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(content.getInputValue()), MergeSubmitActionDTO.class);
                submitAction = LogRecordUtils.getMergeSupportRetry(submitActionDTO.getActionMerge());
            }
            content.setOperateType((submitAction != null && submitAction.getSupportRetry()) ? null : NOT_SUPPORT_RETRY);
            content.setOperateDesc(submitAction != null ? submitAction.getActionId() : null);
            content.setAppid(APP_ID);
            content.setCreateName(authoredUser.getUserName());
            content.setTenantsid(authoredUser.getTenantSid());
            content.setTenantid(authoredUser.getTenantId());
            content.setUserid(authoredUser.getUserId());
            content.setTraceid(MDC.get("PtxId"));

            Map<String, Object> headers = new HashMap<>();
            Enumeration<String> headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                headers.put(headerName, headerValue);
            }
            content.setHeader(JsonUtils.objectToString(headers));

            rabbitTemplate.convertAndSend(MQ_EXCHANGE_NAME, MQ_ROUTING_NAME, JsonUtils.objectToString(content));
        } catch (Exception e) {
            log.error("deal logRecord error{}", e);
        }

    }
}
