/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.executor.MergeDataActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Order(value=40)
@Service(value="start-new-process")
class StartNewProcessActionExecutor
extends MergeDataActionExecutor
implements ActionExecutor {
    @Autowired
    @Qualifier(value="BpmActionExecutor")
    ActionExecutor bpmDispatchAction;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Autowired
    private MessageUtils messageUtils;

    StartNewProcessActionExecutor() {
    }

    public String supportKey() {
        return "UIBOT:start-new-process";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();
        String actionId = submitParameter.getActionId();
        HashMap paras = submitParameter.getParas();
        String tenantId = submitParameter.getTenantId();
        HashMap<String, String> extendedFields = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)executeContext.getTraceId())) {
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        this.commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, action.getBusinessUnit(), extendedFields);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();
        this.mockSubmitData(action, submitParameter);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private void mockSubmitData(SubmitAction action, SubmitParameter submitParameter) {
        String actionId = submitParameter.getActionId();
        List<Map<String, Object>> submitParas = submitParameter.getSubmitParas();
        String newProcessVariableName = submitParameter.getNewProcessVariableName();
        String[] newProcessFieldList = submitParameter.getNewProcessFieldList();
        HashMap paras = submitParameter.getParas();
        String tenantId = submitParameter.getTenantId();
        Map extendParas = action.getExtendParas();
        for (String key : newProcessFieldList) {
            if (Objects.equals(key, newProcessVariableName)) continue;
            for (Map<String, Object> submitPara : submitParas) {
                if (!paras.containsKey(key)) continue;
                submitPara.put(key, paras.get(key));
            }
        }
        for (String key : newProcessFieldList) {
            if (Objects.equals(key, newProcessVariableName) || !paras.containsKey(key)) continue;
            paras.remove(key);
        }
        if (action != action.getMergeDataAction()) {
            Map mergedData = (Map)action.getMergeDataAction().getExtendParas().get("mergedSubmitData");
            Map mergedParas = (Map)mergedData.get("paras");
            List mergedSubmitParas = (List)mergedParas.get(newProcessVariableName);
            mergedSubmitParas.addAll((List)paras.get(newProcessVariableName));
        } else {
            HashMap<String, Object> startNewProcessMap = new HashMap<String, Object>();
            startNewProcessMap.put("tenantId", tenantId);
            startNewProcessMap.put("actionId", actionId);
            startNewProcessMap.put("paras", paras);
            startNewProcessMap.put("eoc", action.getBusinessUnit());
            extendParas.put("mergedSubmitData", startNewProcessMap);
        }
    }

    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        Map startNewProcessMap = (Map)action.getExtendParas().get("mergedSubmitData");
        String tenantId = startNewProcessMap.get("tenantId").toString();
        String actionId = startNewProcessMap.get("actionId").toString();
        Map paras = (Map)startNewProcessMap.get("paras");
        Map eoc = (Map)startNewProcessMap.get("eoc");
        HashMap<String, String> extendedFields = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)executeContext.getTraceId())) {
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        this.commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, eoc, extendedFields);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private class SubmitParameter {
        private SubmitExecuteContext executeContext;
        private SubmitAction action;
        private Map<String, Object> parameter;
        private String actionId;
        private List<Map<String, Object>> submitParas;
        private String newProcessVariableName;
        private String[] newProcessFieldList;
        private HashMap paras;
        private String tenantId;

        public SubmitParameter(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
            this.executeContext = executeContext;
            this.action = action;
            this.parameter = parameter;
        }

        public String getActionId() {
            return this.actionId;
        }

        public List<Map<String, Object>> getSubmitParas() {
            return this.submitParas;
        }

        public String getNewProcessVariableName() {
            return this.newProcessVariableName;
        }

        public String[] getNewProcessFieldList() {
            return this.newProcessFieldList;
        }

        public HashMap getParas() {
            return this.paras;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public SubmitParameter invoke() {
            if (this.action == null || this.parameter == null || this.executeContext == null || this.executeContext.getBacklogId() == null || this.executeContext.getBpmData() == null || this.action.getExtendParas() == null || this.action.getExtendParas().size() == 0) {
                throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0034.getErrCode(), (String)StartNewProcessActionExecutor.this.messageUtils.getMessage("exception.start.new.process.error"));
            }
            Map bpmParas = this.executeContext.getBpmData();
            this.actionId = null;
            if (bpmParas.containsKey("actionId")) {
                this.actionId = bpmParas.get("actionId").toString();
            }
            this.submitParas = null;
            String compareFields = null;
            String processVariableName = "";
            String newProcessFields = null;
            String submitVariableName = "";
            this.newProcessVariableName = "";
            for (Map.Entry stringObjectEntry : this.action.getExtendParas().entrySet()) {
                switch ((String)stringObjectEntry.getKey()) {
                    case "actionId": {
                        this.actionId = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "newProcessVariableName": {
                        this.newProcessVariableName = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "processVariableName": {
                        processVariableName = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "submitVariableName": {
                        submitVariableName = stringObjectEntry.getValue().toString();
                        if (this.parameter.containsKey(submitVariableName)) {
                            this.submitParas = (List)this.parameter.get(submitVariableName);
                            break;
                        }
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0035.getErrCode(), (String)String.format(StartNewProcessActionExecutor.this.messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                    }
                    case "dataKeys": {
                        compareFields = stringObjectEntry.getValue().toString();
                        break;
                    }
                    case "newProcessFields": {
                        newProcessFields = stringObjectEntry.getValue().toString();
                    }
                }
            }
            if (StringUtils.isEmpty((Object)this.actionId)) {
                throw new IllegalArgumentException("actionId is empty");
            }
            if (StringUtils.isEmpty((Object)this.newProcessVariableName)) {
                throw new IllegalArgumentException("newProcessVariableName is empty");
            }
            if (newProcessFields == null || "".equals(newProcessFields)) {
                throw new IllegalArgumentException("newProcessFields is empty");
            }
            this.newProcessFieldList = newProcessFields.split(";");
            this.paras = new HashMap();
            for (String key : this.newProcessFieldList) {
                if (this.parameter.containsKey(key)) {
                    if (key.equals(submitVariableName)) {
                        this.paras.put(this.newProcessVariableName, this.submitParas);
                        continue;
                    }
                    this.paras.put(this.newProcessVariableName, this.parameter.get(key));
                    continue;
                }
                this.paras.put(key, bpmParas.get(key));
            }
            if (!this.paras.containsKey("SYSTEM_USER_ID")) {
                this.paras.put("SYSTEM_USER_ID", AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            }
            String backlogId = this.action.getExecuteContext().getBacklogId().toString();
            this.paras.put("originalBacklogId", backlogId);
            this.paras.put("originalQueryVariableName", processVariableName);
            this.paras.put("originalProcessSerialNumber", this.action.getExecuteContext().getProcessSerialNumber());
            this.paras.put("dataKeys", compareFields);
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            this.tenantId = authoredUser.getTenantId();
            if (StringUtils.isEmpty((Object)this.tenantId) && !StringUtils.isEmpty((Object)AppAuthContextHolder.getContext().getProxyToken())) {
                authoredUser = StartNewProcessActionExecutor.this.tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
                this.tenantId = authoredUser.getTenantId();
            }
            return this;
        }
    }
}

