/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=40)
@Service(value="start-new-project")
class TaskEngineStartNewProjectActionExecutor
extends TaskEngineActionExecutorBase {
    @Autowired
    private CommonTaskEngineService commonTaskEngineService;
    @Autowired
    private MessageUtils messageUtils;

    TaskEngineStartNewProjectActionExecutor() {
    }

    public String supportKey() {
        return "TaskEngine:start-new-project";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action == null || parameter == null || executeContext == null || executeContext.getBacklogId() == null || executeContext.getBpmData() == null || action.getExtendParas() == null || action.getExtendParas().size() == 0) {
            return ExecuteResult.ok();
        }
        Map bpmParas = executeContext.getBpmData();
        List submitParas = null;
        String compareFields = null;
        String processVariableName = "";
        String newProcessFields = null;
        String submitVariableName = "";
        String newProcessVariableName = "";
        for (Map.Entry stringObjectEntry : action.getExtendParas().entrySet()) {
            switch ((String[])stringObjectEntry.getKey()) {
                case "newProcessVariableName": {
                    newProcessVariableName = stringObjectEntry.getValue().toString();
                    break;
                }
                case "processVariableName": {
                    processVariableName = stringObjectEntry.getValue().toString();
                    break;
                }
                case "submitVariableName": {
                    submitVariableName = stringObjectEntry.getValue().toString();
                    if (parameter.containsKey(submitVariableName)) {
                        submitParas = (List)parameter.get(submitVariableName);
                        break;
                    }
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0042.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                }
                case "dataKeys": {
                    compareFields = stringObjectEntry.getValue().toString();
                    break;
                }
                case "newProcessFields": {
                    newProcessFields = stringObjectEntry.getValue().toString();
                }
            }
        }
        if (StringUtils.isEmpty((Object)newProcessVariableName)) {
            throw new IllegalArgumentException("newProcessVariableName is empty");
        }
        if (newProcessFields == null || "".equals(newProcessFields)) {
            throw new IllegalArgumentException("newProcessFields is empty");
        }
        String[] newProcessFieldList = newProcessFields.split(";");
        HashMap<String, Object> paras = new HashMap<String, Object>();
        for (String key : newProcessFieldList) {
            if (parameter.containsKey(key)) {
                if (key.equals(submitVariableName)) {
                    paras.put(newProcessVariableName, submitParas);
                    continue;
                }
                paras.put(newProcessVariableName, parameter.get(key));
                continue;
            }
            paras.put(key, bpmParas.get(key));
        }
        String backlogId = action.getExecuteContext().getBacklogId().toString();
        paras.put("originalBacklogId", backlogId);
        paras.put("originalQueryVariableName", processVariableName);
        paras.put("originalProcessSerialNumber", action.getExecuteContext().getProcessSerialNumber());
        paras.put("dataKeys", compareFields);
        action.getParas().put("processVariables", paras);
        if (parameter.size() > 0) {
            List<Map.Entry<String, Object>> dispatchData = new ArrayList();
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                if (stringObjectEntry.getKey().startsWith("uibot") || !(stringObjectEntry.getValue() instanceof Collection)) continue;
                dispatchData = (List)stringObjectEntry.getValue();
                action.getParas().put("dispatchData", stringObjectEntry.getValue());
                break;
            }
            if (CollectionUtils.isEmpty(dispatchData)) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    if (stringObjectEntry.getKey().startsWith("uibot")) continue;
                    dispatchData.add(stringObjectEntry);
                    break;
                }
            }
            action.getParas().put("dispatchData", dispatchData);
        }
        this.commonTaskEngineService.execute((Action)action);
        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }
}

