package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.dto.RefreshCardDto;
import com.digiwin.athena.atdm.abt.CommonAbtService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
@Service
@Slf4j
public class AbtActionExecutor implements ActionExecutor {
    @Autowired
    private CommonAbtService commonAbtService;

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_ABT + ActionConstants.SPLIT;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        String name = action.getServiceId().getName();
        if("abt-card-refresh".equals(name)){
            Map<String, Object> paras = action.getParas();
            Object o = paras.get("athena_refresh_card");
            if(o != null){
                if(o instanceof Map){
                    RefreshCardDto refreshCardDto = BeanUtil.mapToBean((Map<?, ?>) o, RefreshCardDto.class, true);
                    commonAbtService.refreshCard(refreshCardDto);
                }
            }
        }
        return null;
    }
}
