package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Order(120)
@Service(ActionConstants.ACTION_NAME_ATMC_TASK_NAME)
public class AtmcTaskExecutor implements ActionExecutor {

    @Autowired
    CommonAtmcService atmcService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_ATMC +ActionConstants.SPLIT ;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult,SubmitAction action, Map<String, Object> data) {

        List<Map> value = SpringUtil.getBean(CommonAtmcService.class).saveOverdueTaskDataSource(data);

        ExecuteResult result = ExecuteResult.empty();
        //该任务永远不会执行完成。由atmc自动关闭
        result.setCompleted(false);
        return  result;
    }

}
