package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.bpm.CommonBpmService;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Order(100)
@Service("BpmActionExecutor")
class BpmActionExecutor implements ActionExecutor {

    @Autowired
    CommonBpmService commonBpmService;



    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_BPM + ActionConstants.SPLIT ;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult,SubmitAction action, Map<String, Object> parameter) {

        if(Objects.equals("UIBOT_WF_ACTION_CONTAINER", action.getActionId())){
            //bpm action的容器，不直接执当前action，执行其attachActions
            if(!CollectionUtils.isEmpty(action.getAttachActions())){
                for (SubmitAction attachAction : action.getAttachActions()) {
                    attachAction.setExtendParas(action.getExtendParas());
                    executeInternal(executeContext, attachAction, parameter);
                }

                action.setAttachActions(null);
            }
        }else{
            executeInternal(executeContext, action, parameter);
        }

        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private ExecuteResult executeInternal(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {

        if (!CollectionUtils.isEmpty(parameter)
                && !CollectionUtils.isEmpty(action.getExtendParas())
                && action.getExtendParas().containsKey("submitVariableName")) {

            if (action.getParas() == null) {
                action.setParas(new HashMap<>());
            }

            String processVariableName = action.getExtendParas().get("submitVariableName").toString();
            Map para = action.getParas();
            Map<String, Object> processVariable = new HashMap<>();
            para.put("processVariable", processVariable);
            if ("SUBMIT_DATA".equals(processVariableName)) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    processVariable.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else if (parameter.containsKey(processVariableName)) {
                processVariable.put(processVariableName, parameter.get(processVariableName));
            }
        }

        if(action.getServiceId() != null && Objects.equals("reassign", action.getServiceId().getName())){
            //转派任务增加新的流程变量，适用于任务退回操作,如果是转派，将newPerformerId的值放到processVariable中，
            //  key值是 {taskId}_performerId
            //  3777，估报价-经转派的任务衍生的【退回重办】调整
            Map para = action.getParas();
            Map processVariable = null;
            if(para.containsKey("processVariable")){
               processVariable = (Map) para.get("processVariable");
            }else{
                processVariable = new HashMap();
                para.put("processVariable", processVariable);
            }
            String taskId = (String)para.get("taskId");
            taskId = MessageFormat.format("{0}_performerId", taskId);
            processVariable.put(taskId, para.get("newPerformerId"));
        }
        commonBpmService.execute(action);

        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }
}
