package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 根据待办关闭相关的 Bpm 任务
 */
@Service(ActionConstants.ACTION_NAME_CLOSE_BPM_ACTIVITY_NAME)
public class CloseBpmActivityExecutor implements ActionExecutor {

    @Autowired
    CommonAtmcService atmcService;

    /**
     * 处理的类型是什么
     *
     * @return
     */
    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT + ActionConstants.ACTION_NAME_CLOSE_BPM_ACTIVITY_NAME;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {

        Long backlogId = action.getExecuteContext().getBacklogId();
        atmcService.closeBpmActivityByBacklog(backlogId);

        return  ExecuteResult.ok();
    }
}