package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 新手动发起项目，数据提交到TaskEngine
 *
 * 数据格式：
 * 情形一：
 * {
 * "action": {
 * ......
 * },
 * "data": {
 *     "projectCode": "Jerry20230504_lcdp_mainline_project_0003",
 *     "jerry_data": [
 *         {
 *             ......
 *         }
 *     ]
 * }
 * }
 *
 * 情形二：
 * {
 * "action": {
 * ......
 * },
 * "data": {
 * "jerry_data": [
 *         {
 *             "projectCode": "Jerry20230504_lcdp_mainline_project_0003",
 *             ......
 *         }
 *  ]
 * }
 * }
 *
 * @author majianfu
 * @date 2021/9/3
 * @since
 */
@Service
public class NewStartManualProjectActionExecutor implements ActionExecutor {
    // eoc公司、工厂分隔符
    protected static final String SPLIT = ";;";

    protected static final String SUBMIT_DATA_ACTION_ID_KEY = "startActionId";
    public static final String PROJECT_CODE = "projectCode";
    public static final String ADAPTER_TO_START_PROJECT = "adapterToStartProject";

    @Resource
    private CommonTaskEngineService commonTaskEngineService;

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_MANUAL_PROJECT_NEW + ActionConstants.SPLIT;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (MapUtil.isEmpty(data)) {
            return ExecuteResult.empty();
        }
        //
        if (action.getParas() == null) {
            action.setParas(new HashMap<>());
        }

        Map<String, Object> paraMap = action.getParas();
        // paraMap中的第一条数据，即为提交的数据
        String actionId = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getKey().equals("return_request_data")) {
                continue;
            }
            if (SUBMIT_DATA_ACTION_ID_KEY.equals(entry.getKey())) {
                actionId = String.valueOf(entry.getValue());
                continue;
            }

            if (PROJECT_CODE.equals(entry.getKey()) || ADAPTER_TO_START_PROJECT.equals(entry.getKey())) {
                paraMap.put(entry.getKey(), entry.getValue());
                continue;
            }

            if (entry.getValue() instanceof Collection) {
                paraMap.put("dispatchData", entry.getValue());
                break;
            } else {
                List dispatchData = new ArrayList();
                dispatchData.add(entry.getValue());
                Map keyMap = (Map<String, Object>) entry.getValue();
                paraMap.putAll(keyMap);
                paraMap.put("dispatchData", dispatchData);
                break;
            }
            //paraMap.put(entry.getKey(),entry.getValue());
            //paraMap = (Map<String, Object>) entry.getValue();
        }
        if (MapUtil.isEmpty(paraMap)) {
            return ExecuteResult.empty();
        }

        ExecuteResult result = ExecuteResult.ok();
        result.setData(new HashMap<>());
        List<Object> retList = executeSubmitAction(executeContext.getAuthoredUser().getUserId(), actionId, paraMap);
        result.getData().put("projectCardInfo", retList);
        return result;
    }

    private List<Object> executeSubmitAction(String userId, String actionId, Map<String, Object> paraMap) {
        // 页面传过来的eocInfo: ["company", "company;;factory"]
        List<Map<String, Object>> eocMapList = (List<Map<String, Object>>) paraMap.remove("eocInfo");
        // 实际发起的项目code
        String projectCode = (String) paraMap.remove(ADAPTER_TO_START_PROJECT);
        if (StrUtil.isBlank(projectCode)) {
            //【activityConfigs中的任务配置中，pageData中需要配置projectCode】
            projectCode = (String) paraMap.remove(PROJECT_CODE);
        }
        List<Map<String, Object>> dispatchDataList = new ArrayList<>();
        if (paraMap.containsKey("dispatchData")) {
            dispatchDataList = (List) paraMap.get("dispatchData");
        }

        if (StrUtil.isBlank(projectCode) && CollectionUtil.isNotEmpty(dispatchDataList)) {
            for (Map<String, Object> dataMap : dispatchDataList) {
                if (MapUtil.isEmpty(dataMap)) {
                    continue;
                }

                projectCode = MapUtil.getStr(dataMap, ADAPTER_TO_START_PROJECT, "");
                if (StrUtil.isBlank(projectCode)) {
                    projectCode = MapUtil.getStr(dataMap, PROJECT_CODE, "");
                }

                if (StrUtil.isNotBlank(projectCode)) {
                    break;
                }
            }
        }


        List<Object> retList = new ArrayList<>();
        Map<String, Object> retMap;

        if (CollectionUtil.isEmpty(eocMapList)) {
            retMap = commonTaskEngineService.startNewProject(userId, projectCode, Collections.emptyMap(), Collections.emptyMap(), dispatchDataList);
            retList.add(retMap);
            return retList;
        }
        // 录入了n条eoc信息，发送n次请求
        for (Map<String, Object> eocMap : eocMapList) {
            Map<String, Object> forEachMap = new HashMap<>();
            forEachMap = commonTaskEngineService.startNewProject(userId, projectCode, eocMap, Collections.emptyMap(), dispatchDataList);
            retList.add(forEachMap);
        }
        return retList;
    }
}
