package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务引擎-提交数据
 */
@Order(100)
@Slf4j
@Service("ptmUpdateBpmDataActionExecutor")
class PtmUpdateBpmDataActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonPtmService commonPtmService;


    @Autowired
    private CommonAtmcService atmcService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT+ "update-data" ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }
    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        //合并的任务，直接用准备好的参数执行
        Map<String, Object> bpmData = executeContext.getBpmData();
        setUpdateData(action, parameter,bpmData);
        SubmitAction newAction = translateAction(executeContext, action,bpmData);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        commonPtmService.execute(newAction);

        return result;
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        if(BooleanUtils.isNotTrue(executeContext.isMinSplit()) || actionExecuteReq.getWorkItemIdToData() == null){
            return super.execute(actionExecuteReq);
        }
        Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        Map<Long, Map<String, Object>> workItemIdToBpmData = submitExecuteContext.getWorkItemIdToBpmData();
        List<Map<String,Object>> parasData = Lists.newArrayListWithExpectedSize(workItemIdToData.size());
        workItemIdToData.forEach((k,v)->{
            Map<String,Object> paras = new HashMap<>();
            paras.put("id", k);
            Map<String, Object> bpmData = workItemIdToBpmData.get(k);
            if(bpmData != null){
                paras.put("data", bpmData);
            }
            parasData.add(paras);
        });
        SubmitAction submitAction = actionExecuteReq.getAction();
        // TODO 暂时需要循环调用
        for (Map<String, Object> parasDatum : parasData) {
            SubmitAction action = new SubmitAction();
            action.setParas(parasDatum);
            ActionServiceId serviceId = new ActionServiceId();
            serviceId.setName(submitAction.getServiceId().getName());
            serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
            action.setServiceId(serviceId);
            commonPtmService.execute(action);
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private void setUpdateData(SubmitAction action, Map<String, Object> parameter, Map<String, Object> bpmData) {
        if (action.getParas() == null) {
            action.setParas(new HashMap<>());
        }
        if (!CollectionUtils.isEmpty(parameter) && !CollectionUtils.isEmpty(action.getActionParams())) {
            for(ActionParameterMapping act: action.getActionParams()){
                if(!StringUtils.isEmpty(act.getValue()) && parameter.containsKey(act.getValue())){
                    bpmData.put(act.getValue(),parameter.get(act.getValue()));
                    bpmData.put("_in",parameter.get(act.getValue()));
                    break;
                }
            }
        }
    }

    private SubmitAction translateAction(SubmitExecuteContext executeContext, SubmitAction submitAction,Map<String, Object>  bpmData){

        SubmitAction action = new SubmitAction();
        Map ptmData = executeContext.getPtmData();
        if(ptmData==null){
            ptmData = atmcService.getPtmData(executeContext.getBacklogId());
        }
        Map<String,Object> paras = new HashMap<>();
        paras.put("id", ptmData.get("ptmWorkItemId"));
        paras.put("data", bpmData);
        action.setParas(paras);

        ActionServiceId serviceId = new ActionServiceId();
        serviceId.setName(submitAction.getServiceId().getName());
        serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
        action.setServiceId(serviceId);

        return action;
    }
}
