package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.abt.CommonReImportService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class ReImportActionExecutor implements ActionExecutor {


    @Autowired
    private CommonReImportService commonReImportService;

    @Override
    public String supportKey() {
        return UiBotConstants.RE_IMPORT + ActionConstants.SPLIT ;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        log.info("异常数据重新导入:{}", JsonUtils.objectToString(action));
        data.put("masterId", action.getExtendParas().get("masterId"));
        Map<String,Object> tableDTO = new HashMap();
        tableDTO.put("data", data.get("basic_data_import_exception"));
        tableDTO.put("headers", action.getExtendParas().get("headers"));
        data.put("tableDTO", tableDTO);
        action.setParas(data);
        commonReImportService.execute(action);
        ExecuteResult ok = ExecuteResult.ok();
        ok.setCompleted(true);
        return ok;
    }
}
