package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *  知会后置动作执行器  回调atmc进行知会
 *  @author mengkang
 *  @date 2024/9/25
 *  @since
 */
@Slf4j
@Order(100)
@Service("signAfterActionExecutor")
class SignAfterActionExecutor extends MergeDataActionExecutor {

    @Autowired
    private CommonAtmcService atmcService;

    /**
     * 处理的类型是什么
     *
     * @return
     */
    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT + "sign-after-action";
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        execute(executeContext.getAbnormalWorkitemId(), action, parameter);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(false);
        return result;
    }

    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
        execute(executeContext.getAbnormalWorkitemId(), action, parameter);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private void execute(Long workitemId, SubmitAction action, Map<String, Object> parameter) {
        //从parameter取出知会的用户
        Map<String, Object> dataMap = (Map) parameter.get("data");
        //调用atmc进行知会
        atmcService.signNotice(2, workitemId, (List<Map<String, Object>>) dataMap.get("users"));
    }
}
