package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Order(40)
@Service("start-new-project")
class TaskEngineStartNewProjectActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonTaskEngineService commonTaskEngineService;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT +"start-new-project";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action == null || parameter == null
                || executeContext == null
                || executeContext.getBacklogId() == null
                || executeContext.getBpmData() == null
                || action.getExtendParas() == null
                || action.getExtendParas().size() == 0) {
            return ExecuteResult.ok();
        }
        //抓到关联的流程变量,需要发起的新的活动id
        Map<String, Object> bpmParas = executeContext.getBpmData();

        //获取活动参数中做查询的数据、提交的数据、需要处理的数据
        List<Map<String, Object>> submitParas = null;
        String compareFields = null;
        //当前任务用来查询数据的变量名
        String processVariableName = "";
        //新的流程中需要传递的参数集合
        String newProcessFields = null;
        //提交数据的变量名，根据这个名称来获取提交的数据集合
        String submitVariableName = "";
        //发起新的流程中携带数据的变量名
        String newProcessVariableName = "";
        for (Map.Entry<String, Object> stringObjectEntry : action.getExtendParas().entrySet()) {
            switch (stringObjectEntry.getKey()) {
                case "newProcessVariableName":
                    newProcessVariableName = stringObjectEntry.getValue().toString();
                    break;
                case "processVariableName":
                    processVariableName = stringObjectEntry.getValue().toString();
                    break;
                case "submitVariableName":
                    submitVariableName = stringObjectEntry.getValue().toString();
                    if (parameter.containsKey(submitVariableName)) {
                        submitParas = (List<Map<String, Object>>) parameter.get(submitVariableName);
                    } else {
                        throw BusinessException.create(ErrorCodeEnum.NUM_500_0042.getErrCode(), String.format(messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                    }
                    break;
                case "dataKeys":
                    compareFields = stringObjectEntry.getValue().toString();
                    break;
                case "newProcessFields":
                    newProcessFields = stringObjectEntry.getValue().toString();
                    break;
            }
        }
        if (StringUtils.isEmpty(newProcessVariableName)) {
            throw new IllegalArgumentException("newProcessVariableName is empty");
        }
        if (newProcessFields == null || "".equals(newProcessFields)) {
            throw new IllegalArgumentException("newProcessFields is empty");
        }

        //把提交的部分数据发起新的流程
        String[] newProcessFieldList = newProcessFields.split(";");
        HashMap paras = new HashMap();
        for (String key : newProcessFieldList) {
            if (parameter.containsKey(key)) {
                if (key.equals(submitVariableName)){
                    paras.put(newProcessVariableName, submitParas);

                }else {
                    paras.put(newProcessVariableName, parameter.get(key));
                }
            } else {
                paras.put(key, bpmParas.get(key));
            }
        }
        String backlogId = action.getExecuteContext().getBacklogId().toString();
        paras.put("originalBacklogId", backlogId);
        paras.put("originalQueryVariableName", processVariableName);
        paras.put("originalProcessSerialNumber", action.getExecuteContext().getProcessSerialNumber());
        paras.put("dataKeys", compareFields);

//        setProcessVariables(action,parameter);
        action.getParas().put("processVariables", paras);

        if(parameter.size() >0) {
            //优先取list，没有就取第一个放进list，如果还不符合条件，就没救了
            List dispatchData = new ArrayList();
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                if (!stringObjectEntry.getKey().startsWith("uibot")){
                    if(stringObjectEntry.getValue() instanceof Collection){
                        dispatchData = (List)stringObjectEntry.getValue();
                        action.getParas().put("dispatchData",stringObjectEntry.getValue());
                        break;
                    }
                }
            }
            if(CollectionUtils.isEmpty(dispatchData)){
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    if (!stringObjectEntry.getKey().startsWith("uibot")){
                        dispatchData.add(stringObjectEntry);
                        break;
                    }
                }
            }
            action.getParas().put("dispatchData",dispatchData);
        }

        commonTaskEngineService.execute(action);

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }


}
