package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.util.ActivityUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 任务引擎-终止任务
 */
@Order(100)
@Service("taskEngineTerminateTaskActionExecutor")
class TaskEngineTerminateTaskActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonTaskEngineService commonTaskEngineService;

    @Autowired
    private CommonPtmService ptmService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_TASK_ENGINE + ActionConstants.SPLIT+ "terminate-task" ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {

//        setProcessVariables(action,parameter);
        commonTaskEngineService.execute(action);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(BooleanUtils.isTrue(submitExecuteContext.isMinSplit())){
            SubmitAction action = actionExecuteReq.getAction();
            Map<String, Object> paras = action.getParas();
            paras.put("workItemIds", ActivityUtils.getMinSplitWorkItemIds(actionExecuteReq));
            ActionServiceId serviceId = action.getServiceId();
            serviceId.setServiceUri("api/task/card/min/split/terminate");
            ptmService.execute(action);
            ExecuteResult result = ExecuteResult.ok();
            result.setCompleted(true);
            return result;
        }
        return super.execute(actionExecuteReq);
    }
}
