package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.activity.service.BpmServiceInvokeType;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceSet;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.terminateData.CommonTerminateDataService;
import com.digiwin.athena.atdm.terminateData.dto.TerminateDataDTO;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceSetDTO;
import com.digiwin.athena.atdm.util.ActivityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

/**
 * TerminateDataExecutor Description
 *
 * @author majianfu
 * @date 2022/2/15
 * @since
 */
@Order(100)
@Slf4j
@Service("terminateDataExecutor")
public class TerminateDataExecutor extends TaskEngineActionExecutorBase {
    @Autowired
    private CommonSmartDataService commonSmartDataService;

    @Autowired
    private CommonAtmcService atmcService;

    @Autowired
    private CommonUiBotService commonUiBotService;

    @Autowired
    private CommonTerminateDataService commonTerminateDataService;

    @Autowired
    private DataSubmissionService dataSubmissionService;

    @Autowired
    private DeleteActivityBpmVariableActionExecutor deleteActivityBpmVariableActionExecutor;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    @Qualifier("asyncServiceExecutor")
    private ExecutorService executorService;

    private static final String TERMINATE_EXTEND_DATA_KEY = "uibot__terminateData_card_bk";

    private static final String TERMINATE_EXTEND_TERMINATE_DATE_TIME = "uibot__terminateDateTime";

    private static final String TERMINATE_EXTEND_INITIATE_DATE_KEY = "uibot__terminateData_initiate_card_bk";

    private static final String TERMINATE_EXTEND_TERMINATE_COMMENT = "uibot__terminateDate_comment";

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT + BpmServiceInvokeType.TerminateData.getName();
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        Map<String, Object> extendParas = action.getExtendParas();
        // 检查terminate-data  action的必须配置
        checkExtendParas(extendParas);

        // 根据submitVariableName获取提交的业务数据
        List<Map<String, Object>> pageDataList = getSubmitParas(Lists.newArrayList(data), extendParas.get("submitVariableName").toString());
        List<Map> bkList = null;
        if (null != extendParas.get(TERMINATE_EXTEND_DATA_KEY)) {
            Map cardBKInfo = (Map) (extendParas.get(TERMINATE_EXTEND_DATA_KEY));
            bkList = (List<Map>) (cardBKInfo.get("bkList"));
        } else {
            // 根据dataKeys配置 + 业务数据，构造出BK信息
            String dataKeys = extendParas.get("dataKeys").toString();

            String detailField = StrUtil.toStringOrNull(extendParas.get("detailField"));
            bkList = this.parseBK(dataKeys, detailField, pageDataList);
        }

        // 清除AI bpmData
        if (CollectionUtils.isNotEmpty(pageDataList)) {
            deleteActivityBpmVariableActionExecutor.execute(executeContext, parentExecuteResult, action, data);
        } else {
            // 将BK作为pageDataList
            pageDataList = convertBkToPageData(bkList);

            Map newData = new HashMap();
            newData.put(extendParas.get("submitVariableName").toString(), pageDataList);
            deleteActivityBpmVariableActionExecutor.execute(executeContext, parentExecuteResult, action, newData);
        }

        if (null != extendParas.get(TERMINATE_EXTEND_DATA_KEY)) {
            AuthoredUser operateAuthoredUser = (AuthoredUser) extendParas.get("operateAuthoredUser");
            Map cardBKInfo = (Map) (extendParas.get(TERMINATE_EXTEND_DATA_KEY));
            LocalDateTime terminateDateTime = (LocalDateTime) (extendParas.get(TERMINATE_EXTEND_TERMINATE_DATE_TIME));
            //获取关联任务重的终止原因
            String comment = extendParas.get(TERMINATE_EXTEND_TERMINATE_COMMENT) != null?(String)extendParas.get(TERMINATE_EXTEND_TERMINATE_COMMENT):"";
            TerminateDataDTO terminateData = buildToSaveTerminateData(executeContext, operateAuthoredUser, bkList, pageDataList, terminateDateTime,comment);
            terminateData.setActivityName(null != cardBKInfo.get("tmActivityName") ? cardBKInfo.get("tmActivityName").toString() : "");

            Map initiateCardBKInfo = (Map) (extendParas.get(TERMINATE_EXTEND_INITIATE_DATE_KEY));
            if (null != initiateCardBKInfo) {
                terminateData.setInitiateActivityId(initiateCardBKInfo.get("workItemId").toString());
                terminateData.setInitiateActivityCode(initiateCardBKInfo.get("tmActivityId").toString());
                terminateData.setInitiateActivityName(null != initiateCardBKInfo.get("tmActivityName") ? initiateCardBKInfo.get("tmActivityName").toString() : "");
            }

            // 保存被终止的数据
            commonTerminateDataService.saveTerminateData(operateAuthoredUser, terminateData);

            // 清除SmartData 数据足迹和数据一致性数据
            clearSmartDataFootprintAndComparisonData(executeContext.getTmActivityId(), operateAuthoredUser, executeContext.getBusinessUnit(), cardBKInfo);
        } else {
            // 调用ATMC，根据BK查询所有的待办项id，在对每个待办项执行终止数据逻辑
            List<Map> cardBKInfoList = atmcService.queryCardListByBk("workitem", executeContext.getBacklogId(), bkList, true);
            Map cardBKInfo = Maps.newHashMap();
            List<Map> otherCardBKInfoList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(cardBKInfoList)) {
                for (Map tmpCardBKInfo : cardBKInfoList) {
                    if (StringUtils.equals(String.valueOf(executeContext.getBacklogId()), String.valueOf(tmpCardBKInfo.get("workItemId")))) {
                        cardBKInfo = tmpCardBKInfo;
                    } else {
                        otherCardBKInfoList.add(tmpCardBKInfo);
                    }
                }
            }

            AuthoredUser authoredUser = getOperateUser(executeContext);
            LocalDateTime terminateDateTime = LocalDateTime.now();
            //终止原因
            String comment = "";
            Map<String,Object> paras = action.getParas();
            if (MapUtils.isNotEmpty(paras)){
                comment = paras.get("comment") != null?(String)paras.get("comment"):"";
            }
            TerminateDataDTO terminateData = buildToSaveTerminateData(executeContext, null, bkList, pageDataList, terminateDateTime,comment);
            if (MapUtils.isNotEmpty(cardBKInfo)) {
                terminateData.setActivityName(null != cardBKInfo.get("tmActivityName") ? cardBKInfo.get("tmActivityName").toString() : "");//NOSONAR
            }
            // 保存被终止的数据
            this.commonTerminateDataService.saveTerminateData(authoredUser, terminateData);

            if (MapUtils.isNotEmpty(cardBKInfo)) {
                clearSmartDataFootprintAndComparisonData(executeContext.getTmActivityId(), authoredUser, executeContext.getBusinessUnit(), cardBKInfo);
            }

            // 异步方式终止其他任务的数据
            if (CollectionUtils.isNotEmpty(otherCardBKInfoList)) {
                terminateOtherTaskDataAsync(executeContext, action, cardBKInfo, otherCardBKInfoList, terminateDateTime,comment);
            }
        }

        return ExecuteResult.ok();
    }



    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(submitExecuteContext.isMinSplit()){
            Map<Long, Map<String, Object>> workItemIdToData = ActivityUtils.getMinSplitWorkItemToData(actionExecuteReq);
            SubmitAction action = actionExecuteReq.getAction();
            // 构造
            Map<String, Object> extendParas = action.getExtendParas();
            // 检查terminate-data  action的必须配置
            checkExtendParas(extendParas);
            if(null != extendParas.get(TERMINATE_EXTEND_DATA_KEY)){
                return super.execute(actionExecuteReq);
            }
            // 根据dataKeys配置 + 业务数据，构造出BK信息
            String dataKeys = extendParas.get("dataKeys").toString();
            String detailField = StrUtil.toStringOrNull(extendParas.get("detailField"));
            String submitVariableName = extendParas.get("submitVariableName").toString();
            // 活动对应的提交数据
            Map<Long,List<Map>> workItemIdToBk = Maps.newHashMapWithExpectedSize(workItemIdToData.size());
            Map<Long,List<Map<String,Object>>> workItemIdToPageData = Maps.newHashMapWithExpectedSize(workItemIdToData.size());
            workItemIdToData.forEach((k,v)->{
                // 获取提交的数据
                List<Map<String, Object>> pageDataList = getSubmitParas(Arrays.asList(v), submitVariableName);
                if(!pageDataList.isEmpty()){
                    workItemIdToPageData.put(k,pageDataList);
                }
                workItemIdToBk.put(k,this.parseBK(dataKeys, detailField, pageDataList));
            });

            ActionExecuteReq cp = JaBeanCopy.cp(actionExecuteReq, ActionExecuteReq.class);
            if (!workItemIdToPageData.isEmpty()) {
                deleteActivityBpmVariableActionExecutor.execute(actionExecuteReq);
            } else {
                // 大概率异步执行的
                Map<Long, Map<String, Object>> workItemIdToNewData = Maps.newHashMapWithExpectedSize(workItemIdToBk.size());
                workItemIdToBk.forEach((k,v)->{
                    Map<String,Object> newData = Maps.newHashMapWithExpectedSize(1);
                    newData.put(submitVariableName, v);
                    workItemIdToNewData.put(k,newData);

                });
                cp.setWorkItemIdToData(workItemIdToNewData);
                deleteActivityBpmVariableActionExecutor.execute(cp);
            }
            AuthoredUser authoredUser = getOperateUser(submitExecuteContext);
            // 批量调用
            List<TerminateDataDTO> terminateDataList = Lists.newArrayListWithExpectedSize(workItemIdToPageData.size());

            //终止原因
            String comment = MapUtils.getString(action.getParas(),"comment","");
            List<Tuple> otherCardList = Lists.newArrayList();
            Map<Long,Map<String, Object>> currentBkMap = Maps.newHashMapWithExpectedSize(workItemIdToPageData.size());
            LocalDateTime terminateDateTime = LocalDateTime.now();
            for (Map.Entry<Long,List<Map<String,Object>>> entry: workItemIdToPageData.entrySet()){
                Long key = entry.getKey();
                List<Map> cardBKInfoList = atmcService.queryCardListByBk("workitem", key, workItemIdToBk.get(key), true);
                Map cardBKInfo = Maps.newHashMap();
                List<Map> otherCardBKInfoList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(cardBKInfoList)) {
                    for (Map tmpCardBKInfo : cardBKInfoList) {
                        if (StringUtils.equals(String.valueOf(key), String.valueOf(tmpCardBKInfo.get("workItemId")))) {
                            cardBKInfo = tmpCardBKInfo;
                        } else {
                            otherCardBKInfoList.add(tmpCardBKInfo);
                        }
                    }
                }
                otherCardList.add(new Tuple(key,cardBKInfo,otherCardBKInfoList));
                TerminateDataDTO terminateData = buildToSaveTerminateData(String.valueOf(key),submitExecuteContext.getTmActivityId(), authoredUser, workItemIdToBk.get(key), entry.getValue(), terminateDateTime,comment);
                if (MapUtils.isNotEmpty(cardBKInfo)) {
                    terminateData.setActivityName(MapUtils.getString(cardBKInfo,"tmActivityName",""));
                }
                terminateDataList.add(terminateData);
                if(!cardBKInfo.isEmpty()){
                    currentBkMap.put(key,cardBKInfo);
                }
            }
            // TODO 是否改成多线程调用？
            this.commonTerminateDataService.saveTerminateData(authoredUser, terminateDataList);
            if(!currentBkMap.isEmpty()){
                currentBkMap.forEach((k,v)->{
                    clearSmartDataFootprintAndComparisonData(submitExecuteContext.getTmActivityId(), authoredUser, submitExecuteContext.getBusinessUnit(), v);
                });
            }
            terminateOtherTaskDataAsync(authoredUser,comment,submitExecuteContext.getTmActivityId(),otherCardList,terminateDateTime);
            return ExecuteResult.ok();
        }else {
            return super.execute(actionExecuteReq);
        }

    }

    private List<Map<String, Object>> convertBkToPageData(List<Map> bkList) {
        List<Map<String, Object>> pageDataList = new ArrayList<>();
        for (Map bkInfo : bkList) {
            Map<String, Object> pageData = new HashMap<>();

            Set<Map.Entry> entries = bkInfo.entrySet();
            for (Map.Entry entry : entries) {
                pageData.put(entry.getKey().toString(), entry.getValue());
            }
            pageDataList.add(pageData);
        }
        return pageDataList;
    }

    private TerminateDataDTO buildToSaveTerminateData(String workItemId,String tmActivityId, AuthoredUser authoredUser, List<Map> bkList
            , List<Map<String, Object>> pageDataList, LocalDateTime terminateDateTime, String comment) {
        TerminateDataDTO terminateData = new TerminateDataDTO();
        // 执行人信息
        terminateData.setTenantId(authoredUser.getTenantId());
        terminateData.setUserId(authoredUser.getUserId());
        terminateData.setUserName(authoredUser.getUserName());

        // 终止任务信息: activityId, activityCode, activityName
        terminateData.setActivityId(workItemId);
        terminateData.setActivityCode(tmActivityId);

        terminateData.setTerminateTime(terminateDateTime);

        //终止原因
        terminateData.setComment(comment);
        // 发起终止的任务信息: initiateActivityId, initiateActivityCode, initiateActivityName

        terminateData.setBkList(bkList);
        terminateData.setPageData(pageDataList);
        terminateData.setPageDataSize(pageDataList.size());
        return terminateData;
    }
    private TerminateDataDTO buildToSaveTerminateData(SubmitExecuteContext executeContext, AuthoredUser operatorAuthoredUser, List<Map> bkList
            , List<Map<String, Object>> pageDataList, LocalDateTime terminateDateTime, String comment) {
        AuthoredUser authoredUser = null != operatorAuthoredUser ? operatorAuthoredUser : getOperateUser(executeContext);
        return buildToSaveTerminateData(String.valueOf(executeContext.getBacklogId()),executeContext.getTmActivityId(),authoredUser,bkList,pageDataList,terminateDateTime,comment);
    }

    private void terminateOtherTaskDataAsync(SubmitExecuteContext executeContext, SubmitAction action, Map cardBKInfo, List<Map> cardBKInfoList
            , LocalDateTime terminateDateTime, String comment) {
        // 查询数据源--》模拟“终止”按钮提交

        Map initiateCardBKInfo = new HashMap();
        if (MapUtils.isNotEmpty(cardBKInfo)) {
            initiateCardBKInfo.putAll(cardBKInfo);
        } else {
            initiateCardBKInfo.put("workItemId", executeContext.getBacklogId());
            initiateCardBKInfo.put("tmActivityId", executeContext.getTmActivityId());
        }

        for (Map taskBKInfo : cardBKInfoList) {
            TerminateDataTask terminateDataTask = new TerminateDataTask(taskBKInfo, executeContext.getBacklogId(), this.commonUiBotService, this.dataSubmissionService);
            terminateDataTask.setInitiateTaskBKInfo(initiateCardBKInfo);
            terminateDataTask.setTerminateDateTime(terminateDateTime.plusHours(0));
            terminateDataTask.setOperateAuthoredUser(this.getOperateUser(executeContext));
            terminateDataTask.setComment(comment);//设置终止原因

            executorService.submit(terminateDataTask);
        }
    }

    /**
     *  最小化拆分终止
     * @param authoredUser
     * @param comment
     * @param tmActivityId
     * @param otherCardList
     * @param terminateDateTime
     */
    private void terminateOtherTaskDataAsync(AuthoredUser authoredUser,String comment,String tmActivityId,List<Tuple> otherCardList,LocalDateTime terminateDateTime){
        if(CollectionUtils.isNotEmpty(otherCardList)){
            for (Tuple tuple : otherCardList) {
                List<Map> cardBKInfoList = tuple.get(2);
                if(CollectionUtils.isNotEmpty(cardBKInfoList)){
                    Map cardBKInfo = tuple.get(1);
                    Long workItemId = tuple.get(0);
                    Map initiateCardBKInfo = new HashMap();
                    if (MapUtils.isNotEmpty(cardBKInfo)) {
                        initiateCardBKInfo.putAll(cardBKInfo);
                    } else {
                        initiateCardBKInfo.put("workItemId", String.valueOf(workItemId));
                        initiateCardBKInfo.put("tmActivityId", tmActivityId);
                    }
                    for (Map taskBKInfo : cardBKInfoList) {
                        TerminateDataTask terminateDataTask = new TerminateDataTask(taskBKInfo, workItemId, this.commonUiBotService, this.dataSubmissionService);
                        terminateDataTask.setInitiateTaskBKInfo(initiateCardBKInfo);
                        terminateDataTask.setTerminateDateTime(terminateDateTime.plusHours(0));
                        terminateDataTask.setOperateAuthoredUser(authoredUser);
                        terminateDataTask.setComment(comment);//设置终止原因
                        executorService.submit(terminateDataTask);
                    }

                }
            }

        }
    }

    private void checkExtendParas(Map<String, Object> extendParas) {
        if (MapUtils.isEmpty(extendParas)
                || !extendParas.containsKey("dataKeys")
                || !extendParas.containsKey("processVariableName")
                || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0030.getErrCode(), messageUtils.getMessage("exception.terminate.attachAction.lack.config"));
        }
    }

    private void clearSmartDataFootprintAndComparisonData(String tmActivityId, AuthoredUser authoredUser, Map<String, Object> eocMap, Map cardBkInfo) {
        if (MapUtils.isEmpty(cardBkInfo)) {
            return;
        }

        String backlogId = Optional.ofNullable(cardBkInfo.get("backlogId"))
                .map(value -> value.toString())
                .orElse("");
        String entityName = Optional.ofNullable(cardBkInfo.get("entityName"))
                .map(value -> value.toString())
                .orElse("");
        if (StringUtils.isBlank(backlogId) || StringUtils.isBlank(entityName)) {
            return;
        }

        List bkList = (List) (cardBkInfo.get("bkList"));

        // 清除数据足迹
        this.commonSmartDataService.clearComparisonData(authoredUser, backlogId, tmActivityId, entityName, eocMap, bkList);
        // 清除数据一致性
        this.commonSmartDataService.clearFootprintData(authoredUser, backlogId, tmActivityId, entityName, eocMap, bkList);
    }

    private List<Map> parseBK(String dataKeys, String detailField, List<Map<String, Object>> pageDataList) {
        String[] dataKeyList = StringUtils.split(dataKeys, ';');
        List<Map> BKList = new ArrayList<>(pageDataList.size());

        List<Map<String, Object>> tmpPageDataList = pageDataList;
        // 指定了单身字段
        if (StringUtils.isNotBlank(detailField)) {
            tmpPageDataList = this.getSubmitParas(pageDataList, detailField);
        }

        for (Map<String, Object> pageData : tmpPageDataList) {
            Map BK = new HashMap<>();
            for (String key : dataKeyList) {
                BK.put(key, pageData.get(key));
            }
            BKList.add(BK);
        }
        return BKList;
    }

    /**
     * 获取提交参数
     *
     * @param paramList 数据来源
     * @param field     字段名
     * @return 数据
     */
    private List<Map<String, Object>> getSubmitParas(List<Map<String, Object>> paramList, String field) {
        if (StringUtils.isBlank(field)) {
            return paramList;
        }
        log.info("TerminateDataExecutor.getSubmitParas:{}", JsonUtils.objectToString(paramList));
        List<Map<String, Object>> submitParas = Lists.newArrayList();
        for (Map<String, Object> param : paramList) {
            Object paramValueObj = param.get(field);
            if (paramValueObj instanceof Map) {
                submitParas.add((Map<String, Object>) paramValueObj);
            } else if (paramValueObj instanceof Collection) {
                submitParas.addAll((List<Map<String, Object>>) paramValueObj);
            } else {
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0020.getErrCode(),
                        messageUtils.getMessage("exception.submit.data2")
                                + field
                                + messageUtils.getMessage("exception.data.type.error"));
            }
        }
        return submitParas;
    }

    private AuthoredUser getOperateUser(SubmitExecuteContext executeContext) {
        return null != executeContext.getOperateAuthoredUser() ? executeContext.getOperateAuthoredUser() : executeContext.getAuthoredUser();
    }

    protected static class TerminateDataTask implements Runnable {
        private Map taskBkInfo;

        /**
         * 最初发起终止操作的任务信息
         */
        @Getter
        @Setter
        private Map initiateTaskBKInfo;

        private CommonUiBotService commonUiBotService;

        private DataSubmissionService dataSubmissionService;

        private AuthoredUser authoredUser;

        @Setter
        @Getter
        private AuthoredUser operateAuthoredUser;

        private Locale locale;


        private Long origWorkItemId;
        /**
         * 操作原因（终止原因）
         */
        @Setter
        @Getter
        private String comment;

        @Setter
        private LocalDateTime terminateDateTime;

        public TerminateDataTask(Map taskBkInfo, Long origWorkItemId, CommonUiBotService commonUiBotService, DataSubmissionService dataSubmissionService) {
            this.taskBkInfo = taskBkInfo;
            this.commonUiBotService = commonUiBotService;
            this.origWorkItemId = origWorkItemId;
            this.dataSubmissionService = dataSubmissionService;

            this.authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            this.locale = LocaleContextHolder.getLocale();
//            mdcContext = MDC.getCopyOfContextMap();
        }

        @Override
        public void run() {
            // 设置线程上下文中的用户登录信息
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            // 设置线程上下文中的语言别信息
            LocaleContextHolder.setLocale(locale);
//            MDC.setContextMap(this.mdcContext);
            Long workItemId = (Long) (taskBkInfo.get("workItemId"));
            try {
                /**
                 * 终止其他任务数据时，不能调用atmc submit/task接口，若待办项已关闭，则会报错
                 */
                this.execute(workItemId);
            } catch (Exception ex) {
                // 打印并吃掉异常
                log.error("terminateData-{}-{}, error: {}", origWorkItemId, workItemId, ex);
            } finally {
                // 清空线程上下文中的用户登录信息
                LocaleContextHolder.resetLocaleContext();
                AppAuthContextHolder.clearContext();
            }
        }

        private void execute(Long workItemId) {
            List bkList = (List) (taskBkInfo.get("bkList"));

            String tmProjectId = taskBkInfo.get("tmProjectId").toString();
            String tmActivityId = taskBkInfo.get("tmActivityId").toString();

            log.info("terminateData-{}-{}-{}-{}-relative task.", origWorkItemId, workItemId, tmActivityId, tmProjectId);

            // 获取任务终止PageDefine
            Map pageDefine = commonUiBotService.queryTerminateDataPageDefine(tmProjectId, tmActivityId, workItemId, bkList);

            // 必须包含executeContext，dataSourceSet，submitActions
            if (null == pageDefine || null == pageDefine.get("executeContext")
                    || null == pageDefine.get("dataSourceSet") || CollectionUtils.isEmpty((List) pageDefine.get("submitActions"))) {
                log.warn("terminateData-{}-{}-{}-{}'s pageDefine invalid", origWorkItemId, workItemId, tmActivityId, tmProjectId);
                return;
            }
            log.info("submitActions:{}",  JsonUtils.objectToString(pageDefine.get("submitActions")));
            // 执行数据查询，获取业务数据
            ExecuteContext executeContext = parsePageDefineExecuteContext(pageDefine);
            DataSourceSetDTO dataSourceSet = JsonUtils.jsonToObject(JsonUtils.objectToString(pageDefine.get("dataSourceSet")), DataSourceSetDTO.class);
            Map<String, Object> parameter = null != pageDefine.get("parameter") ?
                    JsonUtils.jsonToObject(JsonUtils.objectToString(pageDefine.get("parameter")), new TypeReference<Map<String, Object>>() {
                    }) : new HashMap<>();
            QueryResultSet queryResultSet = this.queryPageData(executeContext, dataSourceSet, parameter);

            // UIBOT构建的终止Action
            SubmitAction terminateDataAction = buildTerminateAction(pageDefine);
            // 执行“终止”按钮的提交
            executeTerminateDataAction(terminateDataAction, queryResultSet.getPageData());
        }

        private SubmitAction buildTerminateAction(Map pageDefine) {
            SubmitAction terminateDataAction = parseTerminateAction((List<Map<String, Object>>) pageDefine.get("submitActions"));
            if (null != terminateDataAction.getExecuteContext()) {
                terminateDataAction.getExecuteContext().setAuthoredUser(this.authoredUser);
                if (StringUtils.isBlank(terminateDataAction.getExecuteContext().getTenantId())) {
                    terminateDataAction.getExecuteContext().setTenantId(this.authoredUser.getTenantId());
                }
            }
            terminateDataAction.getExtendParas().put(TERMINATE_EXTEND_DATA_KEY, this.taskBkInfo);
            terminateDataAction.getExtendParas().put(TERMINATE_EXTEND_INITIATE_DATE_KEY, this.initiateTaskBKInfo);
            terminateDataAction.getExtendParas().put(TERMINATE_EXTEND_TERMINATE_DATE_TIME, this.terminateDateTime);
            terminateDataAction.getExtendParas().put(TERMINATE_EXTEND_TERMINATE_COMMENT, this.comment);

            terminateDataAction.getExtendParas().put("operateAuthoredUser", this.getOperateAuthoredUser());

            changeDispatchActionParas(terminateDataAction);
            return terminateDataAction;
        }

        /**
         * 改变dispatch action的paras中的performerType为999
         *
         * @param terminateDataAction
         */
        private void changeDispatchActionParas(SubmitAction terminateDataAction) {
            if (CollectionUtils.isEmpty(terminateDataAction.getAttachActions())) {
                return;
            }

            terminateDataAction.getAttachActions().stream()
                    .filter(attachAction -> isDispatchAction(attachAction))
                    .filter(attachAction -> MapUtils.isNotEmpty(attachAction.getParas()))
                    .forEach(attachAction -> attachAction.getParas().put("performerType", 999));
        }

        private boolean isDispatchAction(SubmitAction submitAction) {
            if (null == submitAction || null == submitAction.getServiceId()) {
                return false;
            }
            return StringUtils.equals(submitAction.getCategory(), UiBotConstants.ACTION_CATEGORY_TASK_ENGINE)
                    && StringUtils.equals(submitAction.getServiceId().getName(), TaskEngineDispatchActionExecutor.DISPATCH_ACTION_ID);
        }

        private SubmitAction parseTerminateAction(List<Map<String, Object>> submitActions) {
            Map<String, Object> submitAction = submitActions.get(0);
            removeActionField(submitAction);
            return JsonUtils.jsonToObject(JsonUtils.objectToString(submitAction), SubmitAction.class);
        }

        private void removeActionField(Map<String, Object> action) {
            if (null != action) {
                action.remove("action_LIST");
            }
            if (null != action && (null != action.get("attachActions"))) {
                List<Map<String, Object>> attachActions = (List<Map<String, Object>>) action.get("attachActions");
                for (Map<String, Object> attachAction : attachActions) {
                    removeActionField(attachAction);
                }
            }
        }

        private ExecuteContext parsePageDefineExecuteContext(Map pageDefine) {
            ExecuteContext executeContext = JsonUtils.jsonToObject(JsonUtils.objectToString(pageDefine.get("executeContext")), ExecuteContext.class);
            executeContext.setAuthoredUser(authoredUser);
            if (StringUtils.isBlank(executeContext.getTenantId())) {
                executeContext.setTenantId(authoredUser.getTenantId());
            }
            return executeContext;
        }

        private QueryResultSet queryPageData(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO, Map<String, Object> parameter) {
            if (dataSourceSetDTO == null) {
                return QueryResultSet.empty();
            }
            DataSourceSet dataSourceSet = DataSourceConverter.convert(dataSourceSetDTO);
            if (dataSourceSet == null) {
                return QueryResultSet.empty();
            }

            return dataSourceSet.query(executeContext, parameter, null, null, null);
        }

        private void executeTerminateDataAction(SubmitAction terminateDataAction, Map submitPageData) {
            this.dataSubmissionService.submit(terminateDataAction.getExecuteContext(), terminateDataAction, submitPageData);
        }
    }
}
