package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Order(110)
@Service("update-activity-query-variable-value")
class UpdateActivityQueryParameterExecutor implements ActionExecutor {

    @Autowired
    CommonAtmcService atmcService;

    @Autowired
    MessageUtils messageUtils;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"update-activity-query-variable-value";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action == null || parameter == null
                || action.getExecuteContext() == null
                || action.getExecuteContext().getBacklogId() == null
                || action.getExecuteContext().getBpmData() == null
                || action.getExtendParas() == null
                || action.getExtendParas().size() == 0) {
            return ExecuteResult.ok();
        }
        //抓到关联的流程变量,需要发起的新的活动id
        DataSourceDTO dataSourceDTO= action.getCheckCompleteAction();
        if (dataSourceDTO ==null ) {
            if (executeContext.getParentAction() != null && executeContext.getParentAction().getCheckCompleteAction() != null) {
                dataSourceDTO = executeContext.getParentAction().getCheckCompleteAction();
            }
        }
        Map<String, Object> bpmParas = null;
        if (dataSourceDTO != null && dataSourceDTO.getAction()!=null){
            bpmParas = dataSourceDTO.getAction().getParas();
        }

        //获取活动参数中做查询的数据、提交的数据、需要处理的数据
        List<Map<String, Object>> submitParas = null;
        List<Map<String, Object>> queryParas = null;
        String submitVariableName = "";
        for (Map.Entry<String, Object> stringObjectEntry : action.getExtendParas().entrySet()) {
            if ("submitVariableName".equals(stringObjectEntry.getKey())) {
                submitVariableName = stringObjectEntry.getValue().toString();
                if (parameter.containsKey(submitVariableName)) {
                    submitParas = (List<Map<String, Object>>) parameter.get(submitVariableName);
                } else {
                    throw BusinessException.create(ErrorCodeEnum.NUM_500_0041.getErrCode(), String.format(messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                }
            }
            if("queryVariableName".equals(stringObjectEntry.getKey())){
                String queryVariableName = stringObjectEntry.getValue().toString();
                if (bpmParas != null && bpmParas.containsKey(queryVariableName)) {
                    queryParas = (List<Map<String, Object>>) bpmParas.get(queryVariableName);
                }
            }
        }
        if (submitParas ==null || submitParas.size() ==0){
            return ExecuteResult.ok();
        }


        List<Map<String, Object>> submitData = new ArrayList<>();
        for (Map map : submitParas) {
            if (map.containsKey("uibot_checked")){
                boolean checked = map.get("uibot_checked") == null ? false : BooleanUtils.toBoolean(map.get("uibot_checked").toString());
                if (checked) {
                    submitData.add(map);
                }
            }else {
                submitData.add(map);
            }
        }

        HashMap traceData = new HashMap();
        traceData.put("data",submitData);

        String backlogId = action.getExecuteContext().getBacklogId().toString();
        //目标状态

        String targetDataState = action.getTargetDataState();
        if (targetDataState == null) {
            if (executeContext.getParentAction() != null && StringUtils.hasText(executeContext.getParentAction().getTargetDataState())) {
                targetDataState = executeContext.getParentAction().getTargetDataState();
            } else {
                targetDataState = "completed";
            }
        }

        if (submitData.size() >0){
            atmcService.setBpmActivityTraceData(backlogId,"waitting",targetDataState, traceData);
        }
        //删除查询逻辑里面的参数
        if (queryParas!= null && queryParas.size() >0) {
            List<String> keys = dataSourceDTO.getDataKeys();
            //先把数据的key变成字典
            Set<String> submitDataKeys = new HashSet<>();
            for (Map data : submitData) {
                StringBuilder sb = new StringBuilder();
                for (Object key : keys) {
                    sb.append(data.get(key) + "--");
                }
                if (sb.length() > 0) {
                    submitDataKeys.add(sb.toString());
                }
                sb.setLength(0);
            }

            List needDel = new ArrayList();
            for (Map<String, Object> queryPara : queryParas) {
                StringBuilder sb = new StringBuilder();
                for (Object key : keys) {
                    sb.append(queryPara.get(key) + "--");
                }
                if (sb.length() > 0) {
                    String queryParaKey = sb.toString();
                    if (submitDataKeys.contains(queryParaKey)){
                        needDel.add(queryPara);
                    }
                }
                sb.setLength(0);
            }
            for (Object o : needDel) {
                queryParas.remove(o);
            }
            if (queryParas.size() == 0){
                //因为esp的缘故，如果集合是空，会报错，加入一笔特殊的数据
                Map newPara = new HashMap();
                for (Object key : keys) {
                    newPara.put(key,  "__xxxx");
                }
                queryParas.add(newPara);
            }
        }

        return ExecuteResult.ok();
    }

}
