package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Order(50)
@Service("update-task-trace-state")
class UpdateTaskTraceStateActionExecutor implements ActionExecutor {

    @Autowired
    CommonAtmcService atmcService;

    @Autowired
    MessageUtils messageUtils;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"update-task-trace-state";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }
    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        Map<String, Object> extendParas = action.getExtendParas();
        check(extendParas);
        String detailField = null;
        if (extendParas.containsKey("detailField")){
            detailField = extendParas.get("detailField").toString();
        }
        JSONObject stateData = createParas(parameter, MapUtils.getString(extendParas, "processVariableName"), MapUtils.getString(extendParas, "submitVariableName"), detailField, MapUtils.getString(extendParas, "dataKeys"));
        if (stateData == null ){
            return ExecuteResult.ok();
        }
        // workItemId
        String backlogId = action.getExecuteContext().getBacklogId().toString();
        atmcService.setBpmActivityStateData(backlogId,stateData);
        return ExecuteResult.ok();
    }

    private void check(Map<String, Object> extendParas){
        if (MapUtils.isEmpty(extendParas)
                || !extendParas.containsKey("dataKeys")
                || !extendParas.containsKey("processVariableName")
                || !extendParas.containsKey("submitVariableName") ) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0025.getErrCode(), messageUtils.getMessage("exception.update.field.action.lack.config2"));
        }
    }

    private JSONObject createParas( Map<String, Object> parameter, String processVariableName,String submitVariableName, String detailField,String  dataKeys){
        if (!parameter.containsKey(submitVariableName)){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0026.getErrCode(), messageUtils.getMessage("exception.submit.data") + submitVariableName
                    + messageUtils.getMessage("exception.check.KG.config"));
        }
        List<Map<String, Object>> datas = (List<Map<String, Object>>) parameter.get(submitVariableName);
        if (datas.size() ==0 ){
            return null;
        }
        // 有明细添加明细 没有明细添加当前数据
        List<Map<String, Object>> needUpdateDatas = new ArrayList<>();
        for (Map<String, Object> data : datas) {
            boolean hasDetail=false;
            //如果有明细数据则只要处理明细
            if (detailField !=null && data.get(detailField) != null) {
                List<Map<String, Object>> detail = (List<Map<String, Object>>) data.get(detailField);
                for (Map<String, Object> detailItem : detail) {
                    needUpdateDatas.add(detailItem);
                    hasDetail=true;
                }
            }
            if (!hasDetail){
                needUpdateDatas.add(data);
            }
        }

        JSONObject stateData = new JSONObject();
        JSONArray processVariableValue = new JSONArray();


        stateData.put("dataKeys", dataKeys);
        stateData.put("originalQueryVariableName", processVariableName);

        String[] dataKeyList = dataKeys.split(";");
        for (Map<String, Object> needUpdateData : needUpdateDatas) {

            JSONObject item = new JSONObject();
            for (String key : dataKeyList) {
                item.put(key,needUpdateData.get(key));
            }
            //默认是未开始
            item.put("state",0);
            processVariableValue.add(item);
        }
        stateData.put(processVariableName, processVariableValue);
        return stateData;
    }



    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        // TODO 最小化不支持改处理器
        if(submitExecuteContext.isMinSplit()){
//            SubmitAction action = actionExecuteReq.getAction();
//            Map<String, Object> extendParas = action.getExtendParas();
//            check(extendParas);
//            String processVariableName = MapUtils.getString(extendParas, "processVariableName");
//            String submitVariableName = MapUtils.getString(extendParas, "submitVariableName");
//            String dataKeys = MapUtils.getString(extendParas, "dataKeys");
//            String detailField = MapUtils.getString(extendParas, "detailField");
//            Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
//            List<JSONObject> dataList = Lists.newArrayListWithExpectedSize(workItemIdToData.size());
//            workItemIdToData.forEach((k,v)->{
//                JSONObject stateData = createParas(v, processVariableName, submitVariableName, detailField, dataKeys);
//                if(stateData != null){
//                    JSONObject row = new JSONObject();
//                    row.put("workItemId",k);
//                    row.put(processVariableName,stateData.getJSONArray(processVariableName));
//                    dataList.add(row);
//                }
//            });
//            if(!dataList.isEmpty()){
//                JSONObject param = new JSONObject();
//                param.put("dataKeys",dataKeys);
//                param.put("originalQueryVariableName",processVariableName);
//                param.put("data",dataList);
//                // TODO 需要支持
//                // atmcService.batchUpdateBpmActivityStateData(param);
//            }
//            return ExecuteResult.ok();
        }
        return ActionExecutor.super.execute(actionExecuteReq);
    }
}
