package com.digiwin.athena.atdm.action.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.seata.JaGlobalTransactionalTemplate;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.activity.domain.MergeSubmitActionDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus.DataUniformityEvent;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus.DataUniformityEventDTO;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.log.LogRecordDTO;
import com.digiwin.athena.atdm.log.LogRecordEvent;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Service
public class MergeActionExecuteService {
    private static final List<String> ACTION_LIST = Arrays.asList("submit-data", "dispatch", "reexecute", "agree", "disagree", "reassign", "reapprove", "add-task", "terminate-task", "filter-selected-data-action", "submit-data", "recycle.delete", "recycle.deleteAll", "commit-data-to-fi", "update-activity-query-variable-value", "update-task-trace-state", "terminate-process", "manual-reassign", "update-data");
    private static final String MERGE_TASK_URL = "/api/atdm/v1/action/submit/mergeTask";
    private static final ThreadLocal<Boolean> SEATA_TM_ACTIVITY_ID_HOLDER = new ThreadLocal<>();

    @Autowired
    DataSubmissionService dataSubmissionService;

    @Autowired
    private AsyncEventBus asyncEventBus;

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    CommonAtmcService atmcService;

    public List<ExecuteResult> submit(int maxDepath, List<SubmitExecuteContext> executeContext, SubmitAction action, List<Map<String, Object>> data) throws Throwable {
        List<ExecuteResult> executeResultList = new ArrayList<>();
        List<SubmitAction> actionList = action.getActionList();
        LogDto logDto = new LogDto("执行core action开始，actionId：" + actionList.get(0).getActionId(), executeContext.get(0).getTenantId() + LogConstant.TRACE_SEPARATOR + executeContext.get(0).getBacklogId());
        log.info(logDto.toString());
        JaGlobalTransactionalTemplate.handleGlobalTransaction(null,
                () -> recurrentAction(maxDepath, executeContext, data, actionList, executeResultList),
                () -> checkActionIsExecuteSeata(actionList.get(0).getCategory(), executeContext.get(0).getTmActivityId()));
        //如果包括合并任务的action执行一次
        if (action.getActionList().stream().anyMatch(dataSubmissionService::isSupportSubmitMergeData)
                && CollectionUtils.isNotEmpty(executeResultList)
                && !executeResultList.get(0).getExecuteState()) {
            dataSubmissionService.executeCoreWapper(executeContext.get(0), null, actionList.get(0), data.get(0));
        }
        LogDto logDtoEnd = new LogDto("执行core action结束，actionId：" + actionList.get(0).getActionId(), executeContext.get(0).getTenantId() + LogConstant.TRACE_SEPARATOR + executeContext.get(0).getBacklogId());
        log.info(logDtoEnd.toString());

        if (CollectionUtils.isNotEmpty(action.getAttachActions())) {
            //需要的派送的任务找到，最后调用
            List<SubmitAction> taskEngineAction = new ArrayList<>();
            List<SubmitAction> afterCheckCompletedActions = new ArrayList<>();
            action.getAttachActions().forEach(t -> {
                if (t.getActionList().stream().anyMatch(SubmitAction::isDispatchAction)) {
                    taskEngineAction.add(t);
                }
                if (t.getActionList().stream().anyMatch(n -> Boolean.TRUE.equals(n.getExecuteAfterCheckCompleted()))) {
                    afterCheckCompletedActions.add(t);
                }
            });

            //先执行所有非流程相关的action
            for (SubmitAction attachAction : action.getAttachActions()) {
                if (attachAction.getActionList().get(0).isDispatchAction() || Boolean.TRUE.equals(attachAction.getActionList().get(0).getExecuteAfterCheckCompleted())) {
                    continue;
                }
                LogDto logDtoAttach = new LogDto("执行attach action开始，backlogId：" + executeContext.get(0).getBacklogId(), executeContext.get(0).getTenantId() + LogConstant.TRACE_SEPARATOR + executeContext.get(0).getBacklogId());
                log.info(logDtoAttach.toString());
                executeAttachAction(maxDepath, null, executeContext, action, executeResultList, attachAction, data);
                LogDto logDtoAttachEnd = new LogDto("执行attach action结束，backlogId：" + executeContext.get(0).getBacklogId(), executeContext.get(0).getTenantId() + LogConstant.TRACE_SEPARATOR + executeContext.get(0).getBacklogId());
                log.info(logDtoAttachEnd.toString());
            }
            //执行流程引擎的派送
            if (!taskEngineAction.isEmpty()) {
                setIsCompleted(executeContext, action, executeResultList);
                //如果已经处理完，且存在bpm action，则执行
                Set<Integer> excludeList = new HashSet<>(executeResultList.size());
                for (int i = 0; i < executeResultList.size(); i++) {
                    if (!executeResultList.get(i).isCompleted()) {
                        excludeList.add(i);
                    }
                }
                if (CollectionUtils.isNotEmpty(afterCheckCompletedActions)) {
                    for (SubmitAction attachAction : afterCheckCompletedActions) {
                        executeAttachAction(maxDepath, excludeList, executeContext, action, executeResultList, attachAction, data);
                    }
                }
                executeAttachAction(maxDepath, excludeList, executeContext, action, executeResultList, taskEngineAction.get(0), data);
            }
        } else {
            //如果是派送才需要根据返回的数据对任务关闭
            if (action.getActionList().stream().anyMatch(SubmitAction::isDispatchAction)) {
                setIsCompleted(executeContext, action, executeResultList);
            }
        }

        //提交时记录数据对应的bk为已完成状态并删除sd相对应的侦测
        try {
            for (int i = 0; i < maxDepath; i++) {
                if (null == executeContext.get(i).getTaskType() || executeContext.get(i).getTaskType() != 89) {
                    DataUniformityEventDTO dataUniformityEventDTO = new DataUniformityEventDTO();
                    dataUniformityEventDTO.setBacklogId(executeContext.get(i).getBacklogId());
                    dataUniformityEventDTO.setRequestData(executeResultList.get(i).getRequestData());
                    dataUniformityEventDTO.setTmActivityId(executeContext.get(i).getTmActivityId());
                    DataUniformityEvent dataUniformityEvent = new DataUniformityEvent(dataUniformityEventDTO, executeContext.get(i).getOperateAuthoredUser());
                    asyncEventBus.post(dataUniformityEvent);
                }
            }
        } catch (Exception e) {
            log.error("提交数据比对以及删除侦测EventBus任务异常：{}", e.getMessage());
        }
        return executeResultList;
    }

    private Boolean checkActionIsExecuteSeata(String category, String tmActivityId) {
        Boolean isSeataActivityCode = SEATA_TM_ACTIVITY_ID_HOLDER.get();
        if (null == isSeataActivityCode) {
            isSeataActivityCode = atmcService.operationConfig("SEATA_WHITE_LIST" + "_" + tmActivityId, 0, "SEATA_WHITE_LIST");
            SEATA_TM_ACTIVITY_ID_HOLDER.set(isSeataActivityCode);
        }
        return "ESP".equals(category) && isSeataActivityCode;
    }

    private int recurrentAction(int maxDepath, List<SubmitExecuteContext> executeContext, List<Map<String, Object>> data, List<SubmitAction> actionList, List<ExecuteResult> executeResultList) {
        for (int i = 0; i < maxDepath; i++) {
            ExecuteResult executeResult = dataSubmissionService.executeCoreWapper(executeContext.get(i), null, actionList.get(i), data.get(i));
            Map<String, Object> extendResult = new HashMap<>();
            extendResult.put("backlogId", executeContext.get(i).getBacklogId());
            executeResult.setExtendResult(extendResult);

            executeResultList.add(deepCopy(executeResult, ExecuteResult.class));
            executeContext.get(i).setParentAction(actionList.get(i));
        }
        return 1;
    }

    private void setIsCompleted(List<SubmitExecuteContext> executeContext, SubmitAction action, List<ExecuteResult> executeResult) {
        List<SubmitAction> actionList = action.getActionList();
        for (int i = 0; i < actionList.size(); i++) {
            if (actionList.get(i).getCheckCompleteAction() == null) {
                executeResult.get(i).setCompleted(true);
            } else {
                DataSourceBase dataSourceBase = DataSourceConverter.convert(actionList.get(i).getCheckCompleteAction(), false);

                QueryResult queryResult = dataSourceBase.query(ExecuteContext.fromSubmitExecuteContent(executeContext.get(i)), null, null, null, null);
                //如果主action是一个异步的操作，这时候通过读取数据是否存在来判断任务处理完毕就有问题
                //判断数据是否已经全部处理完。
                executeResult.get(i).setCompleted(queryResult.size() == 0);
            }
        }

    }

    private void executeAttachAction(int maxDepath, Set<Integer> index, List<SubmitExecuteContext> executeContext, SubmitAction parentAction, List<ExecuteResult> parentExecuteResult, SubmitAction attachAction, List<Map<String, Object>> submitData) throws Throwable {
        List<ExecuteResult> attachActionExecuteResultList = new ArrayList<>();
        List<SubmitAction> parentActionList = parentAction.getActionList();

        JaGlobalTransactionalTemplate.handleGlobalTransaction(null,
                () -> recurrentAttachAction(maxDepath, index, executeContext, parentExecuteResult, attachAction, submitData, parentActionList, attachActionExecuteResultList),
                () -> checkActionIsExecuteSeata(attachAction.getActionList().get(0).getCategory(), executeContext.get(0).getTmActivityId()));

        //如果包括合并任务的action执行一次
        if (attachAction.getActionList().stream().anyMatch(dataSubmissionService::isSupportSubmitMergeData)
                && CollectionUtils.isNotEmpty(attachActionExecuteResultList)
                && !attachActionExecuteResultList.get(0).getExecuteState()) {
            dataSubmissionService.executeCoreWapper(executeContext.get(0), null, attachAction.getActionList().get(0), submitData.get(0));
        }

        if (CollectionUtils.isNotEmpty(attachAction.getAttachActions())) {
            for (SubmitAction attachAttachAction : attachAction.getAttachActions()) {
                if (attachAction.getActionList().stream().anyMatch(t ->
                        UiBotConstants.ACTION_CATEGORY_BPM.equals(t.getCategory()) || UiBotConstants.ACTION_CATEGORY_TASK_ENGINE.equals(t.getCategory()))) {
                    continue;
                }
                executeAttachAction(maxDepath, index, executeContext, attachAction, attachActionExecuteResultList, attachAttachAction, submitData);
            }
        }
    }

    private int recurrentAttachAction(int maxDepath, Set<Integer> index, List<SubmitExecuteContext> executeContext, List<ExecuteResult> parentExecuteResult, SubmitAction attachAction, List<Map<String, Object>> submitData, List<SubmitAction> parentActionList, List<ExecuteResult> attachActionExecuteResultList) {
        for (int i = 0; i < maxDepath; i++) {
            if (CollectionUtils.isNotEmpty(index) && index.contains(i)) {
                continue;
            }
            Map<String, Object> parentConvertedData = parentExecuteResult.get(i).getRequestData();
            Map<String, Object> parentResponseData = parentExecuteResult.get(i).getData();
            attachAction.getActionList().get(i).setBusinessUnit(parentActionList.get(i).getBusinessUnit());
            if (null != parentActionList.get(i).getServiceId()) {
                attachAction.getActionList().get(i).getServiceId().setProxyToken(parentActionList.get(i).getServiceId().getProxyToken());
            }
            String dataFrom = "";
            if (attachAction.getActionList().get(i).getExtendParas() != null && attachAction.getActionList().get(i).getExtendParas().containsKey("dataSource")) {
                dataFrom = attachAction.getActionList().get(i).getExtendParas().get("dataSource").toString();
            }
            Map<String, Object> convertedData = null;
            switch (dataFrom) {
                case "parent":
                case "parentRequest": {
                    convertedData = parentConvertedData;
                    break;
                }
                case "submit": {
                    convertedData = submitData.get(i);
                    break;
                }
                case "parentAndParentResponse": {
                    convertedData = parentConvertedData;
                    if (parentResponseData != null) {
                        for (Map.Entry<String, Object> stringListEntry : parentResponseData.entrySet()) {
                            convertedData.put(stringListEntry.getKey(), stringListEntry.getValue());
                        }
                    }
                    break;
                }
                case "submitWithParentResponse":
                case "parentResponse": {
                    convertedData = submitData.get(i);
                    if (parentResponseData != null) {
                        for (Map.Entry<String, Object> stringListEntry : parentResponseData.entrySet()) {
                            convertedData.put(stringListEntry.getKey(), stringListEntry.getValue());
                        }
                    }
                    break;
                }
                default: {
                    convertedData = submitData.get(i);
                }
            }
            executeContext.get(i).setParentAction(parentActionList.get(i));
            ExecuteResult attachActionExecuteResult = dataSubmissionService.executeCoreWapper(executeContext.get(i), parentExecuteResult.get(i), attachAction.getActionList().get(i), convertedData);
            attachActionExecuteResultList.add(attachActionExecuteResult);
        }
        return 1;
    }

    private void setExecuteContext(int depath, HttpServletRequest request, SubmitAction taskAction, SubmitExecuteContext parentExecuteContext) {
        SubmitAction submitAction = taskAction.getActionList().get(depath);
        SubmitExecuteContext executeContext = submitAction.getExecuteContext();
        if (executeContext == null) {
            executeContext = parentExecuteContext;
            submitAction.setExecuteContext(parentExecuteContext);
        } else {
            executeContext.appendHttpRequest(request);
        }

        if (CollectionUtils.isNotEmpty(taskAction.getAttachActions())) {
            List<SubmitAction> attachActions = taskAction.getAttachActions();
            for (SubmitAction attachAction : attachActions) {
                setExecuteContext(depath, request, attachAction, executeContext);
            }
        }
    }

    private void findSupportSubmitMergeDataActions(List<SubmitAction> list, SubmitAction taskAction) {
        if (taskAction.getActionList().stream().anyMatch(t -> this.dataSubmissionService.isSupportSubmitMergeData(t))) {
            list.add(taskAction);
        }
        if (CollectionUtils.isNotEmpty(taskAction.getAttachActions())) {
            for (SubmitAction attachAction : taskAction.getAttachActions()) {
                findSupportSubmitMergeDataActions(list, attachAction);
            }
        }
    }

    private Collection<SubmitAction> initSubmitMergeDataActions(List<SubmitAction> mergeDataActions) {
        if (CollectionUtils.isEmpty(mergeDataActions)) {
            return mergeDataActions;
        }
        Map<String, SubmitAction> firstActions = new LinkedHashMap<>();
        for (SubmitAction action : mergeDataActions) {
            for (SubmitAction submitAction : action.getActionList()) {
                //设置模拟执行
                if (!firstActions.containsKey(submitAction.getActionId())) {
                    firstActions.put(submitAction.getActionId(), submitAction);
                }
                submitAction.setMergeDataAction(firstActions.get(submitAction.getActionId()));
            }
        }
        return firstActions.values();
    }

    public List<ExecuteResult> executeMergeActionWapper(HttpServletRequest request, List<SubmitActionDTO> submitActionList) throws Throwable {
        MergeSubmitActionDTO mergeSubmitAction = null;
        try {
            mergeSubmitAction = getMergeSubmitAction(submitActionList);
            return executeMergeAction(request, mergeSubmitAction);
        } catch (Throwable e) {
            if (mergeSubmitAction != null && checkMergeExecute(submitActionList.get(0).getAction())) {
                logRecord(request, mergeSubmitAction);
            }
            throw e;
        }finally {
            SEATA_TM_ACTIVITY_ID_HOLDER.remove();
        }
    }

    public List<ExecuteResult> executeMergeAction(HttpServletRequest request, MergeSubmitActionDTO mergeSubmitAction) throws Throwable {

        List<ExecuteResult> resultList = new ArrayList<>();
        log.info("start to deal find support submit merge data action start");
        //所有合并数据的任务
        List<SubmitAction> mergeDataActions = new ArrayList<>();
        SubmitAction actionMerge = mergeSubmitAction.getActionMerge();
        List<Map<String, Object>> dataMerge = mergeSubmitAction.getDataMerge();

        findSupportSubmitMergeDataActions(mergeDataActions, actionMerge);

        log.info("start to deal find support submit merge data action end");
        initSubmitMergeDataActions(mergeDataActions);
        log.info("init submit merge data action end");
        //执行 所有合并数据的任务之外的action
        int maxDepath = actionMerge.getActionList().size();
        List<SubmitExecuteContext> submitExecuteContextList = new ArrayList<>();
        String backlogId = "";
        String tenantId = "";
        for (int i = 0; i < maxDepath; i++) {
            SubmitAction taskAction = actionMerge.getActionList().get(i);
            SubmitExecuteContext executeContext = taskAction.getExecuteContext();
            if (executeContext == null) {
                executeContext = SubmitExecuteContext.createByHttpRequest(request);
            }
            if (StringUtils.hasText(executeContext.getProxyToken())) {
                AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
            }

            executeContext.setOperateAuthoredUser(mergeSubmitAction.getOperateAuthoredUser());
            setExecuteContext(i, request, actionMerge, executeContext);
            submitExecuteContextList.add(executeContext);
            backlogId = String.valueOf(executeContext.getBacklogId());
            tenantId = mergeSubmitAction.getOperateAuthoredUser() == null ? "" : mergeSubmitAction.getOperateAuthoredUser().getTenantId();
        }
        LogDto logDto = new LogDto("执行action开始，backlogId：" + backlogId, tenantId + LogConstant.TRACE_SEPARATOR + backlogId);
        log.info(logDto.toString());
        resultList = this.submit(maxDepath, submitExecuteContextList, actionMerge, dataMerge);
        LogDto logDtoEnd = new LogDto("执行action结束，backlogId：" + backlogId, tenantId + LogConstant.TRACE_SEPARATOR + backlogId);
        log.info(logDtoEnd.toString());

        return resultList;
    }

    public static MergeSubmitActionDTO getMergeSubmitAction(List<SubmitActionDTO> submitActionDTOS) {
        SubmitAction mergedTree = mergeMultipleTrees(submitActionDTOS.stream().map(SubmitActionDTO::getAction).collect(Collectors.toList()));
        MergeSubmitActionDTO mergeSubmitActionDTO = new MergeSubmitActionDTO();
        mergeSubmitActionDTO.setActionMerge(mergedTree);
        mergeSubmitActionDTO.setDataMerge(submitActionDTOS.stream().map(SubmitActionDTO::getData).collect(Collectors.toList()));
        mergeSubmitActionDTO.setOperateAuthoredUser(submitActionDTOS.get(0).getOperateAuthoredUser());
        return mergeSubmitActionDTO;
    }

    private static <T extends Serializable> T deepCopy(T value, Class<T> valueType) {
        try {
            return SerializationUtils.clone(value);
        } catch (Exception e) {
            try {
                return JsonUtils.jsonToObject(JsonUtils.objectToString(value), valueType);
            } catch (Exception exception) {
                throw BusinessException.create("参数拷贝失败", e);
            }
        }
    }

    public static SubmitAction mergeMultipleTrees(List<SubmitAction> treesToMerge) {
        SubmitAction mergedTree = new SubmitAction();

        List<SubmitAction> actionList = new ArrayList<>();
        for (SubmitAction tree : treesToMerge) {
            SubmitAction submitAction = deepCopy(tree, SubmitAction.class);
            submitAction.setAttachActions(null);
            actionList.add(submitAction);
        }
        mergedTree.setActionList(actionList);

        // 对于attachActions中的每个子节点，进行递归合并操作
        List<SubmitAction> mergedAttachActions = new ArrayList<>();
        int maxDepth = 0;
        if (CollectionUtils.isNotEmpty(treesToMerge.get(0).getAttachActions())) {
            maxDepth = treesToMerge.get(0).getAttachActions().size();
        }

        for (int i = 0; i < maxDepth; i++) {
            List<SubmitAction> subtreeList = new ArrayList<>();
            for (SubmitAction tree : treesToMerge) {
                if (CollectionUtils.isNotEmpty(tree.getAttachActions()) && tree.getAttachActions().size() > i) {
                    subtreeList.add(tree.getAttachActions().get(i));
                }
            }
            mergedAttachActions.add(mergeMultipleTrees(subtreeList));
        }
        mergedTree.setAttachActions(mergedAttachActions);

        return mergedTree;
    }

    public static boolean checkMergeExecute(SubmitAction submitAction) {
        if (!submitAction.getCategory().equals(UiBotConstants.ACTION_CATEGORY_ESP) && !ACTION_LIST.contains(submitAction.getActionId())) {
            return false;
        }
        return recursiveCheckMergeExecute(submitAction.getAttachActions());
    }

    public static boolean recursiveCheckMergeExecute(List<SubmitAction> attachActions) {
        for (SubmitAction submitAction : attachActions) {
            if (!submitAction.getCategory().equals(UiBotConstants.ACTION_CATEGORY_ESP) && !ACTION_LIST.contains(submitAction.getActionId())) {
                return false;
            }
            if (CollectionUtils.isNotEmpty(submitAction.getAttachActions())) {
                return recursiveCheckMergeExecute(submitAction.getAttachActions());
            }
        }
        return true;
    }

    public void logRecord(HttpServletRequest request, MergeSubmitActionDTO submitAction) {
        try {
            LogRecordDTO logRecordDTO = new LogRecordDTO();
            logRecordDTO.setInputValue(JsonUtils.objectToString(submitAction));
            logRecordDTO.setCreateTime(new Date());
            logRecordDTO.setUrl(MERGE_TASK_URL);
            LogRecordEvent logRecordEvent = new LogRecordEvent(request, logRecordDTO, submitAction.getOperateAuthoredUser());
            asyncEventBus.post(logRecordEvent);
        } catch (Exception e) {
            log.error("记录日志EventBus任务异常：{}", e.getMessage());
        }
    }
}
