/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.fi.CommonForecastingIntelligenceService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=40)
@Service(value="commit-data-to-fi")
public class CommitDataToFiActionExecutor
implements ActionExecutor {
    @Autowired
    private CommonForecastingIntelligenceService commonForecastingIntelligenceService;

    public String supportKey() {
        return "UIBOT:commit-data-to-fi";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action == null || parameter == null) {
            return ExecuteResult.ok();
        }
        Map<String, Object> data = parameter;
        HashMap<String, String> user = new HashMap<String, String>();
        user.put("userId", executeContext.getAuthoredUser().getUserId());
        user.put("userName", executeContext.getAuthoredUser().getUserName());
        user.put("tenantId", executeContext.getAuthoredUser().getTenantId());
        user.put("tenantName", executeContext.getAuthoredUser().getTenantName());
        HashMap<String, Object> task = new HashMap<String, Object>();
        task.put("identity", "");
        task.put("projectId", 0L);
        task.put("backlogId", executeContext.getBacklogId());
        task.put("startTime", "");
        task.put("planEndTime", "");
        task.put("backlogName", "");
        task.put("performerId", "");
        task.put("performerName", "");
        task.put("projectName", "");
        task.put("tmProjectId", executeContext.getTmProjectId());
        task.put("tmActivityId", executeContext.getTmActivityId());
        task.put("activityType", "");
        task.put("pattern", executeContext.getPattern());
        task.put("category", executeContext.getCategory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("locale", executeContext.getLocale());
        context.put("clientAgent", executeContext.getClientAgent());
        context.put("businessUnit", executeContext.getBusinessUnit());
        Map result = this.commonForecastingIntelligenceService.taskSubmit(data, user, task, context);
        ExecuteResult executeResult = ExecuteResult.ok();
        return executeResult;
    }
}

