/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=110)
@Service(value="delete-activity-bpm-variable-value")
class DeleteActivityBpmVariableActionExecutor
implements ActionExecutor {
    @Autowired
    CommonAtmcService atmcService;
    @Autowired
    MessageUtils messageUtils;

    DeleteActivityBpmVariableActionExecutor() {
    }

    public String supportKey() {
        return "UIBOT:delete-activity-bpm-variable-value";
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        this.check(action, parameter);
        SubmitExecuteContext submitExecuteContext = action.getExecuteContext();
        this.delActivityVariable(executeContext, new SubmitParameter(submitExecuteContext.getBacklogId(), submitExecuteContext.getBpmData(), parameter, action.getExtendParas()).invoke());
        return ExecuteResult.ok();
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitAction action = actionExecuteReq.getAction();
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        if (executeContext.isMinSplit()) {
            Map workItemIdToBpmData = executeContext.getWorkItemIdToBpmData();
            Map workItemIdToData = actionExecuteReq.getWorkItemIdToData();
            workItemIdToData.forEach((k, v) -> this.delActivityVariable(executeContext, new SubmitParameter((Long)k, (Map)workItemIdToBpmData.get(k), (Map<String, Object>)v, action.getExtendParas()).invoke()));
            return ExecuteResult.ok();
        }
        return super.execute(actionExecuteReq);
    }

    private void check(SubmitAction action, Map<String, Object> parameter) {
        if (action == null || parameter == null || action.getExecuteContext() == null || action.getExecuteContext().getBacklogId() == null || action.getExecuteContext().getBpmData() == null || action.getExtendParas() == null || action.getExtendParas().size() == 0) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0017.getErrCode(), (String)this.messageUtils.getMessage("exception.delete.activity.bpm.variable.value"));
        }
    }

    private void delActivityVariable(SubmitExecuteContext executeContext, SubmitParameter submitParameter) {
        Map<String, Object> bpmParas = submitParameter.getBpmParas();
        List<Map<String, Object>> queryParas = submitParameter.getQueryParas();
        String compareFields = submitParameter.getCompareFields();
        String processVariableName = submitParameter.getProcessVariableName();
        Set<String> submitKeys = submitParameter.getSubmitKeys();
        if (queryParas != null && !submitKeys.isEmpty()) {
            if (queryParas.size() == submitKeys.size()) {
                this.atmcService.emptyActivityData(this.getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                if (executeContext.getParentAction() != null) {
                    executeContext.getParentAction().setCheckCompleteAction(null);
                }
            } else {
                String[] fields = compareFields.split(";");
                ArrayList<Map<String, Object>> newQueryPara = new ArrayList<Map<String, Object>>();
                ArrayList<Map<String, Object>> deleteQueryPara = new ArrayList<Map<String, Object>>();
                for (Map<String, Object> queryPara : queryParas) {
                    StringBuilder queryKey = new StringBuilder();
                    for (String field : fields) {
                        if (queryPara.containsKey(field)) {
                            queryKey.append(queryPara.get(field).toString()).append(";");
                            continue;
                        }
                        queryKey.append(";");
                    }
                    if (!submitKeys.contains(queryKey.toString())) {
                        newQueryPara.add(queryPara);
                        continue;
                    }
                    deleteQueryPara.add(queryPara);
                }
                bpmParas.put(processVariableName, newQueryPara);
                if (deleteQueryPara.size() == queryParas.size()) {
                    this.atmcService.emptyActivityData(this.getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                    if (executeContext.getParentAction() != null) {
                        executeContext.getParentAction().setCheckCompleteAction(null);
                    }
                } else {
                    boolean needResetActivityData = true;
                    if (CollectionUtils.isNotEmpty(deleteQueryPara) && executeContext.getParentAction() != null && executeContext.getParentAction().getCheckCompleteAction() != null) {
                        if (deleteQueryPara.size() == queryParas.size()) {
                            executeContext.getParentAction().setCheckCompleteAction(null);
                        } else {
                            QueryAction checkAction = executeContext.getParentAction().getCheckCompleteAction().getAction();
                            String dataKey = this.parseCheckActionParaDataKey(checkAction, processVariableName);
                            if (checkAction.getParas() != null && checkAction.getParas().containsKey(dataKey)) {
                                List checkActionParas = (List)checkAction.getParas().get(dataKey);
                                block2: for (Map map : deleteQueryPara) {
                                    StringBuilder deleteKey = new StringBuilder();
                                    for (String field : fields) {
                                        if (map.containsKey(field)) {
                                            deleteKey.append(map.get(field).toString()).append(";");
                                            continue;
                                        }
                                        deleteKey.append(";");
                                    }
                                    for (Map checkPara : checkActionParas) {
                                        StringBuilder checkKey = new StringBuilder();
                                        for (String field : fields) {
                                            if (checkPara.containsKey(field)) {
                                                checkKey.append(checkPara.get(field).toString()).append(";");
                                                continue;
                                            }
                                            checkKey.append(";");
                                        }
                                        if (!Objects.equals(deleteKey.toString(), checkKey.toString())) continue;
                                        checkActionParas.remove(checkPara);
                                        continue block2;
                                    }
                                }
                                if (CollectionUtils.isEmpty((Collection)checkActionParas)) {
                                    this.atmcService.emptyActivityData(this.getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                                    if (executeContext.getParentAction() != null) {
                                        executeContext.getParentAction().setCheckCompleteAction(null);
                                    }
                                    needResetActivityData = false;
                                }
                            }
                        }
                    }
                    if (needResetActivityData) {
                        this.atmcService.resetActivityData(this.getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                    }
                }
            }
        }
    }

    private String parseCheckActionParaDataKey(QueryAction checkAction, String processVariableName) {
        String dataKey = processVariableName;
        if (Objects.isNull(checkAction.getParas()) || checkAction.getParas().containsKey(dataKey)) {
            return dataKey;
        }
        if (checkAction.getParas().size() == 1) {
            return checkAction.getParas().keySet().toArray()[0].toString();
        }
        if (CollectionUtils.isNotEmpty((Collection)checkAction.getActionParams())) {
            for (ActionParameterMapping actionParam : checkAction.getActionParams()) {
                if (!StringUtils.equals((String)actionParam.getType(), (String)"PROCESS_VARIABLE") || !StringUtils.equals((String)actionParam.getValue(), (String)processVariableName)) continue;
                dataKey = actionParam.getName();
                break;
            }
        }
        return dataKey;
    }

    private Map<String, Object> getResetParameter(Long backlogId, String processVariableName, String dataKeys, Map<String, Object> bpmData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workItemId", backlogId);
        map.put("dataKeys", dataKeys);
        map.put("processVariableName", processVariableName);
        map.put("bpmData", bpmData);
        return map;
    }

    private List<Map<String, Object>> getSubmitParas(List<Map<String, Object>> paramList, String field) {
        if (StringUtils.isBlank((String)field)) {
            return paramList;
        }
        ArrayList submitParas = Lists.newArrayList();
        for (Map<String, Object> param : paramList) {
            Object paramValueObj = param.get(field);
            if (paramValueObj instanceof Map) {
                submitParas.add((Map)paramValueObj);
                continue;
            }
            if (paramValueObj instanceof Collection) {
                submitParas.addAll((List)paramValueObj);
                continue;
            }
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0020.getErrCode(), (String)(this.messageUtils.getMessage("exception.submit.data2") + field + this.messageUtils.getMessage("exception.data.type.error")));
        }
        return submitParas;
    }

    private class SubmitParameter {
        private Long backlogId;
        private Map<String, Object> parameter;
        private Map<String, Object> bpmParas;
        private List<Map<String, Object>> queryParas;
        private String compareFields;
        private String processVariableName;
        private Set<String> submitKeys;
        private Map<String, Object> extendParas;

        public SubmitParameter(Long backlogId, Map<String, Object> bpmParas, Map<String, Object> parameter, Map<String, Object> extendParas) {
            this.parameter = parameter;
            this.backlogId = backlogId;
            this.bpmParas = bpmParas;
            this.extendParas = extendParas;
        }

        public Long getBacklogId() {
            return this.backlogId;
        }

        public Map<String, Object> getBpmParas() {
            return this.bpmParas;
        }

        public List<Map<String, Object>> getQueryParas() {
            return this.queryParas;
        }

        public String getCompareFields() {
            return this.compareFields;
        }

        public String getProcessVariableName() {
            return this.processVariableName;
        }

        public Set<String> getSubmitKeys() {
            return this.submitKeys;
        }

        public SubmitParameter invoke() {
            this.queryParas = null;
            List submitParas = null;
            this.compareFields = null;
            this.processVariableName = "";
            String submitVariableName = "";
            block10: for (Map.Entry<String, Object> extendParasEntry : this.extendParas.entrySet()) {
                switch (extendParasEntry.getKey()) {
                    case "processVariableName": {
                        this.processVariableName = String.valueOf(extendParasEntry.getValue());
                        if (this.bpmParas.containsKey(this.processVariableName)) {
                            Object procVarObj = this.bpmParas.get(this.processVariableName);
                            if (null == procVarObj) continue block10;
                            if (procVarObj instanceof Map) {
                                this.queryParas = new ArrayList<Map<String, Object>>();
                                this.queryParas.add((Map)procVarObj);
                                break;
                            }
                            if (procVarObj instanceof List) {
                                this.queryParas = (List)procVarObj;
                                break;
                            }
                            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0018.getErrCode(), (String)String.format(DeleteActivityBpmVariableActionExecutor.this.messageUtils.getMessage("exception.bpm.data.type.error"), this.processVariableName));
                        }
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0019.getErrCode(), (String)String.format(DeleteActivityBpmVariableActionExecutor.this.messageUtils.getMessage("exception.bpm.data.empty"), this.processVariableName));
                    }
                    case "submitVariableName": {
                        submitVariableName = String.valueOf(extendParasEntry.getValue());
                        if (this.parameter.containsKey(submitVariableName)) {
                            submitParas = DeleteActivityBpmVariableActionExecutor.this.getSubmitParas(Lists.newArrayList((Object[])new Map[]{this.parameter}), submitVariableName);
                            String detailField = StrUtil.toStringOrNull((Object)this.extendParas.get("detailField"));
                            submitParas = DeleteActivityBpmVariableActionExecutor.this.getSubmitParas(submitParas, detailField);
                            break;
                        }
                        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0021.getErrCode(), (String)String.format(DeleteActivityBpmVariableActionExecutor.this.messageUtils.getMessage("exception.bpm.data.empty"), submitVariableName));
                    }
                    case "dataKeys": {
                        this.compareFields = String.valueOf(extendParasEntry.getValue());
                    }
                }
            }
            this.submitKeys = new HashSet<String>();
            if (this.queryParas != null && null != this.compareFields && !"".equals(this.compareFields)) {
                String[] fields = this.compareFields.split(";");
                for (Map submitPara : submitParas) {
                    StringBuilder submitKeyStringBuilder = new StringBuilder();
                    for (String field : fields) {
                        if (submitPara.containsKey(field)) {
                            submitKeyStringBuilder.append(submitPara.get(field)).append(";");
                            continue;
                        }
                        submitKeyStringBuilder.append(";");
                    }
                    boolean isFind = false;
                    for (Map<String, Object> processPara : this.queryParas) {
                        StringBuilder processKeyStringBuilder = new StringBuilder();
                        for (String field : fields) {
                            if (processPara.containsKey(field)) {
                                processKeyStringBuilder.append(processPara.get(field)).append(";");
                                continue;
                            }
                            processKeyStringBuilder.append(";");
                        }
                        if (!CharSequenceUtil.equals((CharSequence)processKeyStringBuilder, (CharSequence)submitKeyStringBuilder)) continue;
                        this.submitKeys.add(submitKeyStringBuilder.toString());
                        for (Map.Entry entry : processPara.entrySet()) {
                            if (submitPara.containsKey(entry.getKey())) continue;
                            submitPara.put(entry.getKey(), entry.getValue());
                        }
                        isFind = true;
                        break;
                    }
                    if (isFind) continue;
                    throw BusinessException.create((String)ErrorCodeEnum.BUSINESS_600_0002.getErrCode(), (String)(submitKeyStringBuilder + DeleteActivityBpmVariableActionExecutor.this.messageUtils.getMessage("exception.not.find")));
                }
            }
            return this;
        }
    }
}

