/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartManualProjectActionExecutor
implements ActionExecutor {
    @Autowired
    private CommonSmartDataService commonSmartDataService;
    private static final String SUBMIT_DATA_ACTION_ID_KEY = "startActionId";

    public String supportKey() {
        return "MANUALPROJECT:";
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (MapUtils.isEmpty(data)) {
            return ExecuteResult.empty();
        }
        Map paraMap = null;
        String actionId = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (SUBMIT_DATA_ACTION_ID_KEY.equals(entry.getKey())) {
                actionId = String.valueOf(entry.getValue());
                continue;
            }
            paraMap = (Map)entry.getValue();
        }
        if (paraMap == null || paraMap.isEmpty()) {
            return ExecuteResult.empty();
        }
        String actualProjectCode = (String)paraMap.remove("adapterToStartProject");
        if (StringUtils.isNotBlank((String)actualProjectCode)) {
            actionId = actualProjectCode;
        }
        ExecuteResult result = ExecuteResult.ok();
        result.setData(new HashMap());
        HashMap extendedFields = Maps.newHashMap();
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        List<Object> retList = this.executeSubmitAction(executeContext.getAuthoredUser().getTenantId(), actionId, paraMap, extendedFields);
        result.getData().put("projectCardInfo", retList);
        return result;
    }

    private List<Object> executeSubmitAction(String tenantId, String actionId, Map<String, Object> paraMap, Map extendedFields) {
        List eocMapList = (List)paraMap.remove("eocInfo");
        ArrayList<Object> retList = new ArrayList<Object>();
        if (CollectionUtils.isEmpty((Collection)eocMapList)) {
            Map[] paras = new Map[]{paraMap};
            Object retMap = this.commonSmartDataService.executeForManualProject(tenantId, actionId, paras, Collections.emptyMap(), extendedFields);
            retList.add(retMap);
            return retList;
        }
        for (Map eocMap : eocMapList) {
            HashMap<String, Object> newParaMap = new HashMap<String, Object>();
            newParaMap.putAll(paraMap);
            newParaMap.put("eocMap", eocMap);
            newParaMap.put("eocInfo", eocMap);
            Map[] paras = new Map[]{newParaMap};
            Object forEachMap = this.commonSmartDataService.executeForManualProject(tenantId, actionId, paras, eocMap, extendedFields);
            retList.add(forEachMap);
        }
        return retList;
    }
}

