/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.action.executor.TaskEngineActionExecutorBase;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import com.digiwin.athena.atdm.util.ActivityUtils;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=100)
@Service(value="taskEngineTerminateTaskActionExecutor")
class TaskEngineTerminateTaskActionExecutor
extends TaskEngineActionExecutorBase {
    @Autowired
    private CommonTaskEngineService commonTaskEngineService;
    @Autowired
    private CommonPtmService ptmService;

    TaskEngineTerminateTaskActionExecutor() {
    }

    public String supportKey() {
        return "TaskEngine:terminate-task";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        this.commonTaskEngineService.execute((Action)action);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if (BooleanUtils.isTrue((Boolean)submitExecuteContext.isMinSplit())) {
            SubmitAction action = actionExecuteReq.getAction();
            Map paras = action.getParas();
            paras.put("workItemIds", ActivityUtils.getMinSplitWorkItemIds((ActionExecuteReq)actionExecuteReq));
            ActionServiceId serviceId = action.getServiceId();
            serviceId.setServiceUri("api/task/card/min/split/terminate");
            this.ptmService.execute((Action)action);
            ExecuteResult result = ExecuteResult.ok();
            result.setCompleted(true);
            return result;
        }
        return super.execute(actionExecuteReq);
    }
}

