/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.activity.service.BpmServiceInvokeType;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawCrossBkReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.util.TrackingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=102)
@Service(value="uibot_task_withdraw_cross_bk")
public class TaskWithdrawCrossBkExecutor
implements ActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(TaskWithdrawCrossBkExecutor.class);
    @Autowired
    private CommonPtmService commonPtmService;
    @Autowired
    private CommonUiBotService commonUiBotService;
    @Autowired
    private DataSubmissionService dataSubmissionService;
    @Autowired
    private TrackingUtil trackingUtil;
    private static final int STATE_CLOSE = 3;

    public String supportKey() {
        return "TaskEngine:" + BpmServiceInvokeType.TaskWithdrawCrossBk.getName();
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        LogDto logDto = new LogDto("[ptm-task-crossbk-withdraw] \u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)action));
        log.info(logDto.toString());
        AuthoredUser authoredUser = executeContext.getAuthoredUser();
        String performerId = this.parsePerformerId(action.getParas(), authoredUser);
        Integer performerType = this.parsePerformerType(action.getParas(), executeContext.getPageCode());
        List<PtmWorkItemDTO> withdrawReqDTOList = this.executeRelativeTaskWithdrawCrossBk(performerId, performerType, action);
        this.checkRelativeTaskCompleted(authoredUser, withdrawReqDTOList);
        return ExecuteResult.ok();
    }

    private void checkRelativeTaskCompleted(AuthoredUser authoredUser, List<PtmWorkItemDTO> needParseRelativeTaskList) {
        if (CollectionUtils.isEmpty(needParseRelativeTaskList)) {
            return;
        }
        if (CollectionUtils.isEmpty(needParseRelativeTaskList = needParseRelativeTaskList.stream().filter(ptmWorkItemDTO -> 3 > ptmWorkItemDTO.getState()).collect(Collectors.toList()))) {
            return;
        }
        Map workItemPageDefineMap = this.commonUiBotService.queryTaskCrossBkWithdrawPageDefine(needParseRelativeTaskList);
        if (MapUtils.isEmpty((Map)workItemPageDefineMap)) {
            return;
        }
        for (Map.Entry workItemPageDefine : workItemPageDefineMap.entrySet()) {
            Long workItemId = (Long)workItemPageDefine.getKey();
            List pageDefines = (List)workItemPageDefine.getValue();
            if (CollectionUtils.isEmpty((Collection)pageDefines)) continue;
            SubmitAction dispatchAction = null;
            for (Map pageDefine : pageDefines) {
                if (null == pageDefine || null == pageDefine.get("executeContext") || null == pageDefine.get("dataSourceSet")) {
                    log.error("[ptm-task-crossbk-withdraw{}] \u672a\u80fd\u6210\u529f\u89e3\u6790\u51fa\u9875\u7b7e\u5b9a\u4e49", (Object)workItemId);
                    continue;
                }
                ExecuteContext executeContext = this.convertJson(pageDefine.get("executeContext"), ExecuteContext.class);
                executeContext.setAuthoredUser(authoredUser);
                if (StringUtils.isBlank((String)executeContext.getTenantId())) {
                    executeContext.setTenantId(executeContext.getAuthoredUser().getTenantId());
                }
                if (null == pageDefine.get("submitActions") || !CollectionUtils.isNotEmpty((Collection)((List)pageDefine.get("submitActions")))) continue;
                dispatchAction = (SubmitAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString(((List)pageDefine.get("submitActions")).get(0)), SubmitAction.class);
            }
            if (null == dispatchAction) continue;
            if (null == dispatchAction.getExecuteContext().getAuthoredUser()) {
                dispatchAction.getExecuteContext().setAuthoredUser(authoredUser);
            }
            if (StringUtils.isBlank((String)dispatchAction.getExecuteContext().getTenantId())) {
                dispatchAction.getExecuteContext().setTenantId(authoredUser.getTenantId());
            }
            this.dataSubmissionService.submit(dispatchAction.getExecuteContext(), dispatchAction, new HashMap<String, Object>());
        }
    }

    private Integer parsePerformerType(Map<String, Object> actionParas, String pageCode) {
        if ("project-detail".equals(pageCode)) {
            return 999;
        }
        if (MapUtils.isEmpty(actionParas)) {
            return 0;
        }
        Object performerType = actionParas.get("performerType");
        if (null == performerType) {
            return 0;
        }
        return Integer.valueOf(performerType.toString());
    }

    private String parsePerformerId(Map<String, Object> actionParas, AuthoredUser authoredUser) {
        if (MapUtils.isEmpty(actionParas)) {
            return authoredUser.getUserId();
        }
        Object performerId = actionParas.get("agentPerformerId");
        if (null == performerId) {
            return authoredUser.getUserId();
        }
        return performerId.toString();
    }

    private List<PtmWorkItemDTO> executeRelativeTaskWithdrawCrossBk(String performerId, Integer performerType, SubmitAction action) {
        Map rowParas = action.getParas();
        ActionServiceId serviceId = action.getServiceId() == null ? ActionServiceId.empty() : action.getServiceId();
        ArrayList<PtmWorkItemDTO> uiBotTaskCrossBkWithdrawReqDTOList = new ArrayList<PtmWorkItemDTO>();
        if (MapUtils.isEmpty((Map)rowParas) || null == rowParas.get("params") || StringUtils.isEmpty((String)serviceId.getServiceUri())) {
            return uiBotTaskCrossBkWithdrawReqDTOList;
        }
        String workitemId = String.valueOf(rowParas.get("workitemId"));
        List<PtmWithdrawCrossBkReqDTO> retrieveReqDTOList = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(rowParas.get("params")), PtmWithdrawCrossBkReqDTO.class);
        if (StringUtils.isEmpty((String)workitemId) || CollectionUtils.isEmpty((Collection)retrieveReqDTOList)) {
            return uiBotTaskCrossBkWithdrawReqDTOList;
        }
        retrieveReqDTOList = retrieveReqDTOList.stream().filter(ptmWithdrawCrossBkReqDTO -> workitemId.equals(ptmWithdrawCrossBkReqDTO.getWorkitemId())).collect(Collectors.toList());
        rowParas.put("params", retrieveReqDTOList);
        retrieveReqDTOList.forEach(withdrawReqDTO -> {
            withdrawReqDTO.setPerformerId(performerId);
            withdrawReqDTO.setPerformerType(performerType);
            withdrawReqDTO.setComment("\u6570\u636e\u64a4\u56de");
        });
        LogDto logDto = new LogDto("[ptm-task-withdraw-{}] atdm\u8bbf\u95eePTM\u6267\u884c\u4efb\u52a1\u64a4\u56de, \u8bf7\u6c42\u53c2\u6570:" + JsonUtils.objectToString(retrieveReqDTOList));
        log.info(logDto.toString());
        List ptmWorkItemDTOS = this.commonPtmService.executeRelativeTaskWithdrawCrossBk(retrieveReqDTOList, serviceId.getServiceUri());
        if (CollectionUtils.isNotEmpty((Collection)ptmWorkItemDTOS)) {
            String code = ptmWorkItemDTOS.stream().map(PtmWorkItemDTO::getTaskDefCode).collect(Collectors.joining(","));
            this.trackingUtil.reportUserTrack("task", code, "\u8de8BK\u64a4\u56de");
        }
        return ptmWorkItemDTOS;
    }

    private <T> T convertJson(Object param, Class<T> clz) {
        return (T)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)param), clz);
    }
}

