/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=110)
@Service(value="update-activity-query-variable-value")
class UpdateActivityQueryParameterExecutor
implements ActionExecutor {
    @Autowired
    CommonAtmcService atmcService;
    @Autowired
    MessageUtils messageUtils;

    UpdateActivityQueryParameterExecutor() {
    }

    public String supportKey() {
        return "UIBOT:update-activity-query-variable-value";
    }

    public boolean hasActionMetadata() {
        return false;
    }

    public boolean supportRetry() {
        return true;
    }

    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action == null || parameter == null || action.getExecuteContext() == null || action.getExecuteContext().getBacklogId() == null || action.getExecuteContext().getBpmData() == null || action.getExtendParas() == null || action.getExtendParas().size() == 0) {
            return ExecuteResult.ok();
        }
        DataSourceDTO dataSourceDTO = action.getCheckCompleteAction();
        if (dataSourceDTO == null && executeContext.getParentAction() != null && executeContext.getParentAction().getCheckCompleteAction() != null) {
            dataSourceDTO = executeContext.getParentAction().getCheckCompleteAction();
        }
        Map bpmParas = null;
        if (dataSourceDTO != null && dataSourceDTO.getAction() != null) {
            bpmParas = dataSourceDTO.getAction().getParas();
        }
        List submitParas = null;
        List queryParas = null;
        String submitVariableName = "";
        for (Map.Entry stringObjectEntry : action.getExtendParas().entrySet()) {
            if ("submitVariableName".equals(stringObjectEntry.getKey())) {
                submitVariableName = stringObjectEntry.getValue().toString();
                if (parameter.containsKey(submitVariableName)) {
                    submitParas = (List)parameter.get(submitVariableName);
                } else {
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0041.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                }
            }
            if (!"queryVariableName".equals(stringObjectEntry.getKey())) continue;
            String queryVariableName = stringObjectEntry.getValue().toString();
            if (bpmParas == null || !bpmParas.containsKey(queryVariableName)) continue;
            queryParas = (List)bpmParas.get(queryVariableName);
        }
        if (submitParas == null || submitParas.size() == 0) {
            return ExecuteResult.ok();
        }
        ArrayList<Map> submitData = new ArrayList<Map>();
        for (Map map : submitParas) {
            if (map.containsKey("uibot_checked")) {
                boolean checked = map.get("uibot_checked") == null ? false : BooleanUtils.toBoolean((String)map.get("uibot_checked").toString());
                if (!checked) continue;
                submitData.add(map);
                continue;
            }
            submitData.add(map);
        }
        HashMap<String, ArrayList<Map>> traceData = new HashMap<String, ArrayList<Map>>();
        traceData.put("data", submitData);
        String backlogId = action.getExecuteContext().getBacklogId().toString();
        String targetDataState = action.getTargetDataState();
        if (targetDataState == null) {
            targetDataState = executeContext.getParentAction() != null && StringUtils.hasText((String)executeContext.getParentAction().getTargetDataState()) ? executeContext.getParentAction().getTargetDataState() : "completed";
        }
        if (submitData.size() > 0) {
            this.atmcService.setBpmActivityTraceData(backlogId, "waitting", targetDataState, traceData);
        }
        if (queryParas != null && queryParas.size() > 0) {
            List keys = dataSourceDTO.getDataKeys();
            HashSet<String> submitDataKeys = new HashSet<String>();
            for (Map map : submitData) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object key : keys) {
                    stringBuilder.append(map.get(key) + "--");
                }
                if (stringBuilder.length() > 0) {
                    submitDataKeys.add(stringBuilder.toString());
                }
                stringBuilder.setLength(0);
            }
            ArrayList<Map> needDel = new ArrayList<Map>();
            for (Map map : queryParas) {
                String queryParaKey;
                StringBuilder sb = new StringBuilder();
                for (Object key : keys) {
                    sb.append(map.get(key) + "--");
                }
                if (sb.length() > 0 && submitDataKeys.contains(queryParaKey = sb.toString())) {
                    needDel.add(map);
                }
                sb.setLength(0);
            }
            for (Object e : needDel) {
                queryParas.remove(e);
            }
            if (queryParas.size() == 0) {
                HashMap hashMap = new HashMap();
                for (Object key : keys) {
                    hashMap.put(key, "__xxxx");
                }
                queryParas.add(hashMap);
            }
        }
        return ExecuteResult.ok();
    }
}

