/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.action.util.EspParameterConverterUtils;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus.DataUniformityEvent;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus.DataUniformityEventDTO;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import com.jugg.agile.framework.core.util.reflect.bean.copy.JaBeanCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSubmissionServiceImpl
implements InitializingBean,
DataSubmissionService {
    private static final Logger log = LoggerFactory.getLogger(DataSubmissionServiceImpl.class);
    @Autowired
    List<ActionExecutor> actionExecutorList;
    @Autowired
    private CommonThemeMapQueryService commonThemeMapQueryService;
    private HashMap<String, ActionExecutor> actionExecutors = new HashMap();
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private AsyncEventBus asyncEventBus;

    @Override
    public ExecuteResult submit(ActionExecuteReq actionExecuteReq) {
        SubmitAction action = actionExecuteReq.getAction();
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        Map data = actionExecuteReq.getData();
        LogDto logDto = new LogDto("\u6267\u884ccore action\u5f00\u59cb\uff0cactionId\uff1a" + action.getActionId(), executeContext.getTenantId() + ";" + executeContext.getBacklogId());
        log.info(logDto.toString());
        ExecuteResult executeResult = this.executeCoreWapper((ActionExecuteReq)JaBeanCopy.cp((Object)actionExecuteReq, ActionExecuteReq.class));
        LogDto logDtoEnd = new LogDto("\u6267\u884ccore action\u7ed3\u675f\uff0cactionId\uff1a" + action.getActionId(), executeContext.getTenantId() + ";" + executeContext.getBacklogId());
        log.info(logDtoEnd.toString());
        if (CollectionUtils.isNotEmpty((Collection)action.getAttachActions())) {
            SubmitAction taskEngineAction = null;
            Optional<SubmitAction> optionalTaskEngineAction = action.getAttachActions().stream().filter(attachAction -> attachAction.isDispatchAction()).findFirst();
            if (optionalTaskEngineAction.isPresent()) {
                taskEngineAction = optionalTaskEngineAction.get();
            }
            List afterCheckCompletedActions = action.getAttachActions().stream().filter(attachAction -> Boolean.TRUE.equals(attachAction.getExecuteAfterCheckCompleted())).collect(Collectors.toList());
            for (SubmitAction attachAction2 : action.getAttachActions()) {
                if (attachAction2.isDispatchAction() || Boolean.TRUE.equals(attachAction2.getExecuteAfterCheckCompleted())) continue;
                executeContext.setParentAction(action);
                LogDto logDtoAttach = new LogDto("\u6267\u884cattach action\u5f00\u59cb\uff0cbacklogId\uff1a" + executeContext.getBacklogId(), executeContext.getTenantId() + ";" + executeContext.getBacklogId());
                log.info(logDtoAttach.toString());
                this.executeAttachAction(new ActionExecuteReq(executeContext, action, executeResult, attachAction2, data, actionExecuteReq.getWorkItemIdToData()));
                LogDto logDtoAttachEnd = new LogDto("\u6267\u884cattach action\u7ed3\u675f\uff0cbacklogId\uff1a" + executeContext.getBacklogId(), executeContext.getTenantId() + ";" + executeContext.getBacklogId());
                log.info(logDtoAttachEnd.toString());
            }
            if (taskEngineAction != null) {
                this.setIsCompleted(executeContext, action, executeResult);
                if (executeResult.isCompleted()) {
                    if (CollectionUtils.isNotEmpty(afterCheckCompletedActions)) {
                        for (SubmitAction attachAction2 : afterCheckCompletedActions) {
                            executeContext.setParentAction(action);
                            this.executeAttachAction(new ActionExecuteReq(executeContext, action, executeResult, attachAction2, data, actionExecuteReq.getWorkItemIdToData()));
                        }
                    }
                    this.executeAttachAction(new ActionExecuteReq(executeContext, action, executeResult, taskEngineAction, data, actionExecuteReq.getWorkItemIdToData()));
                }
            }
        } else if (action.isDispatchAction()) {
            this.setIsCompleted(executeContext, action, executeResult);
        }
        try {
            if (!(action.isExecuteEventPost() || null != executeContext.getTaskType() && executeContext.getTaskType() == 89)) {
                Map workItemIdToData = actionExecuteReq.getWorkItemIdToData();
                if (MapUtils.isNotEmpty((Map)workItemIdToData)) {
                    workItemIdToData.forEach((k, v) -> this.postDataUniformityEvent((Long)k, (Map<String, Object>)v, executeContext.getTmActivityId(), executeContext.getOperateAuthoredUser()));
                } else {
                    this.postDataUniformityEvent(executeContext.getBacklogId(), executeResult.getRequestData(), executeContext.getTmActivityId(), executeContext.getOperateAuthoredUser());
                }
            }
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u6570\u636e\u6bd4\u5bf9\u4ee5\u53ca\u5220\u9664\u4fa6\u6d4bEventBus\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return executeResult;
    }

    private void postDataUniformityEvent(Long backlogId, Map<String, Object> requestData, String tmActivityId, AuthoredUser operateAuthoredUser) {
        DataUniformityEventDTO dataUniformityEventDTO = new DataUniformityEventDTO();
        dataUniformityEventDTO.setBacklogId(backlogId);
        dataUniformityEventDTO.setRequestData(requestData);
        dataUniformityEventDTO.setTmActivityId(tmActivityId);
        DataUniformityEvent dataUniformityEvent = new DataUniformityEvent(dataUniformityEventDTO, operateAuthoredUser);
        this.asyncEventBus.post((Object)dataUniformityEvent);
    }

    private void setIsCompleted(SubmitExecuteContext executeContext, SubmitAction action, ExecuteResult executeResult) {
        if (action.getCheckCompleteAction() == null) {
            executeResult.setCompleted(true);
        } else {
            DataSourceBase dataSourceBase = DataSourceConverter.convert((DataSourceDTO)action.getCheckCompleteAction(), (boolean)false);
            QueryResult queryResult = dataSourceBase.query(ExecuteContext.fromSubmitExecuteContent((SubmitExecuteContext)executeContext), null, null, null, null);
            executeResult.setCompleted(queryResult.size() == 0);
        }
    }

    @Override
    public boolean isSupportSubmitMergeData(SubmitAction action) {
        String actionKey = this.getActionKey(action);
        if (this.actionExecutors.containsKey(actionKey)) {
            return this.actionExecutors.get(actionKey).supportDataMerge();
        }
        throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0024.getErrCode(), (String)(this.messageUtils.getMessage("exception.can.not.deal.action") + actionKey));
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        ExecuteResult executeResult = this.executeCoreWapper(executeContext, null, action, data);
        if (CollectionUtils.isNotEmpty((Collection)action.getAttachActions())) {
            SubmitAction bpmAction = null;
            Optional<SubmitAction> optionalAction = action.getAttachActions().stream().filter(attachAction -> attachAction.isDispatchAction()).findFirst();
            if (optionalAction.isPresent()) {
                bpmAction = optionalAction.get();
            }
            for (SubmitAction attachAction2 : action.getAttachActions()) {
                if (attachAction2.isDispatchAction()) continue;
                this.executeAttachAction(executeContext, action, executeResult, attachAction2, data);
            }
            executeResult.setCompleted(true);
            if (executeResult.isCompleted() && bpmAction != null) {
                this.executeAttachAction(executeContext, action, executeResult, bpmAction, data);
            }
        } else {
            executeResult.setCompleted(true);
        }
        return executeResult;
    }

    private ExecuteResult executeCore(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        return this.executeCore(new ActionExecuteReq(executeContext, parentExecuteResult, action, data));
    }

    private Map<String, Object> convertedParam(SubmitExecuteContext executeContext, SubmitAction action, ApiMetadata apiMetadata, Map<String, Object> data, Map<String, Object> paras) {
        Map<String, Object> comData;
        Map<String, Object> convertedData = data;
        if (action.getActionParams() != null) {
            Map<String, Object> dataMap;
            convertedData = EspParameterConverterUtils.convert(data, action.getActionParams(), action);
            if (apiMetadata != null && (dataMap = this.convertDataToMapByActionMetadata(executeContext, action, convertedData)) != null) {
                convertedData = dataMap;
            }
        }
        this.handlingSpecialTypes(executeContext, action, convertedData);
        if (MapUtils.isNotEmpty(paras) && MapUtils.isNotEmpty((Map)(comData = EspParameterConverterUtils.combine(convertedData, paras)))) {
            convertedData = comData;
        }
        return convertedData;
    }

    private ExecuteResult executeCore(ActionExecuteReq actionExecuteReq) {
        SubmitAction action = actionExecuteReq.getAction();
        Map data = actionExecuteReq.getData();
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        String actionKey = this.getActionKey(action);
        if (!this.actionExecutors.containsKey(actionKey)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0023.getErrCode(), (String)(this.messageUtils.getMessage("exception.can.not.deal.action") + actionKey));
        }
        ApiMetadata apiMetadata = null;
        if (action.getActionParams() != null && this.actionExecutors.get(actionKey).hasActionMetadata()) {
            try {
                apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), action.getActionId());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        Map<String, Object> convertedData = this.convertedParam(executeContext, action, apiMetadata, data, action.getParas());
        if (action.isExecuteAction()) {
            ExecuteResult ok = ExecuteResult.ok();
            ok.setRequestData(convertedData);
            return ok;
        }
        Map workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        if (workItemIdToData != null) {
            LinkedHashMap convertDataMap = Maps.newLinkedHashMapWithExpectedSize((int)workItemIdToData.size());
            Map workItemToBpmParas = action.getWorkItemToBpmParas();
            for (Map.Entry entry : workItemIdToData.entrySet()) {
                Map paras = action.getParas();
                if (workItemToBpmParas != null) {
                    paras = (Map)workItemToBpmParas.get(entry.getKey());
                }
                Map<String, Object> map = this.convertedParam(executeContext, action, apiMetadata, (Map)entry.getValue(), paras);
                convertDataMap.put(entry.getKey(), map);
            }
            actionExecuteReq.setWorkItemIdToData((Map)convertDataMap);
        }
        LogDto logDto = new LogDto("\u6267\u884cExecutor\uff1a" + actionKey + "\u5f00\u59cb\uff0cbacklogId\uff1a" + executeContext.getBacklogId(), executeContext.getTenantId() + ";" + executeContext.getBacklogId());
        log.info(logDto.toString());
        ActionExecutor actionExecutor = this.actionExecutors.get(actionKey);
        action.setSupportRetry(Boolean.valueOf(actionExecutor.supportRetry()));
        actionExecuteReq.setData(convertedData);
        ExecuteResult executeResult = actionExecutor.execute(actionExecuteReq);
        LogDto logDtoEnd = new LogDto("\u6267\u884cExecutor\uff1a" + actionKey + "\u7ed3\u675f\uff0cbacklogId\uff1a" + executeContext.getBacklogId(), executeContext.getTenantId() + ";" + executeContext.getBacklogId());
        log.info(logDtoEnd.toString());
        if (executeResult == null) {
            executeResult = ExecuteResult.ok();
        }
        if (MapUtils.isNotEmpty((Map)executeResult.getData())) {
            DataSubmissionServiceImpl.convertDataBindUuid(executeResult.getData(), data);
        }
        executeResult.setRequestData(convertedData);
        return executeResult;
    }

    private void handlingSpecialTypes(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> convertedData) {
        if (CollectionUtils.isNotEmpty((Collection)action.getActionParams())) {
            for (ActionParameterMapping actionParam : action.getActionParams()) {
                if (!"TM_VARIABLE".equals(actionParam.getType())) continue;
                Object value = this.commonThemeMapQueryService.queryVariable(actionParam.getValue(), executeContext);
                convertedData.put(actionParam.getName(), value);
            }
        }
    }

    private String getActionKey(SubmitAction action) {
        String actionKey = action.getCategory() + ":";
        switch (action.getCategory()) {
            case "RECYCLE": 
            case "TERMINATE_DATA": 
            case "WITHDRAW_DATA": 
            case "UIBOT": {
                actionKey = actionKey + action.getActionId();
                break;
            }
            case "TaskEngine": 
            case "PTM": {
                actionKey = actionKey + action.getServiceId().getName();
                break;
            }
            case "MANUAL_TASK": {
                break;
            }
        }
        return actionKey;
    }

    private void executeAttachAction(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        ExecuteResult parentExecuteResult = actionExecuteReq.getParentExecuteResult();
        Map parentConvertedData = parentExecuteResult.getRequestData();
        Map parentResponseData = parentExecuteResult.getData();
        SubmitAction attachAction = actionExecuteReq.getAction();
        SubmitAction parentAction = actionExecuteReq.getParentAction();
        attachAction.setBusinessUnit(parentAction.getBusinessUnit());
        Map submitData = actionExecuteReq.getData();
        if (null != parentAction.getServiceId()) {
            attachAction.getServiceId().setProxyToken(parentAction.getServiceId().getProxyToken());
        }
        String dataFrom = "";
        if (attachAction.getExtendParas() != null && attachAction.getExtendParas().containsKey("dataSource")) {
            dataFrom = attachAction.getExtendParas().get("dataSource").toString();
        }
        Map convertedData = null;
        switch (dataFrom) {
            case "parent": 
            case "parentRequest": {
                convertedData = parentConvertedData;
                break;
            }
            case "submit": {
                convertedData = submitData;
                break;
            }
            case "parentAndParentResponse": {
                convertedData = parentConvertedData;
                if (parentResponseData == null) break;
                for (Map.Entry stringListEntry : parentResponseData.entrySet()) {
                    convertedData.put(stringListEntry.getKey(), stringListEntry.getValue());
                }
                break;
            }
            case "submitWithParentResponse": 
            case "parentResponse": {
                convertedData = submitData;
                if (parentResponseData == null) break;
                for (Map.Entry stringListEntry : parentResponseData.entrySet()) {
                    convertedData.put(stringListEntry.getKey(), stringListEntry.getValue());
                }
                break;
            }
            default: {
                convertedData = submitData;
            }
        }
        executeContext.setParentAction(parentAction);
        ExecuteResult attachActionExecuteResult = this.executeCoreWapper(new ActionExecuteReq(executeContext, parentExecuteResult, attachAction, convertedData, actionExecuteReq.getWorkItemIdToData()));
        if (CollectionUtils.isNotEmpty((Collection)attachAction.getAttachActions())) {
            for (SubmitAction attachAttachAction : attachAction.getAttachActions()) {
                if ("WF".equals(attachAction.getCategory()) || "TaskEngine".equals(attachAction.getCategory())) continue;
                this.executeAttachAction(new ActionExecuteReq(executeContext, attachAction, attachActionExecuteResult, attachAttachAction, submitData, actionExecuteReq.getWorkItemIdToData()));
            }
        }
    }

    private void executeAttachAction(SubmitExecuteContext executeContext, SubmitAction parentAction, ExecuteResult parentExecuteResult, SubmitAction attachAction, Map<String, Object> submitData) {
        Map<String, Object> parentConvertedData = parentExecuteResult.getRequestData();
        Map parentResponseData = parentExecuteResult.getData();
        attachAction.setBusinessUnit(parentAction.getBusinessUnit());
        if (null != parentAction.getServiceId()) {
            attachAction.getServiceId().setProxyToken(parentAction.getServiceId().getProxyToken());
        }
        String dataFrom = "";
        if (attachAction.getExtendParas() != null && attachAction.getExtendParas().containsKey("dataSource")) {
            dataFrom = attachAction.getExtendParas().get("dataSource").toString();
        }
        Map<String, Object> convertedData = null;
        switch (dataFrom) {
            case "parent": 
            case "parentRequest": {
                convertedData = parentConvertedData;
                break;
            }
            case "submit": {
                convertedData = submitData;
                break;
            }
            case "parentAndParentResponse": {
                convertedData = parentConvertedData;
                if (parentResponseData == null) break;
                for (Map.Entry stringListEntry : parentResponseData.entrySet()) {
                    convertedData.put((String)stringListEntry.getKey(), stringListEntry.getValue());
                }
                break;
            }
            case "submitWithParentResponse": 
            case "parentResponse": {
                convertedData = submitData;
                if (parentResponseData == null) break;
                for (Map.Entry stringListEntry : parentResponseData.entrySet()) {
                    convertedData.put((String)stringListEntry.getKey(), stringListEntry.getValue());
                }
                break;
            }
            default: {
                convertedData = submitData;
            }
        }
        executeContext.setParentAction(parentAction);
        ExecuteResult attachActionExecuteResult = this.executeCoreWapper(executeContext, parentExecuteResult, attachAction, convertedData);
        if (CollectionUtils.isNotEmpty((Collection)attachAction.getAttachActions())) {
            for (SubmitAction attachAttachAction : attachAction.getAttachActions()) {
                if ("WF".equals(attachAction.getCategory()) || "TaskEngine".equals(attachAction.getCategory())) continue;
                this.executeAttachAction(executeContext, attachAction, attachActionExecuteResult, attachAttachAction, submitData);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.actionExecutors != null) {
            for (ActionExecutor actionExecutor : this.actionExecutorList) {
                this.actionExecutors.put(actionExecutor.supportKey(), actionExecutor);
            }
        }
    }

    private Map<String, Object> convertDataToMapByActionMetadata(ApiMetadata apiMetadata, SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        HashMap<String, Map> dataMap = null;
        try {
            if (apiMetadata == null) {
                return null;
            }
            ArrayList<MetadataField> requestFields = new ArrayList();
            if (apiMetadata.getRequestFields() != null) {
                requestFields = apiMetadata.getRequestFields();
            }
            if (StringUtils.isNotEmpty((String)apiMetadata.getInvokeType()) && StringUtils.isEmpty((String)action.getInvokeType())) {
                action.setInvokeType(apiMetadata.getInvokeType());
            }
            if (data == null || data.size() == 0) {
                return null;
            }
            List<String> typeList = Arrays.asList("ACTIVE_ROW", "GET_ACTION_RESPONSE");
            if (CollectionUtils.isNotEmpty((Collection)action.getActionParams())) {
                List actionParaNames = action.getActionParams().stream().filter(para -> typeList.contains(para.getType())).map(item -> item.getName()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(actionParaNames) || actionParaNames.size() == 0) {
                    return null;
                }
                String conNames = (String)actionParaNames.get(0);
                if (((String)actionParaNames.get(0)).contains(".")) {
                    conNames = ((String)actionParaNames.get(0)).split("\\.")[0];
                }
                if (!this.requestIsArray(requestFields, conNames)) {
                    HashMap<String, Map> dataNew = new HashMap<String, Map>();
                    for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
                        List dataList = JsonUtils.jsonToListObject((String)JsonUtils.objectToString((Object)dataEntry.getValue()), Map.class);
                        if (!(dataList instanceof List) || dataList.size() <= 0) continue;
                        Map dataMapOne = (Map)JsonUtils.jsonToListObject((String)JsonUtils.objectToString((Object)dataEntry.getValue()), Map.class).get(0);
                        dataNew.put(dataEntry.getKey(), dataMapOne);
                    }
                    if (MapUtils.isNotEmpty(dataNew)) {
                        dataMap = dataNew;
                    }
                } else {
                    HashMap dataNew = new HashMap();
                    for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
                        if (!(dataEntry.getValue() instanceof Map)) continue;
                        ArrayList<Object> o = new ArrayList<Object>();
                        o.add(dataEntry.getValue());
                        dataNew.put(dataEntry.getKey(), o);
                    }
                    if (MapUtils.isNotEmpty(dataNew)) {
                        dataMap = dataNew;
                    }
                }
            }
            return dataMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, Object> convertDataToMapByActionMetadata(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        try {
            ApiMetadata apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), action.getActionId());
            return this.convertDataToMapByActionMetadata(apiMetadata, executeContext, action, data);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean requestIsArray(List<MetadataField> requestFields, String conNames) {
        if (CollectionUtils.isNotEmpty(requestFields)) {
            for (MetadataField metadataField : requestFields) {
                if (!conNames.equals(metadataField.getName()) || !"object".equals(metadataField.getDataType())) continue;
                return BooleanUtils.isTrue((Boolean)metadataField.getArray());
            }
        }
        return true;
    }

    private static void convertDataBindUuid(Map<String, Object> convertedData, Map<String, Object> data) {
        if (MapUtils.isEmpty(convertedData)) {
            return;
        }
        if (MapUtils.isEmpty(data)) {
            return;
        }
        try {
            ArrayList uuidList = new ArrayList();
            for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
                Object dataObj = dataEntry.getValue();
                if (!(dataObj instanceof List)) continue;
                List dataList = (List)dataObj;
                for (Object rowData : dataList) {
                    Map rowDataMap = (Map)rowData;
                    if (!rowDataMap.containsKey("uuid")) continue;
                    uuidList.add(rowDataMap.get("uuid"));
                }
            }
            if (CollectionUtils.isEmpty(uuidList)) {
                return;
            }
            for (Map.Entry<String, Object> dataEntry : convertedData.entrySet()) {
                Object convertedDataObj = dataEntry.getValue();
                if (!(convertedDataObj instanceof List)) continue;
                List convertedDataObjList = (List)convertedDataObj;
                if (convertedDataObjList.size() != uuidList.size()) {
                    return;
                }
                int uuid = 0;
                for (Object rowData : convertedDataObjList) {
                    Map rowDataMap = (Map)rowData;
                    if (!rowDataMap.containsKey("uuid")) {
                        rowDataMap.put("uuid", uuidList.get(uuid));
                    }
                    ++uuid;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteResult executeCoreWapper(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        ExecuteResult executeResult = null;
        try {
            if (Boolean.TRUE.equals(executeContext.getIsRetry()) && Objects.nonNull(action.getExecuteResult()) && Boolean.TRUE.equals(action.getExecuteResult().getExecuteState())) {
                ExecuteResult executeResult2 = action.getExecuteResult();
                return executeResult2;
            }
            executeResult = this.executeCore(executeContext, parentExecuteResult, action, data);
            action.setExecuteResult(executeResult);
            ExecuteResult executeResult3 = executeResult;
            return executeResult3;
        }
        finally {
            action.setExecuted(Boolean.valueOf(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteResult executeCoreWapper(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        SubmitAction action = actionExecuteReq.getAction();
        ExecuteResult executeResult = null;
        try {
            if (Boolean.TRUE.equals(executeContext.getIsRetry()) && Objects.nonNull(action.getExecuteResult()) && Boolean.TRUE.equals(action.getExecuteResult().getExecuteState())) {
                ExecuteResult executeResult2 = action.getExecuteResult();
                return executeResult2;
            }
            executeResult = this.executeCore(actionExecuteReq);
            action.setExecuteResult(executeResult);
            ExecuteResult executeResult3 = executeResult;
            return executeResult3;
        }
        finally {
            action.setExecuted(Boolean.valueOf(true));
        }
    }
}

