package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import com.digiwin.athena.atdm.activity.domain.TmAction;
import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.activity.domain.TmDataState;
import com.digiwin.athena.atdm.activity.service.BaseActionCreateService;
import com.digiwin.athena.atdm.activity.service.BpmServiceInvokeType;
import com.digiwin.athena.atdm.activity.service.BaseBpmTaskParser;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Order(120)
@Service(ActionConstants.ACTION_NAME_ABORT_TASK_NAME)
public class AbortTaskExecutor implements ActionExecutor {

    @Autowired
    @Qualifier("BpmActionExecutor")
    ActionExecutor bpmDispatchAction;

    @Autowired
    @Qualifier("update-table-field")
    ActionExecutor updateTableFieldAction;

    @Autowired
    CommonThemeMapQueryService commonThemeMapQueryService;

    @Autowired
    BaseActionCreateService submitBaseActionCreateService;

    @Autowired
    CommonAtmcService atmcService;

    @Autowired()
    @Qualifier("baseBpmUserTaskParser")
    private BaseBpmTaskParser bpmUserTaskParser;

    @Autowired
    @Qualifier("taskEngineTerminateProcessActionExecutor")
    ActionExecutor taskEngineTerminateProcessActionExecutor;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT +ActionConstants.SPLIT+ ActionConstants.ACTION_NAME_ABORT_TASK_NAME ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {

        //通知Atmc
        notifyAtmcAbortTask(action);

        //执行敏态API
        executeUpdateFields(executeContext,parentExecuteResult, action, data);

        //执行BPM终止流程
        executeAbortTaskAction(executeContext, parentExecuteResult,action, data);

        return  ExecuteResult.ok();
    }

    /**
     * 执行BPM终止流程
     * @param action
     * @param data
     */
    private void executeAbortTaskAction(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data){
        Map<String,Object> processParameter = (Map<String,Object>)action.getExtendParas().get("processParameter");
        if(isFlowEngine(processParameter)) {
            SubmitAction bpmAction = new SubmitAction();
            bpmAction.setTitle(action.getTitle());
            bpmAction.setActionId(action.getActionId());
            bpmAction.setCategory(UiBotConstants.ACTION_CATEGORY_BPM);
            bpmAction.setServiceId(action.getServiceId());
            bpmAction.getServiceId().setServiceUri(bpmUserTaskParser.getRelativeUrl(BpmServiceInvokeType.TerminateProcess));
            bpmAction.setParas((Map<String, Object>) action.getExtendParas().get("processParameter"));
            bpmAction.setExecuteContext(action.getExecuteContext());

            bpmDispatchAction.execute(executeContext, parentExecuteResult,bpmAction, data);
        }else{

            SubmitAction bpmAction = new SubmitAction();
            bpmAction.setTitle(action.getTitle());
            bpmAction.setActionId(action.getActionId());
            bpmAction.setCategory(UiBotConstants.ACTION_CATEGORY_TASK_ENGINE);
            bpmAction.setServiceId(action.getServiceId());
            bpmAction.getServiceId().setServiceUri("api/project/terminate");
            bpmAction.setParas(processParameter);
            bpmAction.setExecuteContext(action.getExecuteContext());

            taskEngineTerminateProcessActionExecutor.execute(executeContext,parentExecuteResult, bpmAction, data);
        }
    }

    /**
     * 更新敏态数据
     * @param action
     * @param data
     */
    private void executeUpdateFields(SubmitExecuteContext submitExecuteContext,ExecuteResult parentExecuteResult,SubmitAction action, Map<String, Object> data){

        String detailField = null;
        if(action.getExtendParas().containsKey("detailField") && action.getExtendParas().get("detailField")!=null){
            detailField = action.getExtendParas().get("detailField").toString();
        }
        ExecuteContext executeContext = ExecuteContext.builder()
                .tmProjectId(action.getExecuteContext().getTmProjectId())
                .tmActivityId(action.getExecuteContext().getTmActivityId())
                .authoredUser(submitExecuteContext.getAuthoredUser())
                .proxyToken(submitExecuteContext.getProxyToken())
                .pageCode(action.getExecuteContext().getPageCode())
                .build();
        TmActivity tmActivity = commonThemeMapQueryService.getActivityAction(executeContext);

        TmAction tmAction = tmActivity.getPages().getAbortTaskAction();
        if(tmAction == null){
            if(CollectionUtils.isNotEmpty(tmActivity.getPages().getDataStates())){
                for (TmDataState dataState : tmActivity.getPages().getDataStates()) {
                    if(dataState!=null && dataState.getAbortTaskAction()!=null){
                        tmAction = dataState.getAbortTaskAction();
                        break;
                    }
                }
            }
        }

        if(tmAction == null){
            return;
        }

        String[] keys = tmAction.getExtendParas().get("dataKeys").toString().split(";");
        List<Map<String,Object>> submitDatas = (List<Map<String,Object>>)data.get(tmAction.getExtendParas().get("submitVariableName").toString());
        List<Map<String,Object>> allDataKeys = (List<Map<String,Object>>)action.getExtendParas().get("allKey");
        for(int i = submitDatas.size() - 1; i >= 0; i--){
            Map<String,Object> sd = submitDatas.get(i);
            if(detailField!=null && sd.containsKey(detailField) && CollectionUtils.isNotEmpty((List)sd.get(detailField))){
                //拆行
                List<Map<String,Object>> subDatas = (List<Map<String,Object>>)sd.get(detailField);
                for(int j = subDatas.size() -1; j>=0; j--){
                    Map<String,Object> subData = subDatas.get(j);
                    boolean hasFound = findData(allDataKeys, keys, subData);
                    if(!hasFound){
                        subDatas.remove(j);
                    }
                }
                if(subDatas.size()==0){
                    //如果拆行数据都不符合，去掉该母行
                    submitDatas.remove(i);
                }
            }else {
                //没有拆行
                boolean hasFound = findData(allDataKeys, keys, sd);
                if (!hasFound) {
                    submitDatas.remove(i);
                }
            }
        }

        SubmitAction submitAction = submitBaseActionCreateService.createSubmitAction(tmAction, action.getExecuteContext().getTenantId(), action.getBusinessUnit());
        submitAction.setExecuteContext(action.getExecuteContext());
        updateTableFieldAction.execute(submitExecuteContext,parentExecuteResult, submitAction, data);
    }

    private boolean findData(List<Map<String,Object>> allDataKeys, String[] keys, Map<String,Object> sd){

        //没有拆行
        boolean hasFound = true;
        for (Map<String, Object> dk : allDataKeys) {
            hasFound = true;
            for (String key : keys) {
                if (!Objects.equals(sd.get(key), dk.get(key))) {
                    hasFound = false;
                    break;
                }
            }
            if (hasFound) {
                break;
            }
        }

        return hasFound;
    }

    private void notifyAtmcAbortTask(SubmitAction action){
        Long originalBacklogId = action.getExecuteContext().getBacklogId();

        Map<String,Object> paras = (Map<String,Object>)action.getExtendParas().get("processParameter");
        if(isFlowEngine(paras)) {
            //不含 processSerialNumber 的，是PTM
            String processSerialNumber = paras.get("processSerialNumber").toString();
            String workitemId = paras.get("workitemId").toString();
            atmcService.abortTask(originalBacklogId, processSerialNumber, workitemId);
        }
    }

    private boolean isFlowEngine(Map<String,Object> processParameter){
        //processSerialNumber 是流程引擎
        // serialNumber 是任务引擎
        return processParameter.containsKey("processSerialNumber");
    }
}
