package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.fi.CommonForecastingIntelligenceService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Order(40)
@Service("commit-data-to-fi")
public class CommitDataToFiActionExecutor implements ActionExecutor {

    @Autowired
    private CommonForecastingIntelligenceService commonForecastingIntelligenceService;

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"commit-data-to-fi";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if (action==null || parameter==null){
            return ExecuteResult.ok();
        }

        Map data = parameter;

        Map user = new HashMap();
        user.put("userId", executeContext.getAuthoredUser().getUserId());
        user.put("userName", executeContext.getAuthoredUser().getUserName());
        user.put("tenantId", executeContext.getAuthoredUser().getTenantId());
        user.put("tenantName", executeContext.getAuthoredUser().getTenantName());

        Map task = new HashMap();
        task.put("identity", "");
        task.put("projectId", 0L);
        task.put("backlogId", executeContext.getBacklogId());
        task.put("startTime", "");
        task.put("planEndTime", "");
        task.put("backlogName", "");
        task.put("performerId", "");
        task.put("performerName", "");
        task.put("projectName", "");
        task.put("tmProjectId", executeContext.getTmProjectId());
        task.put("tmActivityId", executeContext.getTmActivityId());
        task.put("activityType", "");
        task.put("pattern", executeContext.getPattern());
        task.put("category", executeContext.getCategory());

        Map context = new HashMap();
        context.put("locale", executeContext.getLocale());
        context.put("clientAgent", executeContext.getClientAgent());
        context.put("businessUnit", executeContext.getBusinessUnit());

        Map result = commonForecastingIntelligenceService.taskSubmit(data, user, task, context);

        ExecuteResult executeResult = ExecuteResult.ok();
        return executeResult;
    }

}
