package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Order(40)
@Service("data-reassignment")
class DataReassignmentActionExecutor extends MergeDataActionExecutor implements ActionExecutor {

    @Autowired
    @Qualifier("BpmActionExecutor")
    ActionExecutor bpmDispatchAction;

//    @Autowired
//    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private CommonSmartDataService commonSmartDataService;

    @Autowired
    private TokenVerifyService tokenVerifyService;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT +"data-reassignment-action";
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    protected ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext,SubmitAction action, Map<String, Object> parameter) {

        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();
        String actionId = submitParameter.getActionId();
        HashMap paras = submitParameter.getParas();
        String tenantId = submitParameter.getTenantId();
        Map extendedFields = new HashMap();
        if(!StringUtils.isEmpty(executeContext.getTraceId())){
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        // 拿到应用 code，透传给 sd 的执行引擎，执行引擎再透传给 esp，esp 给到业务中台用作运营统计分析
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, action.getBusinessUnit(), extendedFields);

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    @Override
    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {

        SubmitParameter submitParameter = new SubmitParameter(executeContext, action, parameter).invoke();

        //如果是合并，合并任务的临时处理，把数据放到临时变量，后面再统一提交
        mockSubmitData(action, submitParameter);

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private void mockSubmitData(SubmitAction action, SubmitParameter submitParameter ) {


        //放到每行数据中
        for (Object key : submitParameter.paras.keySet()) {
            if(!Objects.equals(key, submitParameter.newProcessVariableName)){
                for (Map<String, Object> submitPara : submitParameter.submitParas) {
                    submitPara.put(key.toString(), submitParameter.paras.get(key));
                }
            }
        }


        if (action!= action.getMergeDataAction()) {
            //把所有数据合并到指定的action上
            Map<String, Object> mergedData = (Map<String, Object>) action.getMergeDataAction().getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
            Map mergedParas = (Map) mergedData.get("paras");
            List<Map>  mergedSubmitParas = (List<Map>) mergedParas.get(submitParameter.newProcessVariableName);
            mergedSubmitParas.addAll((List<Map>) submitParameter.paras.get(submitParameter.newProcessVariableName));
        }else {
            //region模拟执行,将参数放到 extendParas 中。
            Map<String,Object> extendParas = action.getExtendParas();

            Map<String,Object> startNewProcessMap = new HashMap<>();
            startNewProcessMap.put("tenantId", submitParameter.tenantId);
            startNewProcessMap.put("actionId", submitParameter.actionId);
            startNewProcessMap.put("paras", submitParameter.paras);

            startNewProcessMap.put("eoc", action.getBusinessUnit());
            extendParas.put(UiBotConstants.MERGED_SUBMIT_DATA, startNewProcessMap);
        }

    }


    @Override
    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {

        //合并的任务，直接用准备好的参数执行
        Map<String, Object> startNewProcessMap = (Map<String, Object>) action.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
        String tenantId = startNewProcessMap.get("tenantId").toString();
        String actionId = startNewProcessMap.get("actionId").toString();
        Map paras = (Map) startNewProcessMap.get("paras");
        Map eoc = (Map) startNewProcessMap.get("eoc");
        Map extendedFields = new HashMap();
        if(!StringUtils.isEmpty(executeContext.getTraceId())){
            extendedFields.put("traceId", executeContext.getTraceId());
        }
        // 拿到应用 code，透传给 sd 的执行引擎，执行引擎再透传给 esp，esp 给到业务中台用作运营统计分析
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        commonSmartDataService.executeWithParas(tenantId, actionId, new Map[]{paras}, eoc, extendedFields);

        ExecuteResult executeResult = ExecuteResult.ok();
        executeResult.setAsync(true);
        return executeResult;
    }

    private List<SubmitParameter> invokeMinSplit(ActionExecuteReq actionExecuteReq){
        SubmitAction submitAction = actionExecuteReq.getAction();
        if(submitAction == null){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0011.getErrCode(), messageUtils.getMessage("exception.data.reassignment.action.error"));
        }
        Map<String, Object> extendParas = submitAction.getExtendParas();
        if(MapUtils.isEmpty(extendParas)){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0011.getErrCode(), messageUtils.getMessage("exception.data.reassignment.action.error"));
        }
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(submitExecuteContext == null){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0011.getErrCode(), messageUtils.getMessage("exception.data.reassignment.action.error"));
        }
//        if (action == null || parameter == null
//                || executeContext == null
//                || executeContext.getBacklogId() == null
//                || executeContext.getBpmData() == null
//                || action.getParas() == null
//                || action.getParas().size() == 0
//                || action.getExtendParas() == null
//                || action.getExtendParas().size() == 0) {
//            throw BusinessException.create(ErrorCodeEnum.NUM_500_0011.getErrCode(), messageUtils.getMessage("exception.data.reassignment.action.error"));
//        }
        Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
        Map<Long, Map<String, Object>> workItemToBpmParas = submitAction.getWorkItemToBpmParas();
        Map<Long, Map<String, Object>> workItemIdToBpmData = submitExecuteContext.getWorkItemIdToBpmData();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String tenantId = authoredUser.getTenantId();
        if(StringUtils.isEmpty(tenantId) && !StringUtils.isEmpty(AppAuthContextHolder.getContext().getProxyToken())){
            authoredUser = tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
            tenantId = authoredUser.getTenantId();
        }
        List<SubmitParameter> list = Lists.newArrayListWithExpectedSize(workItemIdToData.size());
        for (Map.Entry<Long, Map<String, Object>> entry:workItemIdToData.entrySet()){
            Long workItemId = entry.getKey();
            Map<String, Object> paras = workItemToBpmParas.get(workItemId);
            Map<String, Object> bpmData = workItemIdToBpmData.get(workItemId);
            Map<String, Object> parameter = entry.getValue();
            if(MapUtils.isEmpty(paras) || bpmData == null){
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0011.getErrCode(), messageUtils.getMessage("exception.data.reassignment.action.error"));
            }
            String actionId = null;
            if (bpmData.containsKey("actionId")) {
                actionId = bpmData.get("actionId").toString();
            }
            String newProcessVariableName = "";
            String submitVariableName = "";
            List<Map<String, Object>> submitParas = null;
            String newProcessFields = null;
            for (Map.Entry<String, Object> stringObjectEntry : extendParas.entrySet()) {
                switch (stringObjectEntry.getKey()) {
                    case "actionId":
                        actionId = stringObjectEntry.getValue().toString();
                        break;
                    case "newProcessVariableName":
                        newProcessVariableName = stringObjectEntry.getValue().toString();
                        break;
                    case "submitVariableName":
                        submitVariableName = stringObjectEntry.getValue().toString();
                        if (parameter.containsKey(submitVariableName)) {
                            submitParas = (List<Map<String, Object>>) parameter.get(submitVariableName);
                        } else {
                            throw BusinessException.create(ErrorCodeEnum.NUM_500_0012.getErrCode(), String.format(messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                        }
                        break;
                    case "newProcessFields":
                        newProcessFields = stringObjectEntry.getValue().toString();
                        break;
                }
            }
            if (StringUtils.isEmpty(actionId)) {
                throw new IllegalArgumentException("actionId is empty");
            }
            if (StringUtils.isEmpty(newProcessVariableName)) {
                throw new IllegalArgumentException("newProcessVariableName is empty");
            }
            if (newProcessFields == null || "".equals(newProcessFields)) {
                throw new IllegalArgumentException("newProcessFields is empty");
            }
            String[] newProcessFieldList = newProcessFields.split(";");

            HashMap<String,Object> newParas = Maps.newHashMap();
            for (String key : newProcessFieldList) {
                if (parameter.containsKey(key)) {
                    if (key.equals(submitVariableName)){
                        newParas.put(newProcessVariableName, submitParas);

                    }else {
                        newParas.put(newProcessVariableName, parameter.get(key));
                    }
                } else {
                    newParas.put(key, bpmData.get(key));
                }
            }
            newParas.put("backlogId", workItemId);
            //paras.put("originalQueryVariableName", processVariableName);
            //paras.put("originalProcessSerialNumber", action.getExecuteContext().getProcessSerialNumber());
            //paras.put("dataKeys", compareFields);
            newParas.putAll(paras);
            newParas.put("activityId",submitExecuteContext.getTmActivityId());
            newParas.put("performerId", submitExecuteContext.getAuthoredUser().getUserId());
            list.add(new SubmitParameter(actionId,newParas,tenantId));
        }
        return list;
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitExecuteContext submitExecuteContext = actionExecuteReq.getSubmitExecuteContext();
        if(submitExecuteContext.isMinSplit() && actionExecuteReq.getWorkItemIdToData() != null){
            List<SubmitParameter> list = invokeMinSplit(actionExecuteReq);
            SubmitAction action = actionExecuteReq.getAction();
            for (SubmitParameter submitParameter : list) {
                Map<String,Object> extendedFields = new HashMap<>();
                if(!StringUtils.isEmpty(submitExecuteContext.getTraceId())){
                    extendedFields.put("traceId", submitExecuteContext.getTraceId());
                }
                // 拿到应用 code，透传给 sd 的执行引擎，执行引擎再透传给 esp，esp 给到业务中台用作运营统计分析
                extendedFields.put("application", submitExecuteContext.getApplication());
                extendedFields.put("pageCode", submitExecuteContext.getPageCode());
                extendedFields.put("tmActivityId", submitExecuteContext.getTmActivityId());
                commonSmartDataService.executeWithParas(submitParameter.getTenantId(), submitParameter.getActionId(), new Map[]{submitParameter.getParas()}, action.getBusinessUnit(), extendedFields);
            }
            ExecuteResult executeResult = ExecuteResult.ok();
            executeResult.setAsync(true);
            return executeResult;
        }
        return super.execute(actionExecuteReq);
    }


    private class SubmitParameter {
        private SubmitExecuteContext executeContext;
        private SubmitAction action;
        private Map<String, Object> parameter;
        private String actionId;
        private List<Map<String, Object>> submitParas;
        private String newProcessVariableName;
        private String[] newProcessFieldList;
        private HashMap paras;
        private String tenantId;

        public SubmitParameter(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
            this.executeContext = executeContext;
            this.action = action;
            this.parameter = parameter;
        }

        public SubmitParameter(String actionId, HashMap paras, String tenantId) {
            this.actionId = actionId;
            this.paras = paras;
            this.tenantId = tenantId;
        }

        public String getActionId() {
            return actionId;
        }

        public List<Map<String, Object>> getSubmitParas() {
            return submitParas;
        }

        public String getNewProcessVariableName() {
            return newProcessVariableName;
        }

        public String[] getNewProcessFieldList() {
            return newProcessFieldList;
        }

        public HashMap getParas() {
            return paras;
        }

        public String getTenantId() {
            return tenantId;
        }

        public SubmitParameter invoke() {
            if (action == null || parameter == null
                    || executeContext == null
                    || executeContext.getBacklogId() == null
                    || executeContext.getBpmData() == null
                    || action.getParas() == null
                    || action.getParas().size() == 0
                    || action.getExtendParas() == null
                    || action.getExtendParas().size() == 0) {
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0011.getErrCode(), messageUtils.getMessage("exception.data.reassignment.action.error"));
            }
            //抓到关联的流程变量,需要发起的新的活动id
            Map<String, Object> bpmParas = executeContext.getBpmData();
            actionId = null;
            if (bpmParas.containsKey("actionId")) {
                actionId = bpmParas.get("actionId").toString();
            }

            //获取活动参数中做查询的数据、提交的数据、需要处理的数据
            submitParas = null;
//        String compareFields = null;
//        //当前任务用来查询数据的变量名
//        String processVariableName = "";
            //新的流程中需要传递的参数集合
            String newProcessFields = null;
            //提交数据的变量名，根据这个名称来获取提交的数据集合
            String submitVariableName = "";
            //发起新的流程中携带数据的变量名
            newProcessVariableName = "";
            for (Map.Entry<String, Object> stringObjectEntry : action.getExtendParas().entrySet()) {
                switch (stringObjectEntry.getKey()) {
                    case "actionId":
                        actionId = stringObjectEntry.getValue().toString();
                        break;
                    case "newProcessVariableName":
                        newProcessVariableName = stringObjectEntry.getValue().toString();
                        break;
    //                case "processVariableName":
    //                    processVariableName = stringObjectEntry.getValue().toString();
    //                    break;
                    case "submitVariableName":
                        submitVariableName = stringObjectEntry.getValue().toString();
                        if (parameter.containsKey(submitVariableName)) {
                            submitParas = (List<Map<String, Object>>) parameter.get(submitVariableName);
                        } else {
                            throw BusinessException.create(ErrorCodeEnum.NUM_500_0012.getErrCode(), String.format(messageUtils.getMessage("exception.submit.data.error"), submitVariableName));
                        }
                        break;
    //                case "dataKeys":
    //                    compareFields = stringObjectEntry.getValue().toString();
    //                    break;
                    case "newProcessFields":
                        newProcessFields = stringObjectEntry.getValue().toString();
                        break;
                }
            }
            if (StringUtils.isEmpty(actionId)) {
                throw new IllegalArgumentException("actionId is empty");
            }
            if (StringUtils.isEmpty(newProcessVariableName)) {
                throw new IllegalArgumentException("newProcessVariableName is empty");
            }
            if (newProcessFields == null || "".equals(newProcessFields)) {
                throw new IllegalArgumentException("newProcessFields is empty");
            }

            //把提交的部分数据发起新的流程
            newProcessFieldList = newProcessFields.split(";");
            paras = new HashMap();
            for (String key : newProcessFieldList) {
                if (parameter.containsKey(key)) {
                    if (key.equals(submitVariableName)){
                        paras.put(newProcessVariableName, submitParas);

                    }else {
                        paras.put(newProcessVariableName, parameter.get(key));
                    }
                } else {
                    paras.put(key, bpmParas.get(key));
                }
            }
            String backlogId = action.getExecuteContext().getBacklogId().toString();
            paras.put("backlogId", backlogId);
            //paras.put("originalQueryVariableName", processVariableName);
            //paras.put("originalProcessSerialNumber", action.getExecuteContext().getProcessSerialNumber());
            //paras.put("dataKeys", compareFields);
            paras.putAll(action.getParas());
            paras.put("activityId",executeContext.getTmActivityId());
            paras.put("performerId", executeContext.getAuthoredUser().getUserId());
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            tenantId = authoredUser.getTenantId();
            if(StringUtils.isEmpty(tenantId) && !StringUtils.isEmpty(AppAuthContextHolder.getContext().getProxyToken())){
                authoredUser = tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
                tenantId = authoredUser.getTenantId();
            }
            return this;
        }
    }
}
