package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.dataUniformity.DataUniformityMongodbService;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *
 * @Author：SYQ
 * @Date：2022/5/16 17:01
 */
@Order(100)
@Slf4j
@Service("dataUniformityExecutor")
public class DataUniformityExecutor implements ActionExecutor {

    @Autowired
    private DataUniformityMongodbService mongodbService;

    @Autowired
    private TerminateDataExecutor terminateDataExecutor;

    @Autowired
    private CommonAtmcService atmcService;

    @Autowired
    private CommonSmartDataService commonSmartDataService;

    @Autowired
    private MessageUtils messageUtils;

    private static String ACTION_ID = "atmc_data_uniformity_submit";


    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT + ACTION_ID;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
//        log.info("【数据一致性任务卡提交】SubmitExecuteContext：{}，SubmitAction：{}，data：{}",executeContext,action,data);
        String schema = action.getSubmitType().getSchema();
        if(StringUtils.isEmpty(schema)){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0040.getErrCode(), "schema" + messageUtils.getMessage("exception.param.empty"));
        }
        //中止配置
        Map<String, Object> extendParas = action.getExtendParas();
        //提交的数据
        List<Map<String,Object>> submitDataList = getSubmitPageDataList(data,schema);
        //需要中止的数据
        List<Map<String,Object>> endDataList = submitDataList.stream().filter(x -> "end".equals(x.get("data_uniformity_dealType"))).collect(Collectors.toList());
        //需要放弃侦测的数据
        List<Map<String,Object>> giveupList = new ArrayList<>();
        //需要恢复侦测的数据
        List<Map<String,Object>> recoverList = new ArrayList<>();
        //判断中止数据需要的参数是否存在
        if(CollectionUtils.isNotEmpty(endDataList)){
            checkExtendParas(extendParas,schema,endDataList.get(0).get("bkKeys"));
        }
        //中止数据
        if(CollectionUtils.isNotEmpty(endDataList)){
            Map<String,Object> endData = JsonUtils.jsonToObject(JsonUtils.objectToString(data),Map.class);
            String submitVariableName = extendParas.get("submitVariableName").toString();
            endData.put(submitVariableName,endDataList);
            terminateDataExecutor.execute(executeContext,parentExecuteResult,action,endData);
            //更改checkComplemateAction里的paras
//            getCheckComplemateAction(executeContext,action);
        }
        //修改mongodb中的数据
        String collection = executeContext.getAuthoredUser().getTenantId();
        for(Map<String,Object> dataMap : submitDataList){
            String dealType = dataMap.get("data_uniformity_dealType").toString();
            dataMap.put("dealType",dealType);

            Long workitemId = Long.valueOf(dataMap.get("workitemId").toString());
            //调用sd需要的入参
            Map<String,Object> sdMap = new HashMap<>();
            sdMap.put("tenantId",collection);
            sdMap.put("tempId",executeContext.getTmActivityId());
            sdMap.put("type","activity");
            sdMap.put("entityName",dataMap.get("entityName"));
            sdMap.put("bk",dataMap.get("bk"));
            //调用sd接口放弃或者恢复数据一致性侦测
            if("end".equals(dealType)){
                Map workitemMap = atmcService.getBpmWorkItemById(workitemId);
                sdMap.put("instanceId",workitemMap.get("activityStepId").toString());
                giveupList.add(sdMap);
            }else{
                recoverList.add(sdMap);
            }
        }
        mongodbService.updateDealType(collection,submitDataList);
        mongodbService.recordSubmittedData(collection,executeContext.getAbnormalWorkitemId(),data);
        //删除侦测
        for(Map<String,Object> sdMap : giveupList){
            commonSmartDataService.giveupComparisonData(sdMap);
        }
        //恢复侦测
        for(Map<String,Object> sdMap : recoverList){
            commonSmartDataService.recoverComparisonData(sdMap);
        }
        //关闭数据一致性异常排除任务卡
        atmcService.closeDataUniformityBacklog(executeContext.getAbnormalWorkitemId(),ACTION_ID,executeContext.getDataFrom());

        ExecuteResult executeResult = new ExecuteResult();
        executeResult.setCompleted(true);
        return executeResult;
    }


    private void checkExtendParas(Map<String, Object> extendParas, String schema, Object bkKeys) {
        if (MapUtils.isEmpty(extendParas) || !extendParas.containsKey("dataKeys")
                || !extendParas.containsKey("processVariableName")
                || !extendParas.containsKey("submitVariableName")) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0039.getErrCode(), messageUtils.getMessage("exception.dataUniformity.attachAction.lack.config"));
        }
        if(null == extendParas.get("submitVariableName")){
            extendParas.put("submitVariableName",schema);
        }
        extendParas.put("dataKeys",bkKeys);
    }


    private List<Map<String, Object>> getSubmitPageDataList(Map<String, Object> data, String submitVariableName) {
        if (MapUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) data.get(submitVariableName);
    }


    //无用代码，先注释掉
    /*private void getCheckComplemateAction(SubmitExecuteContext executeContext, SubmitAction action){
        List<Map> pageDefineList = uiBotService.queryDataUniformityPageDefine(executeContext.getTmProjectId(),executeContext.getTmActivityId(),executeContext.getBacklogId().toString());
        if(CollectionUtils.isEmpty(pageDefineList)){
            return;
        }
        Map<String,Object> allParas = new HashMap<>();
        String paramKey = "";
        for (Map pageDefineMap : pageDefineList){
            DataSourceSetDTO dataSourceSetDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(pageDefineMap.get("dataSourceSet")),DataSourceSetDTO.class);
            List<DataSourceDTO> dataSourceDTOList = dataSourceSetDTO.getDataSourceList();
            for(DataSourceDTO dataSource : dataSourceDTOList){
                QueryAction queryAction = dataSource.getAction();
                Map<String,Object> paras = queryAction.getParas();
                for (Map.Entry entry : paras.entrySet()){
                    paramKey = entry.getKey().toString();
                    List<Object> paramList = new ArrayList<>();
                    if(allParas.containsKey(paramKey) && allParas.get(paramKey) != null){
                        paramList = (List<Object>) allParas.get(paramKey);
                    }
                    if(entry.getValue() instanceof Collection){
                        paramList.addAll((List<Object>) entry.getValue());
                    }else{
                        paramList.add(entry.getValue());
                    }
                    allParas.put(paramKey,paramList);
                }
            }
        }
        //修改查询参数
        DataSourceDTO checkCompleteAction = action.getCheckCompleteAction();
        checkCompleteAction.getAction().setParas(allParas);
        //判断是否存在left，如果存在需要将left里的查询参数也替换掉
        if(checkCompleteAction.getLeft() != null){
            checkCompleteAction.getLeft().getAction().setParas(allParas);
        }
    }*/


}
