package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Order(110)
@Service("delete-activity-bpm-variable-value")
class DeleteActivityBpmVariableActionExecutor implements ActionExecutor {

    @Autowired
    CommonAtmcService atmcService;

    @Autowired
    MessageUtils messageUtils;


    /**
     * 处理的类型是什么
     *
     * @return
     */
    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_UIBOT + ActionConstants.SPLIT + "delete-activity-bpm-variable-value";
    }


    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        check(action,parameter);
        SubmitExecuteContext submitExecuteContext = action.getExecuteContext();
        delActivityVariable(executeContext, new SubmitParameter(submitExecuteContext.getBacklogId(),submitExecuteContext.getBpmData(), parameter,action.getExtendParas()).invoke());
        return ExecuteResult.ok();
    }

    @Override
    public ExecuteResult execute(ActionExecuteReq actionExecuteReq) {
        SubmitAction action = actionExecuteReq.getAction();
        SubmitExecuteContext executeContext = actionExecuteReq.getSubmitExecuteContext();
        if(executeContext.isMinSplit()){
            Map<Long, Map<String, Object>> workItemIdToBpmData = executeContext.getWorkItemIdToBpmData();
            Map<Long, Map<String, Object>> workItemIdToData = actionExecuteReq.getWorkItemIdToData();
            workItemIdToData.forEach((k,v)->{
                delActivityVariable(executeContext, new SubmitParameter(k,workItemIdToBpmData.get(k),v,action.getExtendParas()).invoke());
            });
            return ExecuteResult.ok();
        }else {
            return ActionExecutor.super.execute(actionExecuteReq);
        }
    }

    private void check(SubmitAction action, Map<String, Object> parameter){
        if (action == null || parameter == null
                || action.getExecuteContext() == null
                || action.getExecuteContext().getBacklogId() == null
                || action.getExecuteContext().getBpmData() == null
                || action.getExtendParas() == null
                || action.getExtendParas().size() == 0) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0017.getErrCode(), messageUtils.getMessage("exception.delete.activity.bpm.variable.value"));
        }
    }

    private void delActivityVariable(SubmitExecuteContext executeContext,SubmitParameter submitParameter){
        Map<String, Object> bpmParas = submitParameter.getBpmParas();
        // 流程的变量
        List<Map<String, Object>> queryParas = submitParameter.getQueryParas();
        String compareFields = submitParameter.getCompareFields();
        String processVariableName = submitParameter.getProcessVariableName();
        Set<String> submitKeys = submitParameter.getSubmitKeys();


        //如果参数列表和提交的数据集合一致，说明是全部提交，直接推送流程往下走，不需要发起新的流程来处理
        if (queryParas != null && !submitKeys.isEmpty()) {
            if (queryParas.size() == submitKeys.size()) {
                atmcService.emptyActivityData(getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                if (executeContext.getParentAction() != null) {
                    executeContext.getParentAction().setCheckCompleteAction(null);
                }
            } else {
                // dataKeys
                String[] fields = compareFields.split(UiBotConstants.SEMICOLON);
                //重置代办项中提交的参数
                List<Map<String, Object>> newQueryPara = new ArrayList<>();
                List<Map<String, Object>> deleteQueryPara = new ArrayList<>();
                for (Map<String, Object> queryPara : queryParas) {
                    StringBuilder queryKey = new StringBuilder();
                    for (String field : fields) {
                        if (queryPara.containsKey(field)) {
                            queryKey.append(queryPara.get(field).toString()).append(UiBotConstants.SEMICOLON);
                        } else {
                            queryKey.append(UiBotConstants.SEMICOLON);
                        }
                    }
                    // 不包含的代表留下来
                    if (!submitKeys.contains(queryKey.toString())) {
                        newQueryPara.add(queryPara);
                    } else {
                        deleteQueryPara.add(queryPara);
                    }
                }
                bpmParas.put(processVariableName, newQueryPara);
                // 最小化肯定是全部清楚的
                if (deleteQueryPara.size() == queryParas.size()) {
                    //仍然是全部清除，因为如果是单身单身的页面的话，业务主键会只指定一个，但查询是参数会指定多个
                    atmcService.emptyActivityData(getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                    if (executeContext.getParentAction() != null) {
                        executeContext.getParentAction().setCheckCompleteAction(null);
                    }
                } else {
                    boolean needResetActivityData = true;
                    if (CollectionUtils.isNotEmpty(deleteQueryPara) && executeContext.getParentAction() != null && executeContext.getParentAction().getCheckCompleteAction() != null) {
                        if (deleteQueryPara.size() == queryParas.size()) {
                            //全部删除，直接清空checkComplete
                            executeContext.getParentAction().setCheckCompleteAction(null);
                        } else {
                            //去除本次清除的参数
                            QueryAction checkAction = executeContext.getParentAction().getCheckCompleteAction().getAction();
                            String dataKey = this.parseCheckActionParaDataKey(checkAction, processVariableName);
                            if (checkAction.getParas() != null && checkAction.getParas().containsKey(dataKey)) {
                                List<Map<String, Object>> checkActionParas = (List<Map<String, Object>>) checkAction.getParas().get(dataKey);

                                for (Map<String, Object> deletePara : deleteQueryPara) {
                                    StringBuilder deleteKey = new StringBuilder();
                                    for (String field : fields) {
                                        if (deletePara.containsKey(field)) {
                                            deleteKey.append(deletePara.get(field).toString()).append(UiBotConstants.SEMICOLON);
                                        } else {
                                            deleteKey.append(UiBotConstants.SEMICOLON);
                                        }
                                    }

                                    for (Map<String, Object> checkPara : checkActionParas) {
                                        StringBuilder checkKey = new StringBuilder();
                                        for (String field : fields) {
                                            if (checkPara.containsKey(field)) {
                                                checkKey.append(checkPara.get(field).toString()).append(UiBotConstants.SEMICOLON);
                                            } else {
                                                checkKey.append(UiBotConstants.SEMICOLON);
                                            }
                                        }

                                        if (Objects.equals(deleteKey.toString(), checkKey.toString())) {
                                            checkActionParas.remove(checkPara);
                                            break;
                                        }
                                    }
                                }

                                if (CollectionUtils.isEmpty(checkActionParas)) {
                                    //全部删除，直接清空checkComplete
                                    //仍然是全部清除，因为如果是单身单身的页面的话，业务主键会只指定一个，但查询是参数会指定多个
                                    atmcService.emptyActivityData(getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                                    if (executeContext.getParentAction() != null) {
                                        executeContext.getParentAction().setCheckCompleteAction(null);
                                    }

                                    needResetActivityData = false;
                                }
                            }
                        }
                    }

                    if (needResetActivityData) {
                        //清除部分
                        atmcService.resetActivityData(getResetParameter(submitParameter.getBacklogId(), processVariableName, compareFields, bpmParas));
                    }
                }
            }
        }
    }

    private String parseCheckActionParaDataKey(QueryAction checkAction, String processVariableName) {
        String dataKey = processVariableName;
        // checkAction.paras中包含dataKey
        if (Objects.isNull(checkAction.getParas()) || checkAction.getParas().containsKey(dataKey)) {
            return dataKey;
        }
        // checkAction.Paras中只有一个键值对
        if (checkAction.getParas().size() == 1) {
            return checkAction.getParas().keySet().toArray()[0].toString();
        }
        // 从actionParams中解析出dataKey
        if (CollectionUtils.isNotEmpty(checkAction.getActionParams())) {
            /**
             * 比如 checkAction.actionParams中有如下配置：
             * {
             *     "name": "cim_wo_routing",
             *     "type": "PROCESS_VARIABLE",
             *     "value": "cim_wo_routing_all"
             * }
             *
             * UIBOT在解析时，会从bpmData中取出cim_wo_routing_all，并以cim_wo_routing作为key，放入到checkAction.paras中。
             * 因此这边需返回解析后的key（name)
             */
            for (ActionParameterMapping actionParam : checkAction.getActionParams()) {
                if (StringUtils.equals(actionParam.getType(), ActivityConstants.TASK_QUERY_PROCESS_VARIABLE)
                        && StringUtils.equals(actionParam.getValue(), processVariableName)) {
                    dataKey = actionParam.getName();
                    break;
                }
            }
        }

        return dataKey;
    }

    private Map<String, Object> getResetParameter(Long backlogId, String processVariableName, String dataKeys, Map<String, Object> bpmData) {
        Map<String, Object> map = new HashMap<>();

        map.put("workItemId", backlogId);
        map.put("dataKeys", dataKeys);
        map.put("processVariableName", processVariableName);
        map.put("bpmData", bpmData);

        return map;
    }
//    @Override
//    protected ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
//        SubmitParameter submitParameter = new SubmitParameter(action, parameter).invoke();
//
//        Map<String, Object> bpmParas = submitParameter.getBpmParas();
//        List<Map<String, Object>> queryParas = submitParameter.getQueryParas();
//        String compareFields = submitParameter.getCompareFields();
//        String processVariableName = submitParameter.getProcessVariableName();
//        Set<String> submitKeys = submitParameter.getSubmitKeys();
//
//        //region模拟执行,将参数放到 extendParas 中。
//        Map<String,Object> extendParas = action.getExtendParas();
//        Map<String,Object> startNewProcessMap = new HashMap<>();
//        startNewProcessMap.put("backlogId", submitParameter.getBacklogId());
//        //如果参数列表和提交的数据集合一致，说明是全部提交，直接推送流程往下走，不需要发起新的流程来处理
//        if (queryParas != null && submitKeys.size() > 0) {
//            if (queryParas.size() == submitKeys.size()) {
//                startNewProcessMap.put("bpmParas",null);
////                atmcService.emptyActivityData(backlogId);
//                if(executeContext.getParentAction()!=null){
//                    executeContext.getParentAction().setCheckCompleteAction(null);
//                }
//            } else {
//                String[] fields = compareFields.split(UiBotConstants.SEMICOLON);
//                //重置代办项中提交的参数
//                List<Map<String, Object>> newQueryPara = new ArrayList<>();
//                for (Map<String, Object> queryPara : queryParas) {
//                    StringBuilder queryKey = new StringBuilder();
//                    for (String field : fields) {
//                        if (queryPara.containsKey(field)) {
//                            queryKey.append(queryPara.get(field).toString()).append(UiBotConstants.SEMICOLON);
//                        } else {
//                            queryKey.append(UiBotConstants.SEMICOLON);
//                        }
//                    }
//                    if (!submitKeys.contains(queryKey.toString())) {
//                        newQueryPara.add(queryPara);
//                    }
//                }
//                bpmParas.put(processVariableName, newQueryPara);
//                startNewProcessMap.put("bpmParas",bpmParas);
//            }
//        }
//        if (action!= action.getMergeDataAction()) {
//            //把所有数据合并到指定的action上
//            List<Map<String, Object>> mergedData = (List<Map<String, Object>>) action.getMergeDataAction().getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
//            mergedData.add(startNewProcessMap);
//        }else {
//            //region模拟执行,将参数放到 extendParas 中。
//            List<Map>  allParameter = new ArrayList<>();
//            allParameter.add(startNewProcessMap);
//            extendParas.put(UiBotConstants.MERGED_SUBMIT_DATA, allParameter);
//        }
//        return ExecuteResult.ok();
//    }
//
//    @Override
//    protected ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter) {
//        //合并的任务，直接用准备好的参数执行
//       List<Map<String, Object>> paras = (List<Map<String, Object>> ) action.getExtendParas().get(UiBotConstants.MERGED_SUBMIT_DATA);
//        for (Map<String, Object> para : paras) {
//            String backlogId = para.get("backlogId").toString();
//            Object bpmParas = para.get("bpmParas");
//            if (bpmParas ==null){
//                atmcService.emptyActivityData(backlogId);
//            }else {
//                atmcService.resetActivityData(backlogId,(Map<String, Object>) bpmParas);
//            }
//        }
//
//        return ExecuteResult.ok();
//    }

    /**
     * 有关扩展参数的说明：
     *
     * "extendParas": {
     *      // 关键字
     *     "dataKeys": "requisitions_no;requisitions_seq",
     *     // 流程变量
     *     "processVariableName": "requisitions_info",
     *     // 提交变量的单头字段
     *     "submitVariableName": "M",
     *     // 提交变量的单身字段
     *     "detailField": "D"
     * }
     */
    private class SubmitParameter {
        private Long backlogId;
        private Map<String, Object> parameter;
        private Map<String, Object> bpmParas;
        private List<Map<String, Object>> queryParas;
        private String compareFields;
        private String processVariableName;
        private Set<String> submitKeys;

        private Map<String, Object> extendParas;

        public SubmitParameter(Long backlogId,Map<String, Object> bpmParas,Map<String, Object> parameter,Map<String, Object> extendParas) {
            this.parameter = parameter;
            this.backlogId = backlogId;
            this.bpmParas = bpmParas;
            this.extendParas = extendParas;
        }

        public Long getBacklogId() {
            return backlogId;
        }

        public Map<String, Object> getBpmParas() {
            return bpmParas;
        }

        public List<Map<String, Object>> getQueryParas() {
            return queryParas;
        }

        public String getCompareFields() {
            return compareFields;
        }

        public String getProcessVariableName() {
            return processVariableName;
        }

        public Set<String> getSubmitKeys() {
            return submitKeys;
        }



        public SubmitParameter invoke() {
            // 抓到关联的流程变量,需要发起的新的活动id
            // 获取活动参数中做查询的数据、提交的数据、需要处理的数据
            queryParas = null;
            // 提交的数据
            List<Map<String, Object>> submitParas = null;
            compareFields = null;
            processVariableName = "";
            String submitVariableName = "";
            for (Map.Entry<String, Object> extendParasEntry : extendParas.entrySet()) {
                switch (extendParasEntry.getKey()) {
                    case "processVariableName":
                        processVariableName = String.valueOf(extendParasEntry.getValue());
                        if (bpmParas.containsKey(processVariableName)) {
                            Object procVarObj = bpmParas.get(processVariableName);
                            if (null != procVarObj) {
                                if (procVarObj instanceof Map) {
                                    queryParas = new ArrayList<>();
                                    queryParas.add((Map<String, Object>) procVarObj);
                                } else if (procVarObj instanceof List) {
                                    queryParas = (List<Map<String, Object>>) procVarObj;
                                } else {
                                    throw BusinessException.create(ErrorCodeEnum.NUM_500_0018.getErrCode(), String.format(messageUtils.getMessage("exception.bpm.data.type.error"), processVariableName));
                                }
                            }
                        } else {
                            throw BusinessException.create(ErrorCodeEnum.NUM_500_0019.getErrCode(), String.format(messageUtils.getMessage("exception.bpm.data.empty"), processVariableName));
                        }
                        break;
                    case "submitVariableName":
                        submitVariableName = String.valueOf(extendParasEntry.getValue());
                        if (parameter.containsKey(submitVariableName)) {
                            // 单头处理
                            submitParas =  getSubmitParas(Lists.newArrayList(parameter), submitVariableName);
                            // 单身处理
                            String detailField = StrUtil.toStringOrNull(extendParas.get("detailField"));
                            submitParas =  getSubmitParas(submitParas, detailField);
                        } else {
                            throw BusinessException.create(ErrorCodeEnum.NUM_500_0021.getErrCode(), String.format(messageUtils.getMessage("exception.bpm.data.empty"), submitVariableName));
                        }
                        break;
                    case "dataKeys":
                        compareFields = String.valueOf(extendParasEntry.getValue());
                        break;
                }
            }
            submitKeys = new HashSet<>();
            // 提交的数据需要和流程变量的值一致校验和增加提交的key
            if (queryParas != null && null != compareFields && !"".equals(compareFields)) {
                String[] fields = compareFields.split(UiBotConstants.SEMICOLON);
                // 调整流程的数据，没有提交的删除
                for (Map<String, Object> submitPara : submitParas) {
                    StringBuilder submitKeyStringBuilder = new StringBuilder();
                    for (String field : fields) {
                        if (submitPara.containsKey(field)) {
                            submitKeyStringBuilder.append(submitPara.get(field)).append(UiBotConstants.SEMICOLON);
                        } else {
                            submitKeyStringBuilder.append(UiBotConstants.SEMICOLON);
                        }
                    }
                    boolean isFind = false;
                    for (Map<String, Object> processPara : queryParas) {
                        StringBuilder processKeyStringBuilder = new StringBuilder();
                        for (String field : fields) {
                            if (processPara.containsKey(field)) {
                                processKeyStringBuilder.append(processPara.get(field)).append(UiBotConstants.SEMICOLON);
                            } else {
                                processKeyStringBuilder.append(UiBotConstants.SEMICOLON);
                            }
                        }
                        if (CharSequenceUtil.equals(processKeyStringBuilder, submitKeyStringBuilder)) {
                            submitKeys.add(submitKeyStringBuilder.toString());
                            for (Map.Entry<String, Object> processParaEntry : processPara.entrySet()) {
                                if (!submitPara.containsKey(processParaEntry.getKey())) {
                                    submitPara.put(processParaEntry.getKey(), processParaEntry.getValue());
                                }
                            }
                            isFind = true;
                            break;
                        }
                    }
                    if (!isFind) {
                        throw BusinessException.create(ErrorCodeEnum.BUSINESS_600_0002.getErrCode(),
                                submitKeyStringBuilder + messageUtils.getMessage("exception.not.find"));
                    }
                }
            }
            return this;
        }
    }

    /**
     * 获取提交参数
     *
     * @param paramList 数据来源
     * @param field     字段名
     * @return 数据
     */
    private List<Map<String, Object>> getSubmitParas(List<Map<String, Object>> paramList, String field) {
        if (StringUtils.isBlank(field)) {
            return paramList;
        }
        List<Map<String, Object>> submitParas = Lists.newArrayList();
        for (Map<String, Object> param : paramList) {
            Object paramValueObj = param.get(field);
            if (paramValueObj instanceof Map) {
                submitParas.add((Map<String, Object>) paramValueObj);
            } else if (paramValueObj instanceof Collection) {
                submitParas.addAll((List<Map<String, Object>>) paramValueObj);
            } else {
                throw BusinessException.create(ErrorCodeEnum.NUM_500_0020.getErrCode(),
                        messageUtils.getMessage("exception.submit.data2")
                                + field
                                + messageUtils.getMessage("exception.data.type.error"));
            }
        }
        return submitParas;
    }
}
