package com.digiwin.athena.atdm.action.executor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.dto.CacheDto;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.datasource.domain.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Order(0)
@Service("PrintActionExecutor")
class PrintActionExecutor implements ActionExecutor {

    @Autowired
    private CommonAtmcService atmcService;

    @Autowired
    private CommonUiBotService commonUiBotService;


    /**
     * 处理的类型是什么
     *
     * @return
     */
    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_ATMC_PRINT + ActionConstants.SPLIT;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        ExecuteResult executeResult = new ExecuteResult();
        BusinessConfig businessConfig = action.getBusinessConfig();
        if (null == businessConfig) {
            return executeResult;
        }
        // 数据处理，ABI报表要求入参为LIST,当遇到提交的数据为对象时，需要处理转换数据
        data = convertData(data);
        // 查询报表配置
        StatementConfig statementConfig = commonUiBotService.getStatementConfig(businessConfig.getActivityId());
        // 获取报表本身action,然后结合data 调用atmc接口，将页面查询abi 报表所需的入参，提前放入acmc缓存
        if (null != statementConfig && CollectionUtils.isNotEmpty(statementConfig.getSubmitActions()) && MapUtil.isNotEmpty(statementConfig.getExtendedFields())) {
            // 放入调用ABI报表的数据
            CacheDto cacheDto = atmcService.setBICache(statementConfig.getSubmitActions().get(0), data);
            // 获取报表resid
            cacheDto.setResId(StringUtils.isNotBlank(businessConfig.getBusinessId())? businessConfig.getBusinessId():String.valueOf(statementConfig.getExtendedFields().get("STATEMENT__resid_" + executeContext.getLocale())));
            // 响应前端缓存的key
            executeResult.setData(BeanUtil.beanToMap(cacheDto));
        }
        return executeResult;
    }

    /**
     * 数据处理
     * @param data
     * @return
     */
    private Map<String, Object> convertData(Map<String, Object> data) {

        Map<String, Object> dataNew = new HashMap<>();
        for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
            if(dataEntry.getValue() instanceof Map){
                List<Object> o = new ArrayList<>();
                o.add(dataEntry.getValue());
                dataNew.put(dataEntry.getKey(), o);
            }
        }
        if (MapUtils.isNotEmpty(dataNew)) {
            data = dataNew;
        }
        return data;
    }

}
