package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.dto.UserDTO;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * PTM-普通人工任务-转派
 */
@Order(100)
@Service("ptmManualReassignActionExecutor")
class PtmManualReassignActionExecutor extends TaskEngineActionExecutorBase {

    @Autowired
    private CommonPtmService commonPtmService;

    @Autowired
    private CommonUserService commonUserService;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_PTM + ActionConstants.SPLIT+ "manual-reassign" ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }
    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {

        setProcessVariables(action,parameter);
        SubmitAction newAction = translateAction(executeContext, action);
        commonPtmService.execute(newAction);
        ExecuteResult result = ExecuteResult.ok();
        result.setCompleted(true);
        return result;
    }

    private SubmitAction translateAction(SubmitExecuteContext executeContext, SubmitAction submitAction){
        SubmitAction action = new SubmitAction();
        Map<String,Object> oldParas = submitAction.getParas();
        Map ptmData = executeContext.getPtmData();

        Map<String,Object> paras = new HashMap<>();
        paras.put("backlogId", ptmData.get("ptmBacklogId"));        //除ptm之外的任务，如果是合并的话，backlogId是合并前的，这里ptmBacklogId是合并后的总id
        paras.put("performerType", oldParas.get("performerType"));
        paras.put("newPerformerId", oldParas.get("performerId"));
        paras.put("newPerformerName", oldParas.get("performerId"));
        UserDTO userDTO = commonUserService.query(MapUtils.getString(oldParas,"performerId"), AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        if(userDTO!=null){
            paras.put("newPerformerName", userDTO.getName());
        }
        if(oldParas.containsKey("comment")){
            paras.put("comment", oldParas.get("comment"));
        }
        action.setParas(paras);

        ActionServiceId serviceId = new ActionServiceId();
        serviceId.setName(submitAction.getServiceId().getName());
        serviceId.setServiceUri(submitAction.getServiceId().getServiceUri());
        action.setServiceId(serviceId);

        return action;
    }

}
