package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 保存库存水位机制的数据
 */
@Service(ActionConstants.ACTION_NAME_SAVE_MECHANISM_SUGGESTION)
public class SaveMechanismSuggestionExecutor implements ActionExecutor {

    @Autowired
    private TmActionExecutor tmActionExecutor;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_UIBOT +ActionConstants.SPLIT+ ActionConstants.ACTION_NAME_SAVE_MECHANISM_SUGGESTION ;
    }

    @Override
    public boolean hasActionMetadata() {
        return false;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        Map<String, Object> mechanismFormulaData = (Map<String, Object>) data.get("mechanismFormula");
        if (mechanismFormulaData == null || !mechanismFormulaData.containsKey("newFormula")) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0036.getErrCode(), messageUtils.getMessage("exception.submit.data.lack.mechanismFormula.newFormula"));
        }

        Map<String, Object> submitData = (Map<String, Object>) mechanismFormulaData.get("newFormula");
        List<String> dataKeyList = new ArrayList<>();
        dataKeyList.add("item_no");
        submitData.put("valueKeys", dataKeyList);

        mechanismFormulaData = new HashMap<>();
        mechanismFormulaData.put("data", submitData);
        tmActionExecutor.execute(null,null,action,mechanismFormulaData);

        return ExecuteResult.ok();
    }

}
